/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.platform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

public class GameObject<T> {
    private final class_2960 id;
    private final Supplier<? extends T> sup;
    private T value;

    private GameObject(class_2960 id, Supplier<? extends T> sup) {
        this.id = id;
        this.sup = sup;
    }

    public T get() {
        return this.value;
    }

    protected T make() {
        this.value = this.sup.get();
        return this.value;
    }

    public class_2960 getId() {
        return this.id;
    }

    public static class GameObjectBlockEntity<T extends class_2586>
    extends GameObject<class_2591<T>> {
        private List<GameObject<? extends class_2248>> blocks;

        public GameObjectBlockEntity(String name, List<GameObject<? extends class_2248>> blocks, class_2591.class_5559<T> factory) {
            super(class_2960.method_43902((String)"toms_storage", (String)name), () -> class_2591.class_2592.method_20528((class_2591.class_5559)factory, (class_2248[])((class_2248[])blocks.stream().map(GameObject::get).toArray(class_2248[]::new))).method_11034(null));
            this.blocks = blocks;
        }

        public void addBlocks(GameObject<? extends class_2248> ... blocks) {
            this.blocks.addAll(Arrays.asList(blocks));
        }
    }

    public static class GameRegistryBE
    extends GameRegistry<class_2591<?>> {
        public GameRegistryBE(class_2378<class_2591<?>> registry) {
            super(registry);
        }

        public <BE extends class_2586, I extends class_2591<BE>> GameObjectBlockEntity<BE> registerBE(String name, class_2591.class_5559<BE> sup, GameObject<? extends class_2248> ... blocks) {
            GameObjectBlockEntity<BE> e = new GameObjectBlockEntity<BE>(name, new ArrayList<GameObject<? extends class_2248>>(Arrays.asList(blocks)), sup);
            this.toRegister.add(e);
            return e;
        }
    }

    public static class GameRegistry<T> {
        protected final class_2378<T> registry;
        protected List<GameObject<? extends T>> toRegister = new ArrayList<GameObject<? extends T>>();

        public GameRegistry(class_2378<T> registry) {
            this.registry = registry;
        }

        public <I extends T> GameObject<I> register(String name, Supplier<? extends I> sup) {
            GameObject<? extends I> obj = new GameObject<I>(class_2960.method_43902((String)"toms_storage", (String)name), sup);
            this.toRegister.add(obj);
            return obj;
        }

        public void runRegistration() {
            for (GameObject<T> gameObject : this.toRegister) {
                class_2378.method_10230(this.registry, (class_2960)gameObject.getId(), gameObject.make());
            }
        }
    }
}

