/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen;

import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.tom.storagemod.Config;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.menu.StorageTerminalMenu;
import com.tom.storagemod.screen.CraftingTerminalScreen;
import com.tom.storagemod.screen.PlatformContainerScreen;
import com.tom.storagemod.screen.widget.EnumCycleButton;
import com.tom.storagemod.screen.widget.TerminalSearchModeButton;
import com.tom.storagemod.screen.widget.ToggleButton;
import com.tom.storagemod.util.ComponentJoiner;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.NumberFormatUtil;
import com.tom.storagemod.util.PopupMenuManager;
import com.tom.storagemod.util.TerminalSyncManager;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_128;
import net.minecraft.class_1306;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6903;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractStorageTerminalScreen<T extends StorageTerminalMenu>
extends PlatformContainerScreen<T>
implements IDataReceiver {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60654((String)"container/creative_inventory/scroller");
    private static final class_2960 SCROLLER_DISABLED_SPRITE = class_2960.method_60654((String)"container/creative_inventory/scroller_disabled");
    private static final class_2960 FLOATING_SLOT = class_2960.method_43902((String)"toms_storage", (String)"widget/floating_slot");
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        class_310 mc = class_310.method_1551();
        class_1836.class_1837 flag = mc.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        return key.getStack().method_7950(class_1792.class_9635.method_59528((class_1937)mc.field_1687), (class_1657)mc.field_1724, (class_1836)flag).stream().map(class_2561::getString).collect(Collectors.toList());
    }));
    private static final LoadingCache<StoredItemStack, String> componentCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        class_6903 ctx = class_310.method_1551().field_1687.method_30349().method_57093((DynamicOps)JsonOps.COMPRESSED);
        return (String)class_9326.field_49589.encodeStart((DynamicOps)ctx, (Object)key.getStack().method_57380()).mapOrElse(JsonElement::toString, e -> "");
    }));
    private static final LoadingCache<StoredItemStack, List<String>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> key.getStack().method_40133().map(t -> t.comp_327().toString()).toList()));
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected class_342 searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    protected boolean ghostItems;
    protected boolean tallMode;
    public final int textureSlotCount;
    public final int guiHeight;
    public final int slotStartX;
    public final int slotStartY;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected EnumCycleButton<StoredItemStack.SortingTypes> buttonSortingType;
    protected EnumCycleButton<ControllMode> buttonCtrlMode;
    protected TerminalSearchModeButton buttonSearchType;
    protected ToggleButton buttonDirection;
    protected ToggleButton buttonGhostMode;
    protected ToggleButton buttonTallMode;
    private Comparator<StoredItemStack> sortComp;
    protected PopupMenuManager popup = new PopupMenuManager((class_437)this);
    private FakeSlot fakeSlotUnderMouse = new FakeSlot();

    public AbstractStorageTerminalScreen(T screenContainer, class_1661 inv, class_2561 titleIn, int textureSlotCount, int guiHeight, int slotStartX, int slotStartY) {
        super(screenContainer, inv, titleIn);
        ((StorageTerminalMenu)screenContainer).onPacket = this::onPacket;
        this.textureSlotCount = textureSlotCount;
        this.guiHeight = guiHeight;
        this.slotStartX = slotStartX;
        this.slotStartY = slotStartY;
    }

    protected void onPacket() {
        boolean tallMode;
        this.controllMode = (((StorageTerminalMenu)this.field_2797).modes & 0xF) % ControllMode.VALUES.length;
        boolean rev = (((StorageTerminalMenu)this.field_2797).sorting & 0x100) > 0;
        int type = ((StorageTerminalMenu)this.field_2797).sorting & 0xFF;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        int searchType = ((StorageTerminalMenu)this.field_2797).searchType;
        this.ghostItems = (((StorageTerminalMenu)this.field_2797).sorting & 0x200) == 0;
        boolean bl = tallMode = (((StorageTerminalMenu)this.field_2797).modes & 0x10) != 0;
        if (tallMode != this.tallMode) {
            this.tallMode = tallMode;
            this.method_25426();
        }
        if (searchType != -1) {
            if (!this.searchField.method_25370() && (searchType & 1) > 0) {
                this.searchField.method_25365(true);
            }
            this.buttonSearchType.setSearchType(searchType);
            if (!this.loadedSearch && ((StorageTerminalMenu)this.field_2797).search != null) {
                this.loadedSearch = true;
                if ((searchType & 2) > 0) {
                    this.searchField.method_1852(((StorageTerminalMenu)this.field_2797).search);
                }
            }
        }
        this.buttonSortingType.setState(StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length]);
        this.buttonDirection.setState(rev);
        this.buttonCtrlMode.setState(ControllMode.VALUES[this.controllMode]);
        this.buttonGhostMode.setState(this.ghostItems);
        this.buttonTallMode.setState(tallMode);
    }

    protected void sendUpdate() {
        class_2487 c = new class_2487();
        int sort = 0;
        sort |= this.comparator.type() & 0xFF;
        sort |= this.comparator.isReversed() ? 256 : 0;
        c.method_10569("s", sort |= this.ghostItems ? 0 : 512);
        c.method_10569("st", this.buttonSearchType.getSearchType());
        c.method_10569("m", this.writeModes());
        class_2487 msg = new class_2487();
        msg.method_10566("c", (class_2520)c);
        ((StorageTerminalMenu)this.field_2797).sendMessage(msg);
    }

    protected int writeModes() {
        int d = 0;
        d |= this.controllMode & 0xF;
        return d |= this.tallMode ? 16 : 0;
    }

    protected void method_25426() {
        this.method_37067();
        if (this.tallMode) {
            int guiSize = this.guiHeight - this.textureSlotCount * 18;
            this.rowCount = (this.field_22790 - 20 - guiSize) / 18;
            this.field_2779 = guiSize + this.rowCount * 18;
            ((StorageTerminalMenu)this.field_2797).setOffset(0, (this.rowCount - this.textureSlotCount) * 18);
            ((StorageTerminalMenu)this.field_2797).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        } else {
            this.rowCount = this.textureSlotCount;
            ((StorageTerminalMenu)this.field_2797).setOffset(0, 0);
            ((StorageTerminalMenu)this.field_2797).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        }
        class_1735 offh = ((StorageTerminalMenu)this.method_17577()).offhand;
        offh.field_7873 = this.field_22787.field_1690.method_42552().method_41753() == class_1306.field_6183 ? -26 : 186;
        this.field_25270 = this.field_2779 - 92;
        super.method_25426();
        class_327 class_3272 = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new class_342(class_3272, this.field_2776 + 82, this.field_2800 + 6, 89, 9, (class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_search"));
        this.searchField.method_1880(100);
        this.searchField.method_1858(false);
        this.searchField.method_1862(true);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.method_1852(this.searchLast);
        this.searchLast = "";
        this.method_25429((class_364)this.searchField);
        this.buttonSortingType = (EnumCycleButton)this.method_37063((class_364)new EnumCycleButton(this.field_2776 - 18, this.field_2800 + 5, (class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_sort"), "sort", (Enum[])StoredItemStack.SortingTypes.VALUES, n -> {
            this.comparator = n.create(this.comparator.isReversed());
            this.buttonSortingType.setState((StoredItemStack.SortingTypes)((Object)n));
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (ToggleButton)this.method_37063((class_364)ToggleButton.builder(this.field_2776 - 18, this.field_2800 + 5 + 18).name((class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_sort_rev")).iconOff(class_2960.method_43902((String)"toms_storage", (String)"icons/sort_desc")).iconOn(class_2960.method_43902((String)"toms_storage", (String)"icons/sort_asc")).build(n -> {
            this.comparator.setReversed(n);
            this.buttonDirection.setState(n);
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (TerminalSearchModeButton)this.method_37063((class_364)new TerminalSearchModeButton(this.field_2776 - 18, this.field_2800 + 5 + 36, this.popup, IAutoFillTerminal.hasSync() || this instanceof CraftingTerminalScreen, this::sendUpdate));
        this.buttonCtrlMode = (EnumCycleButton)this.method_37063((class_364)new EnumCycleButton(this.field_2776 - 18, this.field_2800 + 5 + 54, (class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_control"), "control", (Enum[])ControllMode.VALUES, n -> {
            this.controllMode = n.ordinal();
            this.buttonCtrlMode.setState((ControllMode)((Object)n));
            this.sendUpdate();
        }));
        this.buttonGhostMode = (ToggleButton)this.method_37063((class_364)ToggleButton.builder(this.field_2776 - 18, this.field_2800 + 5 + 72).name((class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_ghost_items")).iconOff(class_2960.method_43902((String)"toms_storage", (String)"icons/keep_last_off")).iconOn(class_2960.method_43902((String)"toms_storage", (String)"icons/keep_last_0")).build(n -> {
            this.ghostItems = n;
            this.buttonGhostMode.setState(n);
            this.sendUpdate();
        }));
        this.buttonGhostMode.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.ghostMode_off")), class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.ghostMode_on")));
        this.buttonTallMode = (ToggleButton)this.method_37063((class_364)ToggleButton.builder(this.field_2776 - 18, this.field_2800 + 5 + 90).name((class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_tall_mode")).iconOff(class_2960.method_43902((String)"toms_storage", (String)"icons/tall_terminal_off")).iconOn(class_2960.method_43902((String)"toms_storage", (String)"icons/tall_terminal_on")).build(n -> {
            this.tallMode = n;
            this.buttonTallMode.setState(n);
            this.sendUpdate();
            this.method_25426();
        }));
        this.buttonTallMode.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.tallMode_off")), class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.tallMode_on")));
        this.buttonSortingType.tooltipFactory = s -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("tooltip.toms_storage.sorting_" + s.name().toLowerCase(Locale.ROOT))));
        this.buttonCtrlMode.tooltipFactory = s -> class_7919.method_47407((class_2561)Arrays.stream(class_1074.method_4662((String)("tooltip.toms_storage.ctrlMode_" + s.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]).split("\\\\")).map(class_2561::method_43470).collect(ComponentJoiner.joining((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43470((String)"\n"))));
        this.updateSearch();
    }

    private static Pattern buildPattern(String s) {
        try {
            return Pattern.compile(s, 2);
        }
        catch (Throwable ignore) {
            try {
                return Pattern.compile(Pattern.quote(s), 2);
            }
            catch (Throwable ignored) {
                return null;
            }
        }
    }

    protected void updateSearch() {
        String searchString = this.searchField.method_1882();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            int i;
            ((StorageTerminalMenu)this.method_17577()).itemListClientSorted.clear();
            Object pred = null;
            String[] or = searchString.split("\\|");
            for (i = 0; i < or.length; ++i) {
                String part = or[i].trim();
                if (part.isEmpty()) continue;
                String[] sp = part.split(" ");
                Object p = Predicates.alwaysTrue();
                for (int j = 0; j < sp.length; ++j) {
                    Pattern m;
                    String fs;
                    String s = sp[j].toLowerCase();
                    if (s.startsWith("@")) {
                        fs = s.substring(1);
                        p = p.and(is -> class_7923.field_41178.method_10221((Object)is.getStack().method_7909()).method_12836().contains(fs));
                        continue;
                    }
                    if (s.startsWith("#")) {
                        fs = s.substring(1);
                        p = p.and(is -> {
                            try {
                                return ((List)tagCache.get(is)).stream().anyMatch(st -> st.contains(fs));
                            }
                            catch (Exception e) {
                                return false;
                            }
                        });
                        continue;
                    }
                    if (s.startsWith("$")) {
                        m = AbstractStorageTerminalScreen.buildPattern(s.substring(1));
                        if (m == null) continue;
                        p = p.and(is -> {
                            if (is.getStack().method_57380().method_57848()) {
                                return false;
                            }
                            try {
                                return m.matcher((CharSequence)componentCache.get(is)).find();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        });
                        continue;
                    }
                    m = AbstractStorageTerminalScreen.buildPattern(s);
                    if (m == null) continue;
                    p = p.and(is -> {
                        try {
                            String dspName = is.getStack().method_7964().getString();
                            if (m.matcher(dspName.toLowerCase()).find()) {
                                return true;
                            }
                            for (String lp : (List)tooltipCache.get(is)) {
                                if (!m.matcher(lp).find()) continue;
                                return true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    });
                }
                pred = pred == null ? p : pred.or(p);
            }
            if (pred == null) {
                pred = Predicates.alwaysTrue();
            }
            try {
                for (i = 0; i < ((StorageTerminalMenu)this.method_17577()).itemListClient.size(); ++i) {
                    StoredItemStack is2 = ((StorageTerminalMenu)this.method_17577()).itemListClient.get(i);
                    if (is2 == null || is2.getStack() == null || !pred.test(is2)) continue;
                    this.addStackToClientList(is2);
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            Collections.sort(((StorageTerminalMenu)this.method_17577()).itemListClientSorted, ((StorageTerminalMenu)this.field_2797).noSort ? this.sortComp : this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((StorageTerminalMenu)this.method_17577()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                int searchType = this.buttonSearchType.getSearchType();
                if (searchType != -1) {
                    if ((searchType & 4) > 0) {
                        IAutoFillTerminal.sync(searchString);
                    }
                    if ((searchType & 2) > 0) {
                        class_2487 nbt = new class_2487();
                        nbt.method_10582("s", searchString);
                        ((StorageTerminalMenu)this.field_2797).sendMessage(nbt);
                    }
                }
                this.onUpdateSearch(searchString);
            } else {
                ((StorageTerminalMenu)this.method_17577()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((StorageTerminalMenu)this.method_17577()).itemListClientSorted.add(is);
    }

    protected void method_37432() {
        this.updateSearch();
    }

    public void method_25394(class_332 st, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) != 0;
        int i = this.field_2776;
        int j = this.field_2800;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (this.ghostItems && AbstractStorageTerminalScreen.method_25442()) {
            if (!((StorageTerminalMenu)this.field_2797).noSort) {
                List<StoredItemStack> list = ((StorageTerminalMenu)this.method_17577()).itemListClientSorted;
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                map.defaultReturnValue(Integer.MAX_VALUE);
                for (int m = 0; m < list.size(); ++m) {
                    map.put((Object)list.get(m), m);
                }
                this.sortComp = Comparator.comparing(arg_0 -> ((Object2IntMap)map).getInt(arg_0));
                ((StorageTerminalMenu)this.field_2797).noSort = true;
            }
        } else if (((StorageTerminalMenu)this.field_2797).noSort) {
            this.sortComp = null;
            ((StorageTerminalMenu)this.field_2797).noSort = false;
            this.refreshItemList = true;
            ((StorageTerminalMenu)this.field_2797).itemListClient = new ArrayList<StoredItemStack>(((StorageTerminalMenu)this.field_2797).itemList);
        }
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((StorageTerminalMenu)this.method_17577()).scrollTo(this.currentScroll);
        }
        super.method_25394(st, mouseX, mouseY, partialTicks);
        i = k;
        j = l;
        k = j1;
        st.method_52706(this.needsScrollBars() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE, i, j + (int)((float)(k - j - 17) * this.currentScroll), 12, 15);
        this.searchField.method_25394(st, mouseX, mouseY, partialTicks);
        if (((StorageTerminalMenu)this.field_2797).beaconLvl > 0) {
            int x = 176;
            int y = 24 + this.rowCount * 18;
            st.method_51427(new class_1799((class_1935)class_1802.field_8668), this.field_2776 + x, this.field_2800 + y);
            if (this.method_2378(x, y, 16, 16, mouseX, mouseY)) {
                Object info = Config.get().wirelessTermBeaconLvlCrossDim != -1 && ((StorageTerminalMenu)this.field_2797).beaconLvl >= Config.get().wirelessTermBeaconLvlCrossDim ? "\\" + class_1074.method_4662((String)"tooltip.toms_storage.terminal_beacon.anywhere", (Object[])new Object[0]) : (Config.get().wirelessTermBeaconLvl != -1 && ((StorageTerminalMenu)this.field_2797).beaconLvl >= Config.get().wirelessTermBeaconLvl ? "\\" + class_1074.method_4662((String)"tooltip.toms_storage.terminal_beacon.sameDim", (Object[])new Object[0]) : "");
                st.method_51434(this.field_22793, Arrays.stream(class_1074.method_4662((String)"tooltip.toms_storage.terminal_beacon", (Object[])new Object[]{((StorageTerminalMenu)this.field_2797).beaconLvl, info}).split("\\\\")).map(class_2561::method_43470).collect(Collectors.toList()), mouseX, mouseY);
            }
        }
        if (this.popup.render(st, this.field_22793, mouseX, mouseY)) {
            if (((StorageTerminalMenu)this.field_2797).method_34255().method_7960() && this.slotIDUnderMouse != -1) {
                StorageTerminalMenu.SlotStorage slot = ((StorageTerminalMenu)this.method_17577()).storageSlotList.get(this.slotIDUnderMouse);
                if (slot.stack != null) {
                    if (slot.stack.getQuantity() > 9999L) {
                        ClientUtil.setTooltip(new class_2561[]{class_2561.method_43469((String)"tooltip.toms_storage.amount", (Object[])new Object[]{slot.stack.getQuantity()})});
                    }
                    st.method_51446(this.field_22793, slot.stack.getQuantity() == 0L ? slot.stack.getStack() : slot.stack.getActualStack(), mouseX, mouseY);
                    ClientUtil.setTooltip(new class_2561[0]);
                }
            } else {
                this.method_2380(st, mouseX, mouseY);
            }
        } else {
            this.method_59840();
        }
    }

    protected void method_2388(class_332 st, int mouseX, int mouseY) {
        super.method_2388(st, mouseX, mouseY);
        st.method_51448().method_22903();
        this.slotIDUnderMouse = this.drawSlots(st, mouseX, mouseY);
        st.method_51448().method_22909();
    }

    protected int drawSlots(class_332 st, int mouseX, int mouseY) {
        StorageTerminalMenu term = (StorageTerminalMenu)this.method_17577();
        int slotHover = -1;
        for (int i = 0; i < term.storageSlotList.size(); ++i) {
            if (!this.drawSlot(st, term.storageSlotList.get(i), mouseX, mouseY)) continue;
            slotHover = i;
        }
        return slotHover;
    }

    protected boolean drawSlot(class_332 st, StorageTerminalMenu.SlotStorage slot, int mouseX, int mouseY) {
        if (slot.stack != null) {
            try {
                class_1799 stack = slot.stack.getStack().method_46651(1);
                int i = slot.xDisplayPosition;
                int j = slot.yDisplayPosition;
                st.method_51427(stack, i, j);
                st.method_51431(this.field_22793, stack, i, j);
                this.drawStackSize(st, this.getFont(), slot.stack.getQuantity(), i, j);
            }
            catch (Exception e) {
                class_128 report = class_128.method_560((Throwable)e, (String)"Rendering item stack in terminal");
                report.method_562("Item details:").method_577("Item Id", () -> class_7923.field_41178.method_10221((Object)slot.stack.getStack().method_7909()).toString()).method_578("Item Count", (Object)slot.stack.getQuantity()).method_577("Item Components", () -> (String)componentCache.get((Object)slot.stack));
                throw new class_148(report);
            }
        }
        if (mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17) {
            int l = slot.xDisplayPosition;
            int t = slot.yDisplayPosition;
            AbstractStorageTerminalScreen.method_33285((class_332)st, (int)l, (int)t, (int)0);
            return true;
        }
        return false;
    }

    private void drawStackSize(class_332 st, class_327 fr, long size, int x, int y) {
        float scaleFactor = 0.6f;
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        String stackSize = NumberFormatUtil.formatNumber(size);
        st.method_51448().method_22903();
        st.method_51448().method_22905(scaleFactor, scaleFactor, scaleFactor);
        st.method_51448().method_46416(0.0f, 0.0f, 450.0f);
        float inverseScaleFactor = 1.0f / scaleFactor;
        int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.method_1727(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        st.method_51433(fr, stackSize, X, Y, size == 0L ? 0xFFFF00 : 0xFFFFFF, true);
        st.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    protected boolean needsScrollBars() {
        return ((StorageTerminalMenu)this.method_17577()).itemListClientSorted.size() > this.rowCount * 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.popup.mouseClick(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.slotIDUnderMouse > -1) {
            if (this.isPullOne(mouseButton)) {
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack, TerminalSyncManager.SlotAction.PULL_ONE, this.isTransferOne(mouseButton));
                return true;
            }
            if (this.pullHalf(mouseButton)) {
                if (!((StorageTerminalMenu)this.field_2797).method_34255().method_7960()) {
                    this.storageSlotClick(null, AbstractStorageTerminalScreen.method_25441() ? TerminalSyncManager.SlotAction.GET_QUARTER : TerminalSyncManager.SlotAction.GET_HALF, false);
                    return true;
                }
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.method_25441() ? TerminalSyncManager.SlotAction.GET_QUARTER : TerminalSyncManager.SlotAction.GET_HALF, false);
                return true;
            }
            if (!this.pullNormal(mouseButton)) return true;
            if (!((StorageTerminalMenu)this.field_2797).method_34255().method_7960()) {
                this.storageSlotClick(null, TerminalSyncManager.SlotAction.PULL_OR_PUSH_STACK, false);
                return true;
            }
            if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
            if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
            this.storageSlotClick(((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.method_25442() ? TerminalSyncManager.SlotAction.SHIFT_PULL : TerminalSyncManager.SlotAction.PULL_OR_PUSH_STACK, false);
            return true;
        }
        if (GLFW.glfwGetKey((long)this.field_22787.method_22683().method_4490(), (int)32) != 0) {
            this.storageSlotClick(null, TerminalSyncManager.SlotAction.SPACE_CLICK, false);
            return true;
        }
        int n = this.searchField.method_46426() - this.field_2776;
        int n2 = this.searchField.method_46427() - this.field_2800;
        Objects.requireNonNull(this.getFont());
        if (this.method_2378(n, n2, 89, 9, mouseX, mouseY)) {
            if (mouseButton != 1) return super.method_25402(mouseX, mouseY, mouseButton);
            this.searchField.method_1852("");
            return true;
        }
        this.searchField.method_25365(false);
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    protected void storageSlotClick(StoredItemStack slotStack, TerminalSyncManager.SlotAction act, boolean mod) {
        ((StorageTerminalMenu)this.field_2797).sync.sendInteract(slotStack, act, mod);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.method_25442();
            }
            case 1: {
                return mouseButton == 2;
            }
            case 2: {
                return mouseButton == 1 && !((StorageTerminalMenu)this.field_2797).method_34255().method_7960();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: {
                return AbstractStorageTerminalScreen.method_25442() && AbstractStorageTerminalScreen.method_25441();
            }
            case 1: {
                return AbstractStorageTerminalScreen.method_25442() && mouseButton == 2;
            }
            case 2: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.method_25442();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: {
                return mouseButton == 1;
            }
            case 1: {
                return mouseButton == 1;
            }
            case 2: {
                return mouseButton == 1 && ((StorageTerminalMenu)this.field_2797).method_34255().method_7960();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.popup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 256) {
            this.method_25419();
            return true;
        }
        if (pKeyCode == 258) {
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        if (this.searchField.method_25404(pKeyCode, pScanCode, pModifiers) || this.searchField.method_20315()) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        if (this.popup.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        if (this.searchField.method_25400(pCodePoint, pModifiers)) {
            return true;
        }
        return super.method_25400(pCodePoint, pModifiers);
    }

    public boolean method_25401(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double xd, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((StorageTerminalMenu)this.field_2797).itemListClientSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((StorageTerminalMenu)this.field_2797).scrollTo(this.currentScroll);
        return true;
    }

    public abstract class_2960 getGui();

    protected void method_2389(class_332 st, float partialTicks, int mouseX, int mouseY) {
        if (this.tallMode) {
            st.method_25302(this.getGui(), this.field_2776, this.field_2800, 0, 0, this.field_2792, this.slotStartY);
            int guiStart = this.textureSlotCount * 18 + this.slotStartY;
            int guiRStart = this.rowCount * 18 + this.slotStartY;
            int guiSize = this.guiHeight - this.textureSlotCount * 18 - this.slotStartY;
            st.method_25302(this.getGui(), this.field_2776, this.field_2800 + guiRStart, 0, guiStart, this.field_2792, guiSize);
            int scrollbarW = 25;
            st.method_25302(this.getGui(), this.field_2776, this.field_2800 + this.slotStartY, 0, this.slotStartY, this.slotStartX + 162 + scrollbarW, 18);
            for (int i = 1; i < this.rowCount - 1; ++i) {
                st.method_25302(this.getGui(), this.field_2776, this.field_2800 + this.slotStartY + i * 18, 0, this.slotStartY + 18, this.slotStartX + 162 + scrollbarW, 18);
            }
            st.method_25302(this.getGui(), this.field_2776, this.field_2800 + this.slotStartY + (this.rowCount - 1) * 18, 0, this.slotStartY + (this.textureSlotCount - 1) * 18, this.slotStartX + 162 + scrollbarW, 18);
        } else {
            st.method_25302(this.getGui(), this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        }
        class_1735 offh = ((StorageTerminalMenu)this.method_17577()).offhand;
        st.method_52706(FLOATING_SLOT, this.field_2776 + offh.field_7873 - 8, this.field_2800 + offh.field_7872 - 8, 32, 32);
    }

    protected void onUpdateSearch(String text) {
    }

    @Override
    public void receive(class_2487 tag) {
        ((StorageTerminalMenu)this.field_2797).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
    }

    @Override
    public class_1735 getSlotUnderMouse() {
        class_1735 s = super.getSlotUnderMouse();
        if (s != null) {
            return s;
        }
        if (this.slotIDUnderMouse > -1 && ((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack != null) {
            this.fakeSlotUnderMouse.field_7871.method_5447(0, ((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack());
            return this.fakeSlotUnderMouse;
        }
        return null;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isSmartItemSearchOn() {
        return (this.buttonSearchType.getSearchType() & 8) == 0;
    }

    private static class FakeSlot
    extends class_1735 {
        private static final class_1263 DUMMY = new class_1277(1);

        public FakeSlot() {
            super(DUMMY, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean method_32754(class_1657 p_150652_) {
            return false;
        }

        public void method_7673(class_1799 p_40240_) {
        }

        public class_1799 method_7671(int p_40227_) {
            return class_1799.field_8037;
        }
    }

    public static enum ControllMode {
        AE,
        RS,
        DEF;

        public static final ControllMode[] VALUES;

        static {
            VALUES = ControllMode.values();
        }
    }
}

