/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.ShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.MegaBraceletItem;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_5251;

public class MegaLogic {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;

    public static boolean Possible(class_3222 player, Boolean fromBattle) {
        UUID playerId = player.method_5667();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId) && !fromBattle.booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not so fast!").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return false;
        }
        boolean hasMegaItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof MegaBraceletItem)).orElse(false);
        boolean hasOffhandMegaItem = player.method_6079().method_7909() instanceof MegaBraceletItem;
        boolean hasMainhandMegaItem = player.method_6047().method_7909() instanceof MegaBraceletItem;
        if (!(hasMegaItemTrinkets || hasOffhandMegaItem || hasMainhandMegaItem)) {
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static void EvoLogic(class_3222 player) {
        class_243 lookVec;
        class_243 endPos;
        if (ShowdownConfig.battleModeOnly.get().booleanValue()) {
            return;
        }
        double range = 5.0;
        class_243 startPos = player.method_33571();
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)startPos, (class_243)(endPos = startPos.method_1019((lookVec = player.method_5720()).method_1021(range))), (class_238)player.method_5829().method_18804(lookVec.method_1021(range)).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5863(), (double)(range * range));
        if (entityHit == null) {
            return;
        }
        class_1297 class_12972 = entityHit.method_17782();
        if (class_12972 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)class_12972;
            if (pk.method_37908().field_9236) {
                return;
            }
            if (pk.getPokemon().getOwnerPlayer() != player || !MegaLogic.Possible(player, false)) {
                return;
            }
            List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
            boolean end = false;
            for (String key : megaKeys) {
                FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                FlagSpeciesFeature feature = featureProvider.get(pk.getPokemon());
                if (feature == null) continue;
                boolean enabled = featureProvider.get(pk.getPokemon()).getEnabled();
                if (enabled) {
                    MegaLogic.Devolve((class_1309)pk, (class_1657)player, false);
                    end = false;
                    break;
                }
                end = true;
            }
            if (end) {
                MegaLogic.Evolve((class_1309)pk, (class_1657)player, false);
            }
        }
    }

    public static void Evolve(class_1309 context, class_1657 player, Boolean fromBattle) {
        PokemonEntity pk;
        PokemonEntity pk2;
        if (context instanceof PokemonEntity && (pk2 = (PokemonEntity)context).getPokemon().getOwnerPlayer() != player) {
            return;
        }
        Pokemon pokemon = ((PokemonEntity)context).getPokemon();
        Species species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().method_7909());
        Boolean playerData = (Boolean)player.getAttached(DataManage.MEGA_DATA);
        if (playerData == null) {
            playerData = false;
        }
        if (context instanceof PokemonEntity && (pk = (PokemonEntity)context).isBattling() && !fromBattle.booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not allowed in battle").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && (!playerData.booleanValue() || ShowdownConfig.multipleMegas.get().booleanValue())) {
            if (ShowdownConfig.friendshipMode.get().booleanValue() && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You are not close enough with your pokemon to mega outside").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setAttached(DataManage.MEGA_POKEMON, (Object)pokemon);
                player.setAttached(DataManage.MEGA_DATA, (Object)true);
                new FlagSpeciesFeature("mega", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
                MegaLogic.playEvolveAnimation(context);
                AdvancementHelper.grantAdvancement((class_3222)player, "mega_evolve");
                found = true;
            }
            if (!found) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Rayquaza doesn't have dragonascent").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
            return;
        }
        if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && playerData.booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You can only have one mega at a time").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (species == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Don't have the correct stone").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (ShowdownConfig.friendshipMode.get().booleanValue() && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You are not close enough with your pokemon to mega outside").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (species.getName().equals(pokemon.getSpecies().getName()) && (!playerData.booleanValue() || ShowdownConfig.multipleMegas.get().booleanValue())) {
            if (species.getName().equals(Utils.getSpecies("charizard").getName())) {
                if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_X)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((class_3222)player, "mega_evolve");
                } else if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_Y)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((class_3222)player, "mega_evolve");
                }
            } else if (species.getName().equals(Utils.getSpecies("mewtwo").getName())) {
                if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_X)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((class_3222)player, "mega_evolve");
                } else if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_Y)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((class_3222)player, "mega_evolve");
                }
            } else {
                player.setAttached(DataManage.MEGA_DATA, (Object)true);
                player.setAttached(DataManage.MEGA_POKEMON, (Object)pokemon);
                MegaLogic.playEvolveAnimation(context);
                new FlagSpeciesFeature("mega", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
                AdvancementHelper.grantAdvancement((class_3222)player, "mega_evolve");
            }
        } else if (species.getName().equals(pokemon.getSpecies().getName()) && playerData.booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You can only have one mega at a time").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"Don't have the correct stone").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
        }
    }

    public static void Devolve(class_1309 context, class_1657 player, Boolean fromBattle) {
        if (player.method_37908().field_9236 || context == null) {
            return;
        }
        if (context instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)context;
            if (pk.getPokemon().getOwnerPlayer() != player) {
                return;
            }
            if (pk.isBattling() && !fromBattle.booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Not allowed in battle").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            Pokemon pokemon = ((PokemonEntity)context).getPokemon();
            if (player.method_37908().field_9236) {
                return;
            }
            player.setAttached(DataManage.MEGA_DATA, (Object)false);
            player.removeAttached(DataManage.MEGA_POKEMON);
            MegaLogic.playDevolveAnimation(context);
            new FlagSpeciesFeature("mega", false).apply(pokemon);
            new FlagSpeciesFeature("mega-x", false).apply(pokemon);
            new FlagSpeciesFeature("mega-y", false).apply(pokemon);
            Utils.setTradable(pokemon, true);
        }
    }

    public static void playEvolveAnimation(class_1309 context) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_14703, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverWorld.method_14199((class_2394)class_2398.field_11207, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void playDevolveAnimation(class_1309 context) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_19344, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverWorld.method_14199((class_2394)class_2398.field_11207, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

