/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class BookContentResourceListenerLoader
extends class_4309
implements BookContentLoader {
    public static final BookContentResourceListenerLoader INSTANCE = new BookContentResourceListenerLoader();
    private static final Pattern ID_READER = Pattern.compile("(?<bookId>[a-z0-9_.-]+)/(?<lang>[a-z0-9_.-]+)/(?<folder>[a-z0-9_.-]+)/(?<entryId>[a-z0-9/._-]+)");
    private Map<class_2960, Map<class_2960, JsonElement>> data;

    private BookContentResourceListenerLoader() {
        super(BookRegistry.GSON, "patchouli_books");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, Map<class_2960, JsonElement>> data = new HashMap<class_2960, Map<class_2960, JsonElement>>();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 key = entry.getKey();
            Matcher matcher = ID_READER.matcher(key.method_12832());
            if (!matcher.matches()) {
                PatchouliAPI.LOGGER.trace("Ignored file {}", (Object)key);
                continue;
            }
            class_2960 bookId = class_2960.method_60655((String)key.method_12836(), (String)matcher.group("bookId"));
            data.computeIfAbsent(bookId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        int count = data.values().stream().mapToInt(Map::size).sum();
        PatchouliAPI.LOGGER.info("{} preloaded {} jsons", (Object)this.getClass().getSimpleName(), (Object)count);
        this.data = data;
    }

    @Override
    public void findFiles(Book book, String dir, List<class_2960> list) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<class_2960, JsonElement> map = this.data.get(book.id);
        if (map == null) {
            return;
        }
        for (class_2960 id : map.keySet()) {
            Matcher matcher = ID_READER.matcher(id.method_12832());
            if (!matcher.matches() || !dir.equals(matcher.group("folder")) || !"en_us".equals(matcher.group("lang"))) continue;
            list.add(class_2960.method_60655((String)id.method_12836(), (String)matcher.group("entryId")));
        }
        PatchouliAPI.LOGGER.info("{}: Files found in {}", (Object)this.getClass().getSimpleName(), (Object)stopwatch.stop());
    }

    @Override
    @Nullable
    public BookContentLoader.LoadResult loadJson(Book book, class_2960 file) {
        PatchouliAPI.LOGGER.trace("Loading {}", (Object)file);
        Map<class_2960, JsonElement> map = this.data.get(book.id);
        if (map == null) {
            return null;
        }
        String path = file.method_12832();
        String relativizedPath = path.substring(0, path.length() - 5).split("/", 2)[1];
        JsonElement json = map.get(class_2960.method_60655((String)file.method_12836(), (String)relativizedPath));
        if (json != null) {
            return new BookContentLoader.LoadResult(json, null);
        }
        return null;
    }
}

