/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBookEntryList
extends GuiBook {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    private BookTextRenderer text;
    protected final List<class_4185> entryButtons = new ArrayList<class_4185>();
    private List<BookEntry> allEntries;
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private class_342 searchField;

    public GuiBookEntryList(Book book, class_2561 title) {
        super(book, title);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.text = new BookTextRenderer(this, (class_2561)class_2561.method_43470((String)this.getDescriptionText()), 15, 40);
        this.allEntries = new ArrayList<BookEntry>(this.getEntries());
        this.allEntries.removeIf(BookEntry::shouldHide);
        if (this.shouldSortEntryList()) {
            Collections.sort(this.allEntries);
        }
        this.searchField = this.createSearchBar();
        this.buildEntryButtons();
    }

    protected class_342 createSearchBar() {
        class_342 field = new class_342(this.field_22793, 160, 170, 90, 12, (class_2561)class_2561.method_43473());
        field.method_1880(32);
        field.method_1858(false);
        field.method_1856(false);
        field.method_25365(true);
        return field;
    }

    protected abstract String getDescriptionText();

    protected abstract Collection<BookEntry> getEntries();

    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return true;
    }

    protected boolean shouldDrawProgressBar() {
        return true;
    }

    protected boolean shouldSortEntryList() {
        return true;
    }

    protected void addSubcategoryButtons() {
    }

    @Override
    void drawForegroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        if (this.spread == 0) {
            this.drawCenteredStringNoShadow(graphics, this.method_25440().method_30937(), 73, 18, this.book.headerColor);
            this.drawCenteredStringNoShadow(graphics, this.getChapterListTitle(), 199, 18, this.book.headerColor);
            GuiBookEntryList.drawSeparator(graphics, this.book, 15, 30);
            GuiBookEntryList.drawSeparator(graphics, this.book, 141, 30);
            this.text.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (this.shouldDrawProgressBar()) {
                this.drawProgressBar(graphics, this.book, mouseX, mouseY, this::doesEntryCountForProgress);
            }
        } else if (this.spread % 2 == 1 && this.spread == this.maxSpreads - 1 && this.entryButtons.size() <= 13) {
            GuiBookEntryList.drawPageFiller(graphics, this.book);
        }
        if (!this.searchField.method_1882().isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookEntryList.drawFromTexture(graphics, this.book, this.searchField.method_46426() - 8, this.searchField.method_46427(), 140, 183, 99, 14);
            class_5250 toDraw = class_2561.method_43470((String)this.searchField.method_1882()).method_10862(this.book.getFontStyle());
            graphics.method_51439(this.field_22793, (class_2561)toDraw, this.searchField.method_46426() + 7, this.searchField.method_46427() + 1, this.book.textColor, false);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.method_1882().isEmpty()) {
                this.drawCenteredStringNoShadow(graphics, class_1074.method_4662((String)"patchouli.gui.lexicon.no_results", (Object[])new Object[0]), 199, 80, 0x333333);
                graphics.method_51448().method_22905(2.0f, 2.0f, 2.0f);
                this.drawCenteredStringNoShadow(graphics, class_1074.method_4662((String)"patchouli.gui.lexicon.sad", (Object[])new Object[0]), 99, 47, 0x999999);
                graphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(graphics, this.getNoEntryMessage(), 199, 80, 0x333333);
            }
        }
    }

    protected String getChapterListTitle() {
        return class_1074.method_4662((String)"patchouli.gui.lexicon.chapters", (Object[])new Object[0]);
    }

    protected String getNoEntryMessage() {
        return class_1074.method_4662((String)"patchouli.gui.lexicon.no_entries", (Object[])new Object[0]);
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text.click(mouseX, mouseY, mouseButton) || this.searchField.method_25402(mouseX - (double)this.bookLeft, mouseY - (double)this.bookTop, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public boolean method_25400(char c, int i) {
        String currQuery = this.searchField.method_1882();
        if (this.searchField.method_25400(c, i)) {
            if (!this.searchField.method_1882().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.method_25400(c, i);
    }

    @Override
    public boolean method_25404(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.method_1882();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                this.displayLexiconGui(new GuiBookEntry(this.book, this.visibleEntries.get(0)), true);
                return true;
            }
        } else if (this.searchField.method_25404(key, scanCode, modifiers)) {
            if (!this.searchField.method_1882().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    public void handleButtonCategory(class_4185 button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    public void handleButtonEntry(class_4185 button) {
        GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    void buildEntryButtons() {
        this.removeDrawablesIn(this.entryButtons);
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.method_1882().toLowerCase();
        this.allEntries.stream().filter(e -> e.isFoundByQuery(query)).forEach(this.visibleEntries::add);
        this.maxSpreads = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxSpreads += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.spread;
        }
        if (this.spread == 0) {
            this.addEntryButtons(141, 38, 0, 11);
            this.addSubcategoryButtons();
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(15, 18, start, 13);
            this.addEntryButtons(141, 18, start + 13, 13);
        }
    }

    int getEntryCountStart() {
        if (this.spread == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.spread - 1);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.visibleEntries.get(start + i), this::handleButtonEntry);
            this.method_37063(button);
            this.entryButtons.add(button);
        }
    }

    public String getSearchQuery() {
        return this.searchField.method_1882();
    }
}

