/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.AbstractBalmConfig;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.entity.BalmEntity;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.network.ServerboundModListMessage;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.balm.common.command.BalmCommand;
import net.blay09.mods.balm.config.ExampleConfig;
import net.blay09.mods.balm.fabric.FabricBalmHooks;
import net.blay09.mods.balm.fabric.FabricBalmProxy;
import net.blay09.mods.balm.fabric.fluid.BalmFluidStorage;
import net.blay09.mods.balm.fabric.network.FabricBalmNetworking;
import net.blay09.mods.balm.fabric.provider.FabricBalmProviders;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class FabricBalm
implements ModInitializer {
    private static final SidedProxy<FabricBalmProxy> proxy = Balm.sidedProxy("net.blay09.mods.balm.fabric.FabricBalmProxy", "net.blay09.mods.balm.fabric.client.FabricBalmClientProxy");

    public void onInitialize() {
        ((FabricBalmHooks)Balm.getHooks()).initialize();
        ((AbstractBalmConfig)Balm.getConfig()).initialize();
        ExampleConfig.initialize();
        Balm.getCommands().register(BalmCommand::register);
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            class_2487 data = ((BalmEntity)oldPlayer).getFabricBalmData();
            ((BalmEntity)newPlayer).setFabricBalmData(data);
        });
        FabricBalmProviders providers = (FabricBalmProviders)Balm.getProviders();
        providers.registerProvider(class_2960.method_60655((String)"balm", (String)"container"), class_1263.class);
        providers.registerProvider(class_2960.method_60655((String)"balm", (String)"fluid_tank"), FluidTank.class);
        providers.registerProvider(class_2960.method_60655((String)"balm", (String)"energy_storage"), EnergyStorage.class);
        ItemStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            BalmContainerProvider containerProvider;
            class_1263 container;
            if (blockEntity instanceof BalmContainerProvider && (container = (containerProvider = (BalmContainerProvider)blockEntity).getContainer((class_2350)direction)) != null) {
                return InventoryStorage.of((class_1263)container, (class_2350)direction);
            }
            return null;
        });
        FluidStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            BalmFluidTankProvider fluidTankProvider;
            FluidTank fluidTank;
            if (blockEntity instanceof BalmFluidTankProvider && (fluidTank = (fluidTankProvider = (BalmFluidTankProvider)blockEntity).getFluidTank((class_2350)direction)) != null) {
                return new BalmFluidStorage(fluidTank);
            }
            return null;
        });
        Balm.getNetworking().registerServerboundPacket(ServerboundModListMessage.TYPE, ServerboundModListMessage.class, (buf, message) -> {
            buf.method_10804(message.modList().size());
            message.modList().forEach((modId, version) -> {
                buf.method_10814(modId);
                buf.method_10814(version);
            });
        }, buf -> {
            HashMap<String, String> modList = new HashMap<String, String>();
            int modCount = buf.method_10816();
            for (int i = 0; i < modCount; ++i) {
                modList.put(buf.method_19772(), buf.method_19772());
            }
            return new ServerboundModListMessage(modList);
        }, (player, message) -> {
            FabricBalmNetworking networking = (FabricBalmNetworking)Balm.getNetworking();
            for (Map.Entry<String, String> entry : message.modList().entrySet()) {
                String modId = entry.getKey();
                if (networking.isClientOnly(modId) || networking.isServerOnly(modId)) continue;
                String clientVersion = entry.getValue();
                ModContainer modContainer = FabricLoader.getInstance().getModContainer(modId).orElse(null);
                if (modContainer == null) {
                    player.field_13987.method_52396((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_missing_on_server", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1061)}));
                    return;
                }
                String serverVersion = modContainer.getMetadata().getVersion().toString();
                if (clientVersion.equals(serverVersion)) continue;
                player.field_13987.method_52396((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_version_mismatch", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1065), class_2561.method_43470((String)serverVersion).method_27692(class_124.field_1060), class_2561.method_43470((String)clientVersion).method_27692(class_124.field_1061)}));
                return;
            }
            for (String modId : networking.getRegisteredMods()) {
                ModContainer modContainer;
                if (networking.isServerOnly(modId) || networking.isClientOnly(modId) || message.modList().containsKey(modId) || (modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElse(null)) == null) continue;
                String serverVersion = modContainer.getMetadata().getVersion().toString();
                player.field_13987.method_52396((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_missing_on_client", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1061), class_2561.method_43470((String)modId).method_27692(class_124.field_1065), class_2561.method_43470((String)serverVersion).method_27692(class_124.field_1060)}));
            }
        });
        Balm.initializeIfLoaded("team_reborn_energy", "net.blay09.mods.balm.fabric.compat.energy.RebornEnergy");
    }

    public static FabricBalmProxy getProxy() {
        return proxy.get();
    }
}

