/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.client;

import java.lang.reflect.InvocationTargetException;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.EmptyLoadContext;
import net.blay09.mods.balm.api.client.BalmClientRuntime;
import net.blay09.mods.balm.api.client.keymappings.BalmKeyMappings;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.api.client.rendering.BalmRenderers;
import net.blay09.mods.balm.api.client.rendering.BalmTextures;
import net.blay09.mods.balm.api.client.screen.BalmScreens;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.balm.fabric.FabricBalmRuntime;
import net.blay09.mods.balm.fabric.client.keymappings.FabricBalmKeyMappings;
import net.blay09.mods.balm.fabric.client.rendering.FabricBalmModels;
import net.blay09.mods.balm.fabric.client.rendering.FabricBalmRenderers;
import net.blay09.mods.balm.fabric.client.rendering.FabricBalmTextures;
import net.blay09.mods.balm.fabric.client.screen.FabricBalmScreens;
import net.blay09.mods.balm.fabric.event.FabricBalmEvents;
import net.blay09.mods.balm.fabric.event.client.FabricBalmClientEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricBalmClientRuntime
implements BalmClientRuntime<EmptyLoadContext> {
    private static final Logger logger = LoggerFactory.getLogger(FabricBalmClientRuntime.class);
    private final BalmRenderers renderers = new FabricBalmRenderers();
    private final BalmTextures textures = new FabricBalmTextures();
    private final BalmScreens screens = new FabricBalmScreens();
    private final BalmKeyMappings keyMappings = FabricBalmClientRuntime.createKeyMappingsBindings();
    private final BalmModels models = new FabricBalmModels();

    public FabricBalmClientRuntime() {
        FabricBalmClientEvents.registerEvents((FabricBalmEvents)Balm.getEvents());
        Balm.getEvents().onEvent(ClientStartedEvent.class, event -> {
            for (String className : ((FabricBalmRuntime)Balm.getRuntime()).getAddonClasses()) {
                try {
                    Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public BalmRenderers getRenderers() {
        return this.renderers;
    }

    @Override
    public BalmTextures getTextures() {
        return this.textures;
    }

    @Override
    public BalmScreens getScreens() {
        return this.screens;
    }

    @Override
    public BalmKeyMappings getKeyMappings() {
        return this.keyMappings;
    }

    @Override
    public BalmModels getModels() {
        return this.models;
    }

    @Override
    public void initialize(String modId, EmptyLoadContext context, Runnable initializer) {
        initializer.run();
    }

    private static BalmKeyMappings createKeyMappingsBindings() {
        if (Balm.isModLoaded("amecs")) {
            try {
                Class.forName("de.siphalor.amecs.api.AmecsKeyBinding");
                try {
                    Class<?> amecs = Class.forName("net.blay09.mods.balm.fabric.compat.AmecsBalmKeyMappings");
                    return (BalmKeyMappings)amecs.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Failed to initialize amecs key mappings for Balm", (Throwable)e);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new FabricBalmKeyMappings();
    }
}

