/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.sync;

import com.mrcrayfish.framework.api.sync.DataSerializer;
import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public record SyncedDataKey<E extends class_1297, T>(Pair<class_2960, class_2960> pairKey, class_2960 id, SyncedClassKey<E> classKey, DataSerializer<T> serializer, Supplier<T> defaultValueSupplier, boolean save, boolean persistent, SyncMode syncMode) {
    public void setValue(E entity, T value) {
        SyncedEntityData.instance().set(entity, this, value);
    }

    public T getValue(E entity) {
        return SyncedEntityData.instance().get(entity, this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncedDataKey that = (SyncedDataKey)o;
        return Objects.equals(this.pairKey, that.pairKey);
    }

    @Override
    public int hashCode() {
        return this.pairKey.hashCode();
    }

    public static <E extends class_1297, T> Builder<E, T> builder(SyncedClassKey<E> entityClass, DataSerializer<T> serializer) {
        return new Builder<E, T>(entityClass, serializer);
    }

    public static enum SyncMode {
        NONE(false, false),
        ALL(true, true),
        TRACKING_ONLY(true, false),
        SELF_ONLY(false, true);

        final boolean tracking;
        final boolean self;

        private SyncMode(boolean tracking, boolean self) {
            this.tracking = tracking;
            this.self = self;
        }

        public boolean willSync() {
            return this != NONE;
        }

        public boolean isTracking() {
            return this.tracking;
        }

        public boolean isSelf() {
            return this.self;
        }
    }

    public static class Builder<E extends class_1297, T> {
        private final SyncedClassKey<E> classKey;
        private final DataSerializer<T> serializer;
        private class_2960 id;
        private Supplier<T> defaultValueSupplier;
        private boolean save = false;
        private boolean persistent = true;
        private SyncMode syncMode = SyncMode.ALL;

        private Builder(SyncedClassKey<E> classKey, DataSerializer<T> serializer) {
            this.classKey = classKey;
            this.serializer = serializer;
        }

        public SyncedDataKey<E, T> build() {
            Validate.notNull((Object)this.id, (String)"Missing 'id' when building synced data key", (Object[])new Object[0]);
            Validate.notNull(this.defaultValueSupplier, (String)"Missing 'defaultValueSupplier' when building synced data key", (Object[])new Object[0]);
            Pair pairKey = Pair.of((Object)this.classKey.id(), (Object)this.id);
            return new SyncedDataKey<E, T>((Pair<class_2960, class_2960>)pairKey, this.id, this.classKey, this.serializer, this.defaultValueSupplier, this.save, this.persistent, this.syncMode);
        }

        public Builder<E, T> id(class_2960 id) {
            this.id = id;
            return this;
        }

        public Builder<E, T> id(String id) {
            this.id = class_2960.method_60654((String)id);
            return this;
        }

        @Deprecated
        public Builder<E, T> key(String key) {
            return this.id(key);
        }

        public Builder<E, T> defaultValueSupplier(Supplier<T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            return this;
        }

        public Builder<E, T> saveToFile() {
            this.save = true;
            return this;
        }

        public Builder<E, T> resetOnDeath() {
            this.persistent = false;
            return this;
        }

        public Builder<E, T> syncMode(SyncMode mode) {
            this.syncMode = mode;
            return this;
        }
    }
}

