/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.FrameworkNetworkBuilder;
import com.mrcrayfish.framework.api.network.FrameworkResponse;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import com.mrcrayfish.framework.network.message.FrameworkMessage;
import com.mrcrayfish.framework.network.message.FrameworkPayload;
import com.mrcrayfish.framework.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.configuration.Acknowledge;
import com.mrcrayfish.framework.platform.network.FabricConfigurationTask;
import com.mrcrayfish.framework.platform.network.FabricNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class FabricNetworkBuilder
implements FrameworkNetworkBuilder {
    private final class_2960 id;
    private final int version;
    private final List<PlayMessage<?>> playMessages = new ArrayList();
    private final List<FrameworkMessage<?, class_2540>> configurationMessages = new ArrayList();
    private final List<BiFunction<FabricNetwork, class_8610, class_8605>> configurationTasks = new ArrayList<BiFunction<FabricNetwork, class_8610, class_8605>>();

    public FabricNetworkBuilder(class_2960 id, int version) {
        this.id = id;
        this.version = version;
    }

    @Override
    public FrameworkNetworkBuilder optional() {
        return this;
    }

    @Override
    public <T> FrameworkNetworkBuilder registerPlayMessage(String name, Class<T> messageClass, class_9139<class_9129, T> codec, BiConsumer<T, MessageContext> handler) {
        return this.registerPlayMessage(name, messageClass, codec, handler, null);
    }

    @Override
    public <T> FrameworkNetworkBuilder registerPlayMessage(String name, Class<T> messageClass, class_9139<class_9129, T> codec, BiConsumer<T, MessageContext> handler, @Nullable class_2598 flow) {
        class_2960 payloadId = FrameworkNetworkBuilder.createMessageId(this.id, name);
        class_8710.class_9154 payloadType = new class_8710.class_9154(payloadId);
        class_9139<class_9129, FrameworkPayload<T>> payloadCodec = FrameworkPayload.codec(payloadType, codec);
        this.playMessages.add(new PlayMessage<T>(payloadType, messageClass, payloadCodec, handler, flow));
        return this;
    }

    @Override
    public <T> FrameworkNetworkBuilder registerConfigurationMessage(String name, Class<T> taskClass, class_9139<class_2540, T> codec, BiFunction<T, Consumer<Runnable>, FrameworkResponse> handler, Supplier<List<T>> messages) {
        return this.registerConfigurationMessage(name, taskClass, codec, handler, messages, null);
    }

    @Override
    public <T> FrameworkNetworkBuilder registerConfigurationMessage(String name, Class<T> taskClass, class_9139<class_2540, T> codec, BiFunction<T, Consumer<Runnable>, FrameworkResponse> handler, Supplier<List<T>> messages, @Nullable class_2598 flow) {
        this.registerConfigurationAckMessage();
        class_2960 payloadId = FrameworkNetworkBuilder.createMessageId(this.id, name);
        class_8710.class_9154 payloadType = new class_8710.class_9154(payloadId);
        class_9139<class_2540, FrameworkPayload<T>> payloadCodec = FrameworkPayload.codec(payloadType, codec);
        this.configurationMessages.add(new ConfigurationMessage<T>(payloadType, taskClass, payloadCodec, handler, flow));
        class_8605.class_8606 type = new class_8605.class_8606(payloadId.toString());
        this.configurationTasks.add((network, listener) -> new FabricConfigurationTask(payloadId, (FabricNetwork)network, (class_8610)listener, type, messages));
        return this;
    }

    private void registerConfigurationAckMessage() {
        if (this.configurationMessages.isEmpty()) {
            class_2960 payloadId = FrameworkNetworkBuilder.createMessageId(this.id, "ack");
            class_8710.class_9154 payloadType = new class_8710.class_9154(payloadId);
            class_9139<class_2540, FrameworkPayload<Acknowledge>> payloadCodec = FrameworkPayload.codec(payloadType, Acknowledge.STREAM_CODEC);
            this.configurationMessages.add(new FrameworkMessage<Acknowledge, class_2540>(payloadType, Acknowledge.class, payloadCodec, Acknowledge::handle, class_2598.field_11941));
        }
    }

    @Override
    public FrameworkNetwork build() {
        this.registerConfigurationMessage("ping", FabricNetwork.Ping.class, FabricNetwork.Ping.STREAM_CODEC, FabricNetwork.Ping::handle, () -> List.of(new FabricNetwork.Ping()), class_2598.field_11942);
        return new FabricNetwork(this.id, this.version, this.playMessages, this.configurationMessages, this.configurationTasks);
    }
}

