/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3756;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_7151;
import net.potionstudios.biomeswevegone.util.UnsafeBoundingBox;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchPiece;
import org.jetbrains.annotations.NotNull;

public class ArchStructure
extends class_3195 {
    public static final class_3341 INFINITE = class_3341.method_14665();
    public static final MapCodec<ArchStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ArchStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)ArchConfig.CODEC.fieldOf("config").forGetter(archStructure -> archStructure.config)).apply((Applicative)builder, ArchStructure::new));
    private final ArchConfig config;

    public ArchStructure(class_3195.class_7302 settings, ArchConfig config) {
        super(settings);
        this.config = config;
    }

    @NotNull
    protected Optional<class_3195.class_7150> method_38676(@NotNull class_3195.class_7149 context) {
        return ArchStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13200, structurePiecesBuilder -> {
            class_1923 chunkPos = context.comp_568();
            class_2919 random = context.comp_566();
            int blockX = chunkPos.method_33939(random.method_43048(16));
            int blockZ = chunkPos.method_33941(random.method_43048(16));
            class_2794 chunkGenerator = context.comp_562();
            int blockY = chunkGenerator.method_16397(blockX, blockZ, class_2902.class_2903.field_13195, context.comp_569(), context.comp_564());
            int yOffset = this.config.height().method_35008((class_5819)random);
            class_2338 structureCenter = new class_2338(blockX, blockY, blockZ);
            class_243 originVec3 = class_243.method_24953((class_2382)structureCenter);
            class_2338 offset = new class_2338(this.config.length().method_35008((class_5819)random) / 2 * (random.method_43056() ? 1 : -1), 0, this.config.length().method_35008((class_5819)random) / 2 * (random.method_43056() ? 1 : -1));
            class_2338 first = structureCenter.method_10081((class_2382)offset);
            first = first.method_33096(chunkGenerator.method_16397(first.method_10263(), first.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564()) - 10);
            class_243 firstVec3 = class_243.method_24953((class_2382)first);
            class_2338 second = structureCenter.method_10059((class_2382)offset);
            second = second.method_33096(chunkGenerator.method_16397(second.method_10263(), second.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564()) - 10);
            class_243 secondVec3 = class_243.method_24953((class_2382)second);
            Long2ObjectOpenHashMap generatingChunks = new Long2ObjectOpenHashMap();
            Consumer<class_2338> stepAction = position -> ((UnsafeBoundingBox)generatingChunks.computeIfAbsent(class_1923.method_37232((class_2338)position), key -> new UnsafeBoundingBox())).encapsulate((class_2382)position);
            this.config.archGeneratorConfig().generate(context.comp_567() + structureCenter.method_10063(), yOffset, firstVec3, originVec3, secondVec3, INFINITE, stepAction);
            class_2338 finalFirst = first;
            class_2338 finalSecond = second;
            generatingChunks.long2ObjectEntrySet().fastForEach(unsafeBoundingBoxEntry -> structurePiecesBuilder.method_35462((class_3443)new ArchPiece(((UnsafeBoundingBox)unsafeBoundingBoxEntry.getValue()).toBoundingBox(), structureCenter, finalFirst, finalSecond, yOffset, this.config.archGeneratorConfig(), this.config.checkedBlockPlacement())));
        });
    }

    public static void between(class_243 center, class_243 second, double xzStepDistance, int yOffset, double step3dDistance, BlendingFunction blendingFunction, Consumer<class_2338> stepAction) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_243 xzDifference = center.method_1020(second);
        double xzDistance = xzDifference.method_37267();
        double xzTotalSteps = xzDistance / xzStepDistance;
        int step = 0;
        while ((double)step < xzTotalSteps) {
            double factor = (double)step / xzTotalSteps;
            class_243 stepVec3 = center.method_1019(xzDifference.method_1029().method_1021((double)step * xzStepDistance));
            double yPos = blendingFunction.apply(1.0 - factor, second.field_1351, center.field_1351 + (double)yOffset);
            class_243 stepVec3YOffset = new class_243(stepVec3.field_1352, yPos, stepVec3.field_1350);
            int nextStep = step + 1;
            double nextFactor = (double)nextStep / xzTotalSteps;
            class_243 nextStepVec3 = center.method_1019(xzDifference.method_1029().method_1021((double)nextStep * xzStepDistance));
            double nextYPos = blendingFunction.apply(1.0 - nextFactor, second.field_1351, center.field_1351 + (double)yOffset);
            class_243 nextStepVec3YOffset = new class_243(nextStepVec3.field_1352, nextYPos, nextStepVec3.field_1350);
            ArchStructure.between3D(step3dDistance, nextStepVec3YOffset, stepVec3YOffset, mutableBlockPos, stepAction);
            ++step;
        }
    }

    private static void between3D(double step3dDistance, class_243 nextStepVec3YOffset, class_243 stepVec3YOffset, class_2338.class_2339 mutableBlockPos, Consumer<class_2338> stepAction) {
        class_243 difference3D = nextStepVec3YOffset.method_1020(stepVec3YOffset);
        double distance3d = difference3D.method_1033();
        double totalSteps3D = distance3d / step3dDistance;
        int step3D = 0;
        while ((double)step3D <= totalSteps3D) {
            class_243 step3DVec3 = stepVec3YOffset.method_1019(difference3D.method_1029().method_1021((double)step3D * step3dDistance));
            mutableBlockPos.method_10102(step3DVec3.field_1352, step3DVec3.field_1351, step3DVec3.field_1350);
            stepAction.accept(mutableBlockPos.method_10062());
            ++step3D;
        }
    }

    public static void generate(long seed, double thickness, double frequency, class_2338 stepOrigin, class_3341 effectedArea, Consumer<class_2338> action) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_3756 noise = new class_3756((class_5819)new class_6677(seed));
        if (!effectedArea.equals((Object)INFINITE) && !effectedArea.method_35410((int)thickness + 1).method_14662((class_2382)stepOrigin)) {
            return;
        }
        for (double x = -thickness; x <= thickness; x += 1.0) {
            for (double y = -thickness; y <= thickness; y += 1.0) {
                for (double z = -thickness; z <= thickness; z += 1.0) {
                    mutableBlockPos.method_25504((class_2382)stepOrigin, (int)x, (int)y, (int)z);
                    if (!effectedArea.equals((Object)INFINITE) && !effectedArea.method_14662((class_2382)mutableBlockPos) || !(stepOrigin.method_10262((class_2382)mutableBlockPos) < class_3532.method_33723((double)thickness))) continue;
                    double noiseSample = (noise.method_33658((double)mutableBlockPos.method_10263() * frequency, (double)mutableBlockPos.method_10264() * frequency, (double)mutableBlockPos.method_10260() * frequency) + 1.0) * 0.5;
                    double localRadius = class_3532.method_15390((double)(thickness * 0.5), (double)thickness, (double)noiseSample);
                    if (!(stepOrigin.method_10262((class_2382)mutableBlockPos) < class_3532.method_33723((double)localRadius))) continue;
                    action.accept((class_2338)mutableBlockPos);
                }
            }
        }
    }

    @NotNull
    public class_7151<?> method_41618() {
        return BWGStructureTypes.ARCH.get();
    }
}

