/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.broadcasters;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.config.SpawnNotificationConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\n\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001f\u001a\u0004\b\"\u0010!R\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010#\u001a\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0016\u0010-\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020*0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0012R\u0016\u00101\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010,R\u0014\u00103\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010(\u00a8\u00064"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/broadcasters/SpawnBroadcaster;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawnPool", "Lnet/minecraft/class_2338;", "coords", "Lnet/minecraft/class_2960;", "biome", "dimension", "Lnet/minecraft/class_3222;", "player", "<init>", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;Lnet/minecraft/class_2338;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_3222;)V", "", "Lnet/minecraft/class_2561;", "getBroadcast", "()Ljava/util/List;", "buildXaerosWaypoint", "()Lnet/minecraft/class_2561;", "buildJourneyMapWaypoint", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getSpawnPool", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "Lnet/minecraft/class_2338;", "getCoords", "()Lnet/minecraft/class_2338;", "Lnet/minecraft/class_2960;", "getBiome", "()Lnet/minecraft/class_2960;", "getDimension", "Lnet/minecraft/class_3222;", "getPlayer", "()Lnet/minecraft/class_3222;", "", "getShiny", "()Z", "shiny", "", "getLabel", "()Ljava/lang/String;", "label", "getBuckets", "buckets", "getBucket", "bucket", "getShouldBroadcast", "shouldBroadcast", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nSpawnBroadcaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnBroadcaster.kt\nus/timinc/mc/cobblemon/spawnnotification/broadcasters/SpawnBroadcaster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n295#2,2:131\n1611#2,9:133\n1863#2:142\n1864#2:144\n1620#2:145\n774#2:146\n865#2,2:147\n1557#2:149\n1628#2,3:150\n295#2,2:153\n2632#2,3:155\n1#3:143\n*S KotlinDebug\n*F\n+ 1 SpawnBroadcaster.kt\nus/timinc/mc/cobblemon/spawnnotification/broadcasters/SpawnBroadcaster\n*L\n24#1:131,2\n27#1:133,9\n27#1:142\n27#1:144\n27#1:145\n28#1:146\n28#1:147,2\n29#1:149\n29#1:150,3\n31#1:153,2\n33#1:155,3\n27#1:143\n*E\n"})
public final class SpawnBroadcaster {
    @NotNull
    private final Pokemon pokemon;
    @NotNull
    private final SpawnPool spawnPool;
    @NotNull
    private final class_2338 coords;
    @NotNull
    private final class_2960 biome;
    @NotNull
    private final class_2960 dimension;
    @Nullable
    private final class_3222 player;

    public SpawnBroadcaster(@NotNull Pokemon pokemon, @NotNull SpawnPool spawnPool, @NotNull class_2338 coords, @NotNull class_2960 biome, @NotNull class_2960 dimension, @Nullable class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"spawnPool");
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.pokemon = pokemon;
        this.spawnPool = spawnPool;
        this.coords = coords;
        this.biome = biome;
        this.dimension = dimension;
        this.player = player;
    }

    @NotNull
    public final Pokemon getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final SpawnPool getSpawnPool() {
        return this.spawnPool;
    }

    @NotNull
    public final class_2338 getCoords() {
        return this.coords;
    }

    @NotNull
    public final class_2960 getBiome() {
        return this.biome;
    }

    @NotNull
    public final class_2960 getDimension() {
        return this.dimension;
    }

    @Nullable
    public final class_3222 getPlayer() {
        return this.player;
    }

    private final boolean getShiny() {
        return this.pokemon.getShiny();
    }

    private final String getLabel() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.pokemon.getForm().getLabels();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!SpawnNotification.INSTANCE.getConfig().getLabelsForBroadcast().contains(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBuckets() {
        void $this$mapTo$iv$iv;
        PokemonSpawnDetail it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)this.spawnPool;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PokemonSpawnDetail it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpawnDetail it2 = (SpawnDetail)element$iv$iv;
            boolean bl2 = false;
            if ((it2 instanceof PokemonSpawnDetail ? (PokemonSpawnDetail)it2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PokemonSpawnDetail)element$iv$iv;
            boolean bl = false;
            if (!it.getPokemon().matches(this.pokemon)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PokemonSpawnDetail)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBucket().getName());
        }
        return (List)destination$iv$iv;
    }

    private final String getBucket() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = SpawnNotification.INSTANCE.getConfig().getBucketsForBroadcast();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!this.getBuckets().contains(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldBroadcast() {
        String it;
        if (!(this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny() || this.getLabel() != null)) {
            if (this.getBucket() == null) return false;
        }
        Iterable $this$none$iv = SpawnNotification.INSTANCE.getConfig().getBlacklistForBroadcast();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null).matches(this.pokemon));
        return false;
    }

    @NotNull
    public final List<class_2561> getBroadcast() {
        String string;
        String string2;
        Object[] objectArray;
        if (!this.getShouldBroadcast()) {
            return CollectionsKt.emptyList();
        }
        List list = new ArrayList();
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[9];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string2 = "";
        }
        objectArray2[2] = string2;
        Object object = objectArray2[3] = SpawnNotification.INSTANCE.getConfig().getBroadcastSpeciesName() ? this.pokemon.getSpecies().getTranslatedName() : class_2561.method_43471((String)"cobblemon.entity.pokemon");
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastBiome()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getRawComponent("biome." + this.biome.method_42094(), new Object[0])};
            v5 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.biome", objectArray);
        } else {
            v5 = objectArray2[4] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastCoords()) {
            objectArray = new Object[]{this.coords.method_10263(), this.coords.method_10264(), this.coords.method_10260()};
            v6 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.coords", objectArray);
        } else {
            v6 = objectArray2[5] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getRawComponent("dimension." + this.dimension.method_42094(), new Object[0])};
            v7 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.dimension", objectArray);
        } else {
            v7 = objectArray2[6] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastPlayerSpawnedOn() && this.player != null) {
            objectArray = new Object[]{this.player.method_5477()};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.player", objectArray);
        } else {
            string = "";
        }
        objectArray2[7] = string;
        objectArray2[8] = SpawnNotification.INSTANCE.getConfig().getBroadcastJourneyMapWaypoints() ? this.buildJourneyMapWaypoint() : "";
        list.add(spawnNotificationConfig.getComponent("notification.spawn", objectArray2));
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastXaerosWaypoints()) {
            list.add(this.buildXaerosWaypoint());
        }
        return list;
    }

    private final class_2561 buildXaerosWaypoint() {
        String string;
        Object[] objectArray;
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[8];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string = "";
        }
        objectArray2[2] = string;
        objectArray2[3] = SpawnNotification.INSTANCE.getConfig().getBroadcastSpeciesName() ? this.pokemon.getSpecies().getTranslatedName() : class_2561.method_43471((String)"cobblemon.entity.pokemon");
        objectArray2[4] = this.coords.method_10263();
        objectArray2[5] = this.coords.method_10264();
        objectArray2[6] = this.coords.method_10260();
        objectArray2[7] = this.dimension.method_12832();
        return spawnNotificationConfig.getComponent("notification.waypoints.xaeros", objectArray2);
    }

    private final class_2561 buildJourneyMapWaypoint() {
        String string;
        Object[] objectArray;
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[8];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string = "";
        }
        objectArray2[2] = string;
        objectArray2[3] = SpawnNotification.INSTANCE.getConfig().getBroadcastSpeciesName() ? this.pokemon.getSpecies().getTranslatedName() : class_2561.method_43471((String)"cobblemon.entity.pokemon");
        objectArray2[4] = this.coords.method_10263();
        objectArray2[5] = this.coords.method_10264();
        objectArray2[6] = this.coords.method_10260();
        objectArray2[7] = this.dimension.method_12836() + ":" + this.dimension.method_12832();
        return spawnNotificationConfig.getComponent("notification.waypoints.journeymap", objectArray2);
    }
}

