/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import earth.terrarium.athena.impl.client.models.ctm.ConnectedTextureMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class ConnectedBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private final ConnectedTextureMap materials;
    private final BiPredicate<class_2680, class_2680> connectTo;
    private final class_1921 renderType;

    public ConnectedBlockModel(ConnectedTextureMap materials, BiPredicate<class_2680, class_2680> connectTo) {
        this(materials, connectTo, null);
    }

    public ConnectedBlockModel(ConnectedTextureMap materials, BiPredicate<class_2680, class_2680> connectTo, class_1921 renderType) {
        this.materials = materials;
        this.connectTo = connectTo;
        this.renderType = renderType;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction) {
        if (CtmUtils.checkRelative(level, state, pos, direction)) {
            return List.of();
        }
        CtmState ctm = CtmState.from(level, state, pos, direction, CtmUtils.check(level, state, pos, direction, this.connectTo));
        if (ctm.allTrue()) {
            return List.of(AthenaQuad.withSprite(this.materials.getTexture(direction, 1)));
        }
        return List.of(AthenaQuad.withState(this.materials, direction, ctm.up(), ctm.left(), ctm.upLeft(), 0.0f, 0.5f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, ctm.up(), ctm.right(), ctm.upRight(), 0.5f, 1.0f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, ctm.down(), ctm.left(), ctm.downLeft(), 0.0f, 0.5f, 0.5f, 0.0f), AthenaQuad.withState(this.materials, direction, ctm.down(), ctm.right(), ctm.downRight(), 0.5f, 1.0f, 0.5f, 0.0f));
    }

    @Override
    public Map<class_2350, List<AthenaQuad>> getDefaultQuads(class_2350 direction) {
        if (direction == null) {
            return Map.of();
        }
        return Map.of(direction, List.of(AthenaQuad.withState(this.materials, direction, false, false, false, 0.0f, 0.5f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, false, false, false, 0.5f, 1.0f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, false, false, false, 0.0f, 0.5f, 0.5f, 0.0f), AthenaQuad.withState(this.materials, direction, false, false, false, 0.5f, 1.0f, 0.5f, 0.0f)));
    }

    @Override
    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        return this.materials.getTextures(getter);
    }

    @Override
    @Nullable
    public class_1921 getRenderType() {
        return this.renderType;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            ConnectedTextureMap materials = CtmUtils.tryParse(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"), Factory::parseDefaultMaterials);
            if (materials == null) {
                materials = CtmUtils.tryParse(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"), Factory::parseMaterials);
            }
            if (materials == null) {
                throw new JsonSyntaxException("Expected either ctm_textures to have 5 entries for all textures or have directional textures for each direction or to have some directions and a default textures object.");
            }
            ConnectedTextureMap materialsFinal = materials;
            BiPredicate<class_2680, class_2680> conditions = CtmUtils.parseCondition(json);
            return () -> new ConnectedBlockModel(materialsFinal, conditions, AthenaUtils.renderTypeFromJson(json));
        }

        private static ConnectedTextureMap parseMaterials(JsonObject json) {
            ConnectedTextureMap materials = new ConnectedTextureMap();
            for (class_2350 direction : class_2350.values()) {
                if (class_3518.method_15289((JsonObject)json, (String)direction.method_15434())) {
                    materials.put(direction, CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)direction.method_15434())));
                    continue;
                }
                Int2ObjectMap<class_4730> directionMaterials = CtmUtils.parseCtmMaterials(class_3518.method_15281((JsonObject)json, (String)direction.method_15434(), (JsonObject)class_3518.method_15296((JsonObject)json, (String)"default")));
                materials.put(direction, directionMaterials);
            }
            return materials;
        }

        private static ConnectedTextureMap parseDefaultMaterials(JsonObject json) {
            Int2ObjectMap<class_4730> materials = CtmUtils.parseCtmMaterials(json);
            ConnectedTextureMap connectedTextureMap = new ConnectedTextureMap();
            for (class_2350 direction : class_2350.values()) {
                connectedTextureMap.put(direction, materials);
            }
            return connectedTextureMap;
        }
    }
}

