/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai;

import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.interactive.PotionType;
import com.gitlab.srcmc.rctapi.api.ai.config.RCTBattleAIConfig;
import com.gitlab.srcmc.rctapi.api.ai.utils.PokeMath;
import com.gitlab.srcmc.rctapi.api.ai.utils.ResponseBuilder;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class RCTBattleAI
implements BattleAI {
    private double moveBias;
    private double statusMoveBias;
    private double switchBias;
    private double itemBias;
    private double maxSelectMargin;
    private Random rng = new Random();

    public RCTBattleAI() {
        this(new RCTBattleAIConfig());
    }

    public RCTBattleAI(@NotNull RCTBattleAIConfig config) {
        this.moveBias = config.moveBias();
        this.statusMoveBias = config.statusMoveBias();
        this.switchBias = config.switchBias();
        this.itemBias = config.itemBias();
        this.maxSelectMargin = config.maxSelectMargin();
    }

    public ShowdownActionResponse choose(ActiveBattlePokemon pkmn, ShowdownMoveset moveset, boolean forceSwitch) {
        ResponseBuilder builder = ResponseBuilder.create(pkmn, moveset, forceSwitch).margin(this.rng.nextDouble(this.maxSelectMargin)).random(this.rng);
        builder.suggestMoves(candidates -> candidates.map(pair -> {
            Object patt0$temp = pair.second;
            if (patt0$temp instanceof ActiveBattlePokemon) {
                ActiveBattlePokemon targetPkmn = (ActiveBattlePokemon)patt0$temp;
                return new ResponseBuilder.Choice<ResponseBuilder.Pair>((ResponseBuilder.Pair)pair, ((Targetable)pair.second).isAllied((Targetable)pkmn) ? 1.0 + this.evalMove(pkmn.getBattlePokemon(), targetPkmn.getBattlePokemon(), (InBattleMove)pair.first) : 1.0 - this.evalMove(pkmn.getBattlePokemon(), targetPkmn.getBattlePokemon(), (InBattleMove)pair.first));
            }
            return new ResponseBuilder.Choice<ResponseBuilder.Pair>((ResponseBuilder.Pair)pair, 1.0 - this.evalMove(pkmn.getBattlePokemon(), null, (InBattleMove)pair.first));
        }));
        builder.suggestItems(candidates -> candidates.map(pair -> new ResponseBuilder.Choice<ResponseBuilder.Pair>((ResponseBuilder.Pair)pair, 1.0 - this.evalItem((BagItem)pair.first, (BattlePokemon)pair.second))));
        builder.suggestSwitches(candidates -> candidates.map(bp -> new ResponseBuilder.Choice<BattlePokemon>((BattlePokemon)bp, 1.0 - this.evalSwitch(pkmn, (BattlePokemon)bp))));
        return builder.response();
    }

    private double evalMove(BattlePokemon from, BattlePokemon to, InBattleMove move) {
        boolean hasStatus;
        if (to == null) {
            return from.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).map(pkmn -> this.evalMove(from, pkmn.getBattlePokemon(), move)).max(Double::compare).orElse(0.0);
        }
        boolean bl = hasStatus = to.getContextManager().get(BattleContext.Type.STATUS) != null;
        double estDamage = PokeMath.isStatus(move) ? (!hasStatus ? (double)to.getHealth() * this.statusMoveBias * (double)(PokeMath.typeEffectiveness(move, to.getOriginalPokemon()) > 0.0 ? 1 : 0) : 0.0) : (double)Math.min(to.getHealth(), PokeMath.damage(from, to, move));
        double d = 1.0 - ((double)to.getHealth() - estDamage) / (double)to.getHealth();
        return (d < 1.0 ? d * (double)to.getHealth() / (double)to.getMaxHealth() : d) * this.moveBias;
    }

    private double evalItem(BagItem item, BattlePokemon to) {
        if (item instanceof PotionType) {
            PotionType potion = (PotionType)item;
            int amount = potion == PotionType.POTION ? Math.min(20, to.getMaxHealth()) : (potion == PotionType.SUPER_POTION ? Math.min(50, to.getMaxHealth()) : (potion == PotionType.HYPER_POTION ? Math.min(200, to.getMaxHealth()) : (potion == PotionType.MAX_POTION ? to.getMaxHealth() : (potion == PotionType.FULL_RESTORE ? to.getMaxHealth() : 0))));
            boolean hasStatus = to.getContextManager().get(BattleContext.Type.STATUS) != null;
            double estHeal = (double)(Math.min(to.getMaxHealth(), to.getHealth() + amount) - to.getHealth()) / (double)amount;
            return (double)amount / (double)to.getMaxHealth() * (1.0 - (double)to.getHealth() / (double)to.getMaxHealth()) * Math.min(1.0, estHeal * (to.isSentOut() ? 1.0 : 0.75) * (hasStatus && potion.getCuresStatus() ? 1.25 : 1.0)) * this.itemBias;
        }
        return 0.0;
    }

    private double evalSwitch(ActiveBattlePokemon from, BattlePokemon to) {
        double fromHealthBias = 0.5 + 0.5 * (1.0 - (double)(from.hasPokemon() ? from.getBattlePokemon().getHealth() / from.getBattlePokemon().getMaxHealth() : 0));
        double[] d = new double[]{fromHealthBias * (double)to.getHealth() / (double)to.getMaxHealth()};
        from.getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).forEach(pkmn -> {
            int atkTo = pkmn.getBattlePokemon().getOriginalPokemon().getAttack();
            int spaTo = pkmn.getBattlePokemon().getOriginalPokemon().getSpecialAttack();
            d[0] = d[0] * (1.0 - PokeMath.typeEffectiveness(pkmn.getBattlePokemon().getOriginalPokemon(), to.getOriginalPokemon()) / 4.0);
            d[0] = d[0] * ((atkTo > spaTo ? (double)to.getOriginalPokemon().getDefence() / (double)atkTo : (double)to.getOriginalPokemon().getSpecialDefence() / (double)spaTo) / 2.0);
        });
        return Math.min(1.0, d[0]) * this.switchBias;
    }
}

