/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.gitlab.srcmc.rctapi.ModCommon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class PokeMath {
    private static final Random RANDOM = new Random();
    private static final double SUPER_EFFECTIVE = 2.0;
    private static final double NOT_VERY_EFFECTIVE = 0.5;
    private static final double IMMUNE = 0.0;
    private static final String WEATHER_SUN = "sunny";
    private static final String WEATHER_RAIN = "raining";
    private static final Map<ElementalType, Map<ElementalType, Double>> typeChart = new HashMap<ElementalType, Map<ElementalType, Double>>();
    private static final Map<String, Move> moveMap = new HashMap<String, Move>();

    private static Move getMove(InBattleMove move) {
        return moveMap.computeIfAbsent(move.id, key -> {
            MoveTemplate m = Moves.INSTANCE.getByName(key);
            if (m == null) {
                if (!key.equals("recharge")) {
                    ModCommon.LOG.error("Failed to create move template for '" + key + "'");
                }
                m = Moves.INSTANCE.getExceptional();
            }
            return m.create();
        });
    }

    private static double typeEffectiveness(ElementalType attacker, ElementalType defender) {
        if (!typeChart.containsKey(defender)) {
            return 1.0;
        }
        if (typeChart.get(defender).containsKey(attacker)) {
            return typeChart.get(defender).get(attacker);
        }
        return 1.0;
    }

    public static double typeEffectiveness(Pokemon attacker, Pokemon defender) {
        double d = PokeMath.typeEffectiveness(attacker.getPrimaryType(), defender.getPrimaryType(), defender.getAbility());
        if (d != 0.0 && attacker.getSecondaryType() != null && (d *= PokeMath.typeEffectiveness(attacker.getSecondaryType(), defender.getPrimaryType(), defender.getAbility())) != 0.0 && defender.getSecondaryType() != null) {
            d *= PokeMath.typeEffectiveness(attacker.getSecondaryType(), defender.getSecondaryType(), defender.getAbility());
        }
        if (d != 0.0 && defender.getSecondaryType() != null) {
            d *= PokeMath.typeEffectiveness(attacker.getPrimaryType(), defender.getPrimaryType(), defender.getAbility());
        }
        return d;
    }

    public static double typeEffectiveness(InBattleMove move, Pokemon defender) {
        return PokeMath.typeEffectiveness(PokeMath.getMove(move), defender);
    }

    private static double typeEffectiveness(Move move, Pokemon defender) {
        double d = PokeMath.typeEffectiveness(move.getType(), defender.getPrimaryType(), defender.getAbility());
        if (d != 0.0 && defender.getSecondaryType() != null) {
            d *= PokeMath.typeEffectiveness(move.getType(), defender.getPrimaryType(), defender.getAbility());
        }
        return d;
    }

    public static double typeEffectiveness(ElementalType attacker, ElementalType defender, Ability defenderAbility) {
        String defenderAbilityId = defenderAbility.getDisplayName();
        if (attacker.equals(ElementalTypes.INSTANCE.getWATER()) ? defenderAbilityId.equals("cobblemon.ability.stormdrain") || defenderAbilityId.equals("cobblemon.ability.waterabsorb") || defenderAbilityId.equals("cobblemon.ability.dryskin") : (attacker.equals(ElementalTypes.INSTANCE.getELECTRIC()) ? defenderAbilityId.equals("cobblemon.ability.voltabsorb") || defenderAbilityId.equals("cobblemon.ability.lightningrod") || defenderAbilityId.equals("cobblemon.ability.motordrive") : (attacker.equals(ElementalTypes.INSTANCE.getGROUND()) ? defenderAbilityId.equals("cobblemon.ability.levitate") || defenderAbilityId.equals("cobblemon.ability.eartheater") : (attacker.equals(ElementalTypes.INSTANCE.getFIRE()) ? defenderAbilityId.equals("cobblemon.ability.wellbakedbody") || defenderAbilityId.equals("cobblemon.ability.flashfire") : attacker.equals(ElementalTypes.INSTANCE.getGRASS()) && defenderAbilityId.equals("cobblemon.ability.sapsipper"))))) {
            return 0.0;
        }
        double typeEffectiveness = PokeMath.typeEffectiveness(attacker, defender);
        if (defenderAbilityId.equals("cobblemon.ability.wonderguard") && typeEffectiveness != 2.0) {
            return 0.0;
        }
        return typeEffectiveness;
    }

    private static double damage(int attackerLevel, int attackerEffectiveAttack, int defenderEffectiveDefence, double movePower, boolean physical, boolean multiTarget, boolean rain, boolean sun, boolean parentalBond, boolean glaiveRush, boolean burn, boolean zmove, boolean reflect, boolean lightscreen, boolean attackerHasStatus, ElementalType moveType, ElementalType attackerPrimaryType, ElementalType attackerSecondaryType, ElementalType defenderPrimaryType, ElementalType defenderSecondaryType, Ability defenderAbility, Ability attackerAbility) {
        int baseDamage = (int)(((double)(2 * attackerLevel) / 5.0 + 2.0) * movePower * (double)attackerEffectiveAttack / (double)defenderEffectiveDefence / 50.0) + 2;
        if (multiTarget) {
            baseDamage = (int)((double)baseDamage * 0.75);
        }
        if (parentalBond) {
            baseDamage = (int)((double)baseDamage * 0.25);
        }
        if (glaiveRush) {
            baseDamage *= 2;
        }
        if (burn && physical && !attackerAbility.getDisplayName().equals("cobblemon.ability.guts")) {
            baseDamage = (int)((double)baseDamage * 0.5);
        }
        if (attackerHasStatus && attackerAbility.getDisplayName().equals("cobblemon.ability.guts")) {
            baseDamage = (int)((double)baseDamage * 1.5);
        }
        if (sun && moveType.equals(ElementalTypes.INSTANCE.getFIRE()) || rain && moveType.equals(ElementalTypes.INSTANCE.getWATER())) {
            baseDamage = (int)((double)baseDamage * 1.5);
        }
        if (sun && moveType.equals(ElementalTypes.INSTANCE.getWATER()) || rain && moveType.equals(ElementalTypes.INSTANCE.getFIRE())) {
            baseDamage = (int)((double)baseDamage * 0.5);
        }
        if (moveType.equals(attackerPrimaryType) || moveType.equals(attackerSecondaryType)) {
            baseDamage = (int)((double)baseDamage * 1.5);
        }
        baseDamage = (int)((double)baseDamage * PokeMath.typeEffectiveness(moveType, defenderPrimaryType, defenderAbility) * (defenderSecondaryType == null ? 1.0 : PokeMath.typeEffectiveness(moveType, defenderSecondaryType, defenderAbility)));
        return baseDamage > 0 ? Math.max(1.0, (double)baseDamage * (RANDOM.nextDouble() * 0.15 + 0.85)) : (double)baseDamage;
    }

    public static boolean isStatus(InBattleMove inBattleMove) {
        Move move = PokeMath.getMove(inBattleMove);
        return move.getDamageCategory().getName().equals(DamageCategories.INSTANCE.getSTATUS().getName());
    }

    public static int damage(BattlePokemon attacker, BattlePokemon defender, InBattleMove inBattleMove) {
        Move move = PokeMath.getMove(inBattleMove);
        String damageCategory = move.getDamageCategory().getName();
        if (damageCategory.equals(DamageCategories.INSTANCE.getSTATUS().getName())) {
            return 0;
        }
        boolean isPhysicalMove = damageCategory.equals(DamageCategories.INSTANCE.getPHYSICAL().getName());
        boolean isAttackerBurned = false;
        PersistentStatusContainer statusContainer = attacker.getEffectedPokemon().getStatus();
        Collection weather = attacker.getContextManager().get(BattleContext.Type.WEATHER);
        Collection status = attacker.getContextManager().get(BattleContext.Type.STATUS);
        double acc = move.getAccuracy() / 100.0;
        if (statusContainer != null && !statusContainer.isExpired()) {
            isAttackerBurned = statusContainer.getStatus().equals(Statuses.INSTANCE.getBURN());
        }
        return (int)((acc + RANDOM.nextDouble() * (1.0 - acc)) * PokeMath.damage(attacker.getOriginalPokemon().getLevel(), attacker.getOriginalPokemon().getStat((Stat)(isPhysicalMove ? Stats.ATTACK : Stats.SPECIAL_ATTACK)), defender.getOriginalPokemon().getStat((Stat)(isPhysicalMove ? Stats.DEFENCE : Stats.SPECIAL_DEFENCE)), move.getPower(), isPhysicalMove, false, weather != null && weather.stream().anyMatch(c -> c.getId().equals(WEATHER_RAIN)), weather != null && weather.stream().anyMatch(c -> c.getId().equals(WEATHER_SUN)), false, false, isAttackerBurned, false, false, false, status != null && !status.isEmpty(), move.getType(), attacker.getOriginalPokemon().getPrimaryType(), attacker.getOriginalPokemon().getSecondaryType(), defender.getOriginalPokemon().getPrimaryType(), defender.getOriginalPokemon().getSecondaryType(), defender.getOriginalPokemon().getAbility(), attacker.getOriginalPokemon().getAbility()));
    }

    public static double powerAndTypeDamage(double movePower, ElementalType moveType, ElementalType defenderPrimaryType, ElementalType defenderSecondaryType) {
        return movePower * PokeMath.typeEffectiveness(moveType, defenderPrimaryType) * (defenderSecondaryType == null ? 1.0 : PokeMath.typeEffectiveness(moveType, defenderSecondaryType));
    }

    static {
        ElementalTypes types = ElementalTypes.INSTANCE;
        ElementalType NORMAL = types.getNORMAL();
        ElementalType FIGHTING = types.getFIGHTING();
        ElementalType FLYING = types.getFLYING();
        ElementalType POISON = types.getPOISON();
        ElementalType GROUND = types.getGROUND();
        ElementalType ROCK = types.getROCK();
        ElementalType BUG = types.getBUG();
        ElementalType GHOST = types.getGHOST();
        ElementalType STEEL = types.getSTEEL();
        ElementalType FIRE = types.getFIRE();
        ElementalType WATER = types.getWATER();
        ElementalType GRASS = types.getGRASS();
        ElementalType ELECTRIC = types.getELECTRIC();
        ElementalType PSYCHIC = types.getPSYCHIC();
        ElementalType ICE = types.getICE();
        ElementalType DRAGON = types.getDRAGON();
        ElementalType DARK = types.getDARK();
        ElementalType FAIRY = types.getFAIRY();
        typeChart.put(NORMAL, Map.of(FIGHTING, 2.0, GHOST, 0.0));
        typeChart.put(FIGHTING, Map.of(FLYING, 2.0, ROCK, 0.5, BUG, 0.5, PSYCHIC, 2.0, DARK, 0.5, FAIRY, 2.0));
        typeChart.put(FLYING, Map.of(FIGHTING, 0.5, GROUND, 0.0, ROCK, 2.0, BUG, 0.5, GRASS, 0.5, ELECTRIC, 2.0, ICE, 2.0));
        typeChart.put(POISON, Map.of(FIGHTING, 0.5, POISON, 0.5, GROUND, 2.0, BUG, 0.5, GRASS, 0.5, PSYCHIC, 2.0, FAIRY, 0.5));
        typeChart.put(GROUND, Map.of(POISON, 0.5, ROCK, 0.5, WATER, 2.0, GRASS, 2.0, ELECTRIC, 0.0, ICE, 2.0));
        typeChart.put(ROCK, Map.of(NORMAL, 0.5, FIGHTING, 2.0, FLYING, 0.5, POISON, 0.5, GROUND, 2.0, STEEL, 2.0, FIRE, 0.5, WATER, 2.0, GRASS, 2.0));
        typeChart.put(BUG, Map.of(FIGHTING, 0.5, FLYING, 2.0, GROUND, 0.5, ROCK, 2.0, FIRE, 2.0, GRASS, 0.5));
        typeChart.put(GHOST, Map.of(NORMAL, 0.0, FIGHTING, 0.0, POISON, 0.5, BUG, 0.5, GHOST, 2.0, DARK, 2.0));
        HashMap<ElementalType, Double> steelMap = new HashMap<ElementalType, Double>(Map.of(NORMAL, 0.5, FIGHTING, 2.0, FLYING, 0.5, POISON, 0.0, GROUND, 2.0, ROCK, 0.5, BUG, 0.5, STEEL, 0.5, FIRE, 2.0, GRASS, 0.5));
        steelMap.put(PSYCHIC, 0.5);
        steelMap.put(ICE, 0.5);
        steelMap.put(DRAGON, 0.5);
        steelMap.put(FAIRY, 0.5);
        typeChart.put(STEEL, steelMap);
        typeChart.put(FIRE, Map.of(GROUND, 2.0, ROCK, 2.0, BUG, 0.5, STEEL, 0.5, FIRE, 0.5, WATER, 2.0, GRASS, 0.5, ICE, 0.5, FAIRY, 0.5));
        typeChart.put(WATER, Map.of(STEEL, 0.5, FIRE, 0.5, WATER, 0.5, GRASS, 2.0, ELECTRIC, 2.0, ICE, 0.5));
        typeChart.put(GRASS, Map.of(FLYING, 2.0, POISON, 2.0, GROUND, 0.5, BUG, 2.0, FIRE, 2.0, WATER, 0.5, GRASS, 0.5, ELECTRIC, 0.5, ICE, 2.0));
        typeChart.put(ELECTRIC, Map.of(FLYING, 0.5, GROUND, 2.0, STEEL, 0.5, ELECTRIC, 0.5));
        typeChart.put(PSYCHIC, Map.of(FIGHTING, 0.5, BUG, 2.0, GHOST, 2.0, PSYCHIC, 0.5, DARK, 2.0));
        typeChart.put(ICE, Map.of(FIGHTING, 2.0, ROCK, 2.0, STEEL, 2.0, FIRE, 2.0, ICE, 0.5));
        typeChart.put(DRAGON, Map.of(FIRE, 0.5, WATER, 0.5, GRASS, 0.5, ELECTRIC, 0.5, ICE, 2.0, DRAGON, 2.0, FAIRY, 2.0));
        typeChart.put(DARK, Map.of(FIGHTING, 2.0, BUG, 2.0, GHOST, 0.5, PSYCHIC, 0.0, DARK, 0.5, FAIRY, 2.0));
        typeChart.put(FAIRY, Map.of(FIGHTING, 0.5, POISON, 2.0, BUG, 0.5, STEEL, 2.0, DRAGON, 0.0, DARK, 0.5));
    }
}

