/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.DefaultActionResponse;
import com.cobblemon.mod.common.battles.ForcePassActionResponse;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ResponseBuilder {
    private Supplier<Stream<BattlePokemon>> switchCandidates = Stream::empty;
    private Supplier<Stream<Pair<BagItem, BattlePokemon>>> itemCandidates = Stream::empty;
    private Supplier<Stream<Pair<InBattleMove, Targetable>>> moveCandidates = Stream::empty;
    private List<Choice<Supplier<ShowdownActionResponse>>> choices = new ArrayList<Choice<Supplier<ShowdownActionResponse>>>();
    private Random rng = new Random(0L);
    private ActiveBattlePokemon pkmn;
    private ShowdownMoveset moveset;
    private boolean forceSwitch;
    private boolean forceMove;
    private boolean mustChoose;
    private double margin;
    private double rdf = 3.0;

    public static ResponseBuilder create(ActiveBattlePokemon pkmn, ShowdownMoveset moveset, boolean forceSwitch) {
        ResponseBuilder builder = new ResponseBuilder();
        builder.mustChoose = pkmn.getActor().getMustChoose() && BattleStates.get(pkmn.getBattle()).isTurn(pkmn);
        builder.forceSwitch = forceSwitch;
        builder.forceMove = false;
        builder.moveset = moveset;
        builder.pkmn = pkmn;
        if (!builder.forceSwitch && builder.mustChoose && pkmn.hasPokemon()) {
            BattleActor battleActor;
            if (builder.moveset != null && builder.moveset.moves.stream().findFirst().isPresent()) {
                if (builder.moveset.moves.stream().anyMatch(InBattleMove::mustBeUsed)) {
                    builder.moveCandidates = () -> builder.moveset.moves.stream().filter(InBattleMove::mustBeUsed).flatMap(mv -> mv.getTargets(pkmn) == null || mv.getTargets(pkmn).isEmpty() ? Stream.of(new Pair<InBattleMove, Targetable>((InBattleMove)mv, null)) : mv.getTargets(pkmn).stream().map(t -> new Pair<InBattleMove, Targetable>((InBattleMove)mv, (Targetable)t)));
                    builder.forceMove = true;
                } else {
                    builder.moveCandidates = () -> builder.moveset.moves.stream().filter(InBattleMove::canBeUsed).flatMap(mv -> mv.getTargets(pkmn) == null || mv.getTargets(pkmn).isEmpty() ? Stream.of(new Pair<InBattleMove, Targetable>((InBattleMove)mv, null)) : mv.getTargets(pkmn).stream().map(t -> new Pair<InBattleMove, Targetable>((InBattleMove)mv, (Targetable)t)));
                }
            }
            if (!builder.forceMove && pkmn.getActor().canFitForcedAction() && (battleActor = pkmn.getActor()) instanceof BattleManager.TrainerEntityBattleActor) {
                BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)battleActor;
                builder.itemCandidates = () -> actor.getBag().getItems().stream().flatMap(bi -> pkmn.getActor().getPokemonList().stream().filter(p -> bi.canUse(pkmn.getBattle(), p)).map(p -> new Pair<BagItem, BattlePokemon>((BagItem)bi, (BattlePokemon)p)));
            }
        }
        if (!builder.forceMove && (pkmn.hasPokemon() && builder.mustChoose || builder.forceSwitch != builder.mustChoose)) {
            builder.switchCandidates = () -> pkmn.getActor().getPokemonList().stream().filter(BattlePokemon::canBeSentOut);
        }
        BattleStates.setTurn(pkmn, false);
        return builder;
    }

    public ResponseBuilder suggestSwitches(Function<Stream<BattlePokemon>, Stream<Choice<BattlePokemon>>> consumer) {
        consumer.apply(this.switchCandidates.get()).forEach(choice -> this.choices.add(new Choice<Supplier<ShowdownActionResponse>>(() -> {
            BattleStates.setWillBeSwitchedInFor((BattlePokemon)choice.value, this.pkmn);
            return new SwitchActionResponse(((BattlePokemon)choice.value).getUuid());
        }, choice.weight)));
        return this;
    }

    public ResponseBuilder suggestItems(Function<Stream<Pair<BagItem, BattlePokemon>>, Stream<Choice<Pair<BagItem, BattlePokemon>>>> consumer) {
        BattleActor battleActor = this.pkmn.getActor();
        if (battleActor instanceof BattleManager.TrainerEntityBattleActor) {
            BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)battleActor;
            consumer.apply(this.itemCandidates.get()).forEach(choice -> this.choices.add(new Choice<Supplier<ShowdownActionResponse>>(() -> {
                BagItem item = (BagItem)((Pair)choice.value).first;
                BattlePokemon pkmn = (BattlePokemon)((Pair)choice.value).second;
                this.pkmn.getActor().forceChoose((ShowdownActionResponse)new BagItemActionResponse(actor.getBag().use(item), pkmn, pkmn.getUuid().toString()));
                return new ForcePassActionResponse();
            }, choice.weight)));
        }
        return this;
    }

    public ResponseBuilder suggestMoves(Function<Stream<Pair<InBattleMove, Targetable>>, Stream<Choice<Pair<InBattleMove, Targetable>>>> consumer) {
        consumer.apply(this.moveCandidates.get()).forEach(choice -> {
            InBattleMove move = (InBattleMove)((Pair)choice.value).first;
            Targetable target = (Targetable)((Pair)choice.value).second;
            this.choices.add(new Choice<Supplier<ShowdownActionResponse>>(() -> new MoveActionResponse(move.id, target != null ? target.getPNX() : null, null), choice.weight));
        });
        return this;
    }

    public ShowdownActionResponse response(MessagePassingQueue.Consumer<ShowdownActionResponse> consumer) {
        PassActionResponse response = this.choices.isEmpty() ? (this.mustChoose && this.pkmn.hasPokemon() ? new DefaultActionResponse() : PassActionResponse.INSTANCE) : (ShowdownActionResponse)((Supplier)ResponseBuilder.getRandom(ResponseBuilder.takeWithMargin(this.choices.stream().sorted(), (double)this.margin), (Random)this.rng, (double)this.margin, (double)this.rdf).orElse(new Choice<Supplier<ShowdownActionResponse>>((Supplier<ShowdownActionResponse>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/cobblemon/mod/common/battles/ShowdownActionResponse;)(), (double)0.0)).value).get();
        consumer.accept((Object)response);
        return response;
    }

    public ShowdownActionResponse response() {
        return this.response((MessagePassingQueue.Consumer<ShowdownActionResponse>)((MessagePassingQueue.Consumer)r -> {}));
    }

    public ResponseBuilder margin(double margin) {
        this.margin = margin;
        return this;
    }

    public ResponseBuilder random(Random rng) {
        this.rng = rng;
        return this;
    }

    private static <T> Stream<Choice<T>> takeWithMargin(Stream<Choice<T>> in, double margin) {
        double[] w = new double[]{Double.NEGATIVE_INFINITY};
        return in.takeWhile(choice -> {
            if (w[0] == Double.NEGATIVE_INFINITY) {
                w[0] = choice.weight;
            } else if (choice.weight - w[0] > margin) {
                return false;
            }
            return true;
        });
    }

    private static <T> Optional<Choice<T>> getRandom(Stream<Choice<T>> stream, Random rng, double margin, double f) {
        Choice c;
        Iterator it = stream.iterator();
        if (it.hasNext()) {
            Choice next = (Choice)it.next();
            double start = next.weight;
            double w = 0.0;
            int i = 0;
            c = next;
            while (it.hasNext()) {
                next = (Choice)it.next();
                w = margin > 0.0 ? (next.weight - start) / margin : 1.0;
                if (rng.nextInt((int)((double)(++i) * (1.0 + w * f))) != 0) continue;
                c = next;
            }
        } else {
            c = null;
        }
        return Optional.ofNullable(c);
    }

    public static class Choice<T>
    implements Comparable<Choice<?>> {
        public final T value;
        public final double weight;

        public Choice(T value, double weight) {
            this.value = value;
            this.weight = weight;
        }

        @Override
        public int compareTo(Choice<?> other) {
            return Double.compare(this.weight, other.weight);
        }
    }

    public static class Pair<T, U> {
        public final T first;
        public final U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }
    }
}

