/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.battle;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.gitlab.srcmc.rctapi.api.battle.BattleFormat;
import com.gitlab.srcmc.rctapi.api.battle.BattleRules;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class BattleState {
    private final Map<UUID, ActorState> actorStates = new HashMap<UUID, ActorState>();
    private final PokemonBattle battle;
    private final BattleFormat format;
    private final BattleRules rules;
    private final List<Trainer> participants1;
    private final List<Trainer> participants2;
    protected boolean endForced;

    @Deprecated(since="0.10.7-beta")
    public BattleState(@NotNull PokemonBattle battle, @NotNull BattleRules rules) {
        this(battle, BattleFormat.GEN_9_SINGLES, rules, List.of(), List.of());
    }

    public BattleState(@NotNull PokemonBattle battle, @NotNull BattleFormat format, @NotNull BattleRules rules, @NotNull List<Trainer> participants1, @NotNull List<Trainer> participants2) {
        this.battle = battle;
        this.format = format;
        this.rules = rules;
        this.participants1 = Collections.unmodifiableList(participants1);
        this.participants2 = Collections.unmodifiableList(participants2);
    }

    @NotNull
    public BattleFormat getFormat() {
        return this.format;
    }

    @NotNull
    public ActorState getState(@NotNull UUID actorUUID) {
        return this.actorStates.computeIfAbsent(actorUUID, k -> new ActorState(this));
    }

    @NotNull
    public PokemonBattle getBattle() {
        return this.battle;
    }

    @NotNull
    public BattleRules getRules() {
        return this.rules;
    }

    @NotNull
    public List<Trainer> getParticipants1() {
        return this.participants1;
    }

    @NotNull
    public List<Trainer> getParticipants2() {
        return this.participants2;
    }

    @NotNull
    public List<Trainer> getWinners() {
        return this.battle.getEnded() ? (this.battle.getWinners().size() > 0 && ((BattleActor)this.battle.getWinners().getFirst()).getSide() == this.battle.getSide1() ? this.participants1 : this.participants2) : List.of();
    }

    @NotNull
    public List<Trainer> getLosers() {
        return this.battle.getEnded() ? (this.battle.getLosers().size() > 0 && ((BattleActor)this.battle.getLosers().getFirst()).getSide() == this.battle.getSide1() ? this.participants1 : this.participants2) : List.of();
    }

    public int getWinnerSide() {
        return this.battle.getEnded() ? (this.battle.getWinners().size() > 0 && ((BattleActor)this.battle.getWinners().getFirst()).getSide() == this.battle.getSide1() ? 1 : 2) : 0;
    }

    public int getLoserSide() {
        return this.battle.getEnded() ? (this.battle.getLosers().size() > 0 && ((BattleActor)this.battle.getLosers().getFirst()).getSide() == this.battle.getSide1() ? 1 : 2) : 0;
    }

    public boolean isEndForced() {
        return this.endForced;
    }

    public class ActorState {
        private int itemsUsed;

        public ActorState(BattleState this$0) {
        }

        public void setItemsUsed(int itemsUsed) {
            this.itemsUsed = itemsUsed;
        }

        public int getItemsUsed() {
            return this.itemsUsed;
        }
    }
}

