/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.commands;

import com.cobblemon.mod.common.battles.BattleType;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.battle.BattleFormat;
import com.gitlab.srcmc.rctapi.api.battle.BattleRules;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import com.gitlab.srcmc.rctapi.api.events.EventListener;
import com.gitlab.srcmc.rctapi.api.events.Events;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import com.gitlab.srcmc.rctapi.commands.BattleEndCommand;
import com.gitlab.srcmc.rctapi.commands.arguments.BattleEndCommandMapArgument;
import com.gitlab.srcmc.rctapi.commands.arguments.BattleRulesArgument;
import com.gitlab.srcmc.rctapi.commands.arguments.TrainerIdArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public abstract class CommandsContext {
    private static final String CMD_BATTLE = "battle";
    private static final String ARG_PARTICIPANT = "participant";
    private static final String ARG_VS = "vs";
    private static final String ARG_RULES = "rules";
    private static final String ARG_WIN_COMMANDS = "onwin";
    private static final String CMD_ATTACH = "attach";
    private static final String ARG_TRAINER_ID = "trainerId";
    private static final String ARG_TRAINER_ENTITY = "trainerEntity";

    public abstract String getPrefix();

    public abstract int getWinCommandsPermission();

    void onCommandRegistration(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 env) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)CMD_BATTLE);
        for (BattleFormat format : BattleFormat.values()) {
            builder.then(this.builderFormat(format));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.getPrefix()).requires(css -> css.method_9259(2))).then(class_2170.method_9247((String)CMD_ATTACH).then(class_2170.method_9244((String)ARG_TRAINER_ID, (ArgumentType)TrainerIdArgument.id()).suggests(this::get_trainer_id_suggestions).then(class_2170.method_9244((String)ARG_TRAINER_ENTITY, (ArgumentType)class_2186.method_9309()).executes(this::attach))))).then((ArgumentBuilder)builder));
    }

    private ArgumentBuilder<class_2168, ?> builderFormat(BattleFormat format) {
        BattleType battleType = format.getCobblemonBattleFormat().getBattleType();
        int actorsPerSide = battleType.getActorsPerSide();
        LiteralArgumentBuilder builder = class_2170.method_9247((String)format.name());
        long p = (long)Math.pow(2.0, 2 * actorsPerSide);
        for (long i = 0L; i < p; ++i) {
            builder = (LiteralArgumentBuilder)builder.then(this.builderParticipants(format, 0, 0, actorsPerSide, i, 0L));
        }
        return builder;
    }

    private ArgumentBuilder<class_2168, ?> builderParticipants(BattleFormat format, int side, int actor, int actorsPerSide, long entityArg, long optionalArgs) {
        if (actor < actorsPerSide) {
            RequiredArgumentBuilder arg;
            RequiredArgumentBuilder requiredArgumentBuilder = arg = (1L << side * actorsPerSide + actor & entityArg) != 0L ? class_2170.method_9244((String)CommandsContext.getParticipantEntityId(side, actor), (ArgumentType)class_2186.method_9309()) : RequiredArgumentBuilder.argument((String)CommandsContext.getParticipantId(side, actor), (ArgumentType)TrainerIdArgument.id()).suggests(this::get_trainer_id_suggestions);
            return actor + 1 < actorsPerSide ? arg.then(this.builderParticipants(format, side, actor + 1, actorsPerSide, entityArg, optionalArgs)) : (side < 1 ? arg.then(class_2170.method_9247((String)ARG_VS).then(this.builderParticipants(format, side + 1, 0, actorsPerSide, entityArg, optionalArgs))) : this.builderOptionalArgs(arg, format, optionalArgs));
        }
        throw new IllegalArgumentException("invalid battle actor index: " + actor);
    }

    private ArgumentBuilder<class_2168, ?> builderOptionalArgs(RequiredArgumentBuilder<class_2168, ?> arg, BattleFormat format, long optionalArgs) {
        arg = (RequiredArgumentBuilder)arg.executes(ctx -> this.battle((CommandContext<class_2168>)ctx, format, null, null));
        arg = (RequiredArgumentBuilder)arg.then(class_2170.method_9247((String)ARG_RULES).then(class_2170.method_9244((String)ARG_RULES, (ArgumentType)BattleRulesArgument.battleRules()).executes(ctx -> this.battle((CommandContext<class_2168>)ctx, format, (BattleRules)ctx.getArgument(ARG_RULES, BattleRules.class), null))));
        arg = (RequiredArgumentBuilder)arg.then(class_2170.method_9247((String)ARG_WIN_COMMANDS).then(class_2170.method_9244((String)ARG_WIN_COMMANDS, (ArgumentType)BattleEndCommandMapArgument.map()).executes(ctx -> this.battle((CommandContext<class_2168>)ctx, format, null, (BattleEndCommand.Map)ctx.getArgument(ARG_WIN_COMMANDS, BattleEndCommand.Map.class)))));
        arg = (RequiredArgumentBuilder)arg.then(class_2170.method_9247((String)ARG_RULES).then(class_2170.method_9244((String)ARG_RULES, (ArgumentType)BattleRulesArgument.battleRules()).then(class_2170.method_9247((String)ARG_WIN_COMMANDS).then(class_2170.method_9244((String)ARG_WIN_COMMANDS, (ArgumentType)BattleEndCommandMapArgument.map()).executes(ctx -> this.battle((CommandContext<class_2168>)ctx, format, (BattleRules)ctx.getArgument(ARG_RULES, BattleRules.class), (BattleEndCommand.Map)ctx.getArgument(ARG_WIN_COMMANDS, BattleEndCommand.Map.class)))))));
        arg = (RequiredArgumentBuilder)arg.then(class_2170.method_9247((String)ARG_WIN_COMMANDS).then(class_2170.method_9244((String)ARG_WIN_COMMANDS, (ArgumentType)BattleEndCommandMapArgument.map()).then(class_2170.method_9247((String)ARG_RULES).then(class_2170.method_9244((String)ARG_RULES, (ArgumentType)BattleRulesArgument.battleRules()).executes(ctx -> this.battle((CommandContext<class_2168>)ctx, format, (BattleRules)ctx.getArgument(ARG_RULES, BattleRules.class), (BattleEndCommand.Map)ctx.getArgument(ARG_WIN_COMMANDS, BattleEndCommand.Map.class)))))));
        return arg;
    }

    private int attach(CommandContext<class_2168> context) {
        try {
            String trainerId = (String)context.getArgument(ARG_TRAINER_ID, String.class);
            TrainerNPC trainer = RCTApi.getInstance(this.getPrefix()).getTrainerRegistry().getById(trainerId, TrainerNPC.class);
            if (trainer == null) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)String.format("No such trainer registered '%s'", trainerId)));
            } else {
                class_1309 trainerEntity = (class_1309)class_2186.method_9313(context, (String)ARG_TRAINER_ENTITY);
                trainer.setEntity(trainerEntity);
                ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)String.format("Trainer '%s' attached to '%s'", trainerId, trainerEntity.method_5476().getString())));
            }
        }
        catch (Exception e) {
            return CommandsContext.handleError(context, e);
        }
        return 0;
    }

    private int battle(CommandContext<class_2168> context, BattleFormat format, BattleRules rules, BattleEndCommand.Map commands) {
        try {
            RCTApi rct = RCTApi.getInstance(this.getPrefix());
            TrainerRegistry registry = rct.getTrainerRegistry();
            int actorsPerSide = format.getCobblemonBattleFormat().getBattleType().getActorsPerSide();
            List participants = List.of(new ArrayList(), new ArrayList());
            for (int side = 0; side < 2; ++side) {
                List list = participants.get(side);
                for (int actor = 0; actor < actorsPerSide; ++actor) {
                    String trainerId;
                    try {
                        class_1309 trainerEntity = (class_1309)class_2186.method_9313(context, (String)CommandsContext.getParticipantEntityId(side, actor));
                        trainerId = registry.getId(trainerEntity);
                        if (trainerId == null) {
                            throw new Exception(String.format("'%s' has no trainer attached", trainerEntity.method_5477().getString()));
                        }
                    }
                    catch (IllegalArgumentException e2) {
                        trainerId = (String)context.getArgument(CommandsContext.getParticipantId(side, actor), String.class);
                        try {
                            UUID entityUUID = UUID.fromString(trainerId);
                            class_1309 trainerEntity = (class_1309)((class_2168)context.getSource()).method_9225().method_14190(entityUUID);
                            trainerId = registry.getId(trainerEntity);
                            if (trainerId == null) {
                                throw new Exception(String.format("'%s' has no trainer attached", trainerEntity.method_5477().getString()));
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    Trainer trainer = registry.getById(trainerId);
                    if (trainer == null) {
                        throw new Exception(String.format("No such trainer registered '%s'", trainerId));
                    }
                    list.add(trainer);
                }
            }
            if (rules == null) {
                rules = new BattleRules();
            }
            EventListener[] onEnd = new EventListener[1];
            if (commands != null) {
                commands.values().stream().flatMap(Stream::of).forEach(c -> {
                    c.setPermissionSupplier(this::getWinCommandsPermission);
                    c.setTitleSupplier(this::getPrefix);
                });
                onEnd[0] = e -> {
                    BattleState state;
                    MinecraftServer server = ((class_2168)context.getSource()).method_9211();
                    if (server != null && !(state = (BattleState)e.getValue()).isEndForced()) {
                        class_1309[] winnersFirst = (class_1309[])Stream.concat(state.getWinners().stream(), state.getLosers().stream()).map(Trainer::getEntity).toArray(class_1309[]::new);
                        Stream.of(commands.getOrDefault(state.getWinnerSide(), new BattleEndCommand[0])).forEach(c -> c.execute(server, winnersFirst));
                    }
                    rct.getEventContext().unregister(Events.BATTLE_ENDED, onEnd[0]);
                };
                rct.getEventContext().register(Events.BATTLE_ENDED, onEnd[0]);
            }
            RCTApi.getInstance(this.getPrefix()).getBattleManager().start(participants.get(0), participants.get(1), format, rules);
        }
        catch (Exception e3) {
            return CommandsContext.handleError(context, e3);
        }
        return 0;
    }

    private CompletableFuture<Suggestions> get_trainer_id_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        RCTApi.getInstance(this.getPrefix()).getTrainerRegistry().getIds().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static String getParticipantId(int side, int actor) {
        return String.format("%s_%d_%d", ARG_PARTICIPANT, side, actor);
    }

    private static String getParticipantEntityId(int side, int actor) {
        return String.format("%s_%d_%d_E", ARG_PARTICIPANT, side, actor);
    }

    private static int handleError(CommandContext<class_2168> context, Exception e) {
        ModCommon.LOG.error(e.getMessage(), (Throwable)e);
        ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)e.getMessage()));
        return 1;
    }
}

