/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.metacontent.cobblenav.Cobblenav;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u000b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u000b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0015\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/metacontent/cobblenav/client/config/ClientCobblenavConfig;", "", "<init>", "()V", "", "save", "", "screenScale", "F", "getScreenScale", "()F", "", "sendErrorMessagesToChat", "Z", "getSendErrorMessagesToChat", "()Z", "obscureUnknownPokemon", "getObscureUnknownPokemon", "useSwimmingAnimationIfSubmerged", "getUseSwimmingAnimationIfSubmerged", "", "pokefinderOverlayOffset", "I", "getPokefinderOverlayOffset", "()I", "trackArrowYOffset", "getTrackArrowYOffset", "Companion", "cobblenav-common"})
public final class ClientCobblenavConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float screenScale;
    private final boolean sendErrorMessagesToChat;
    private final boolean obscureUnknownPokemon;
    private final boolean useSwimmingAnimationIfSubmerged;
    private final int pokefinderOverlayOffset;
    private final int trackArrowYOffset;
    @NotNull
    private static final String PATH = "config/cobblenav/client-config.json";
    @NotNull
    private static final Gson GSON;

    public ClientCobblenavConfig() {
        this.screenScale = 1.0f;
        this.sendErrorMessagesToChat = true;
        this.obscureUnknownPokemon = true;
        this.useSwimmingAnimationIfSubmerged = true;
        this.pokefinderOverlayOffset = 10;
        this.trackArrowYOffset = 80;
    }

    public final float getScreenScale() {
        return this.screenScale;
    }

    public final boolean getSendErrorMessagesToChat() {
        return this.sendErrorMessagesToChat;
    }

    public final boolean getObscureUnknownPokemon() {
        return this.obscureUnknownPokemon;
    }

    public final boolean getUseSwimmingAnimationIfSubmerged() {
        return this.useSwimmingAnimationIfSubmerged;
    }

    public final int getPokefinderOverlayOffset() {
        return this.pokefinderOverlayOffset;
    }

    public final int getTrackArrowYOffset() {
        return this.trackArrowYOffset;
    }

    public final void save() {
        File configFile = new File(PATH);
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            GSON.toJson((Object)this, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            Cobblenav.INSTANCE.getLOGGER().error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/metacontent/cobblenav/client/config/ClientCobblenavConfig$Companion;", "", "<init>", "()V", "Lcom/metacontent/cobblenav/client/config/ClientCobblenavConfig;", "load", "()Lcom/metacontent/cobblenav/client/config/ClientCobblenavConfig;", "", "PATH", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "cobblenav-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientCobblenavConfig load() {
            File configFile = new File(ClientCobblenavConfig.PATH);
            configFile.getParentFile().mkdirs();
            ClientCobblenavConfig config = null;
            try {
                if (!configFile.exists()) {
                    configFile.createNewFile();
                }
                FileReader fileReader = new FileReader(configFile);
                ClientCobblenavConfig clientCobblenavConfig = (ClientCobblenavConfig)GSON.fromJson((Reader)fileReader, ClientCobblenavConfig.class);
                if (clientCobblenavConfig == null) {
                    clientCobblenavConfig = new ClientCobblenavConfig();
                }
                config = clientCobblenavConfig;
                fileReader.close();
            }
            catch (Exception e) {
                Cobblenav.INSTANCE.getLOGGER().error(e.getMessage(), (Throwable)e);
                config = new ClientCobblenavConfig();
            }
            config.save();
            return config;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

