/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.config.FeatureWeights;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\nR\u001a\u0010\u0012\u001a\u00020\u00118\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00118\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u00188\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u00188\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u001cR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/metacontent/cobblenav/config/CobblenavConfig;", "", "<init>", "()V", "", "save", "", "hideUnknownPokemon", "Z", "getHideUnknownPokemon", "()Z", "showPokemonTooltips", "getShowPokemonTooltips", "hideUnknownPokemonTooltips", "getHideUnknownPokemonTooltips", "hideNaturalBlockConditions", "getHideNaturalBlockConditions", "", "checkSpawnWidth", "I", "getCheckSpawnWidth", "()I", "checkSpawnHeight", "getCheckSpawnHeight", "", "searchAreaWidth", "D", "getSearchAreaWidth", "()D", "searchAreaHeight", "getSearchAreaHeight", "Lcom/metacontent/cobblenav/config/FeatureWeights;", "pokemonFeatureWeights", "Lcom/metacontent/cobblenav/config/FeatureWeights;", "getPokemonFeatureWeights", "()Lcom/metacontent/cobblenav/config/FeatureWeights;", "", "", "collectableConditions", "Ljava/util/List;", "getCollectableConditions", "()Ljava/util/List;", "Companion", "cobblenav-common"})
public final class CobblenavConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hideUnknownPokemon;
    private final boolean showPokemonTooltips;
    private final boolean hideUnknownPokemonTooltips;
    private final boolean hideNaturalBlockConditions;
    private final int checkSpawnWidth;
    private final int checkSpawnHeight;
    private final double searchAreaWidth;
    private final double searchAreaHeight;
    @NotNull
    private final FeatureWeights pokemonFeatureWeights = FeatureWeights.Companion.getBASE();
    @NotNull
    private final List<String> collectableConditions;
    @NotNull
    private static final String PATH = "config/cobblenav/server-config.json";
    @NotNull
    private static final Gson GSON;

    public CobblenavConfig() {
        this.showPokemonTooltips = true;
        this.hideNaturalBlockConditions = true;
        this.checkSpawnWidth = 8;
        this.checkSpawnHeight = 16;
        this.searchAreaWidth = 200.0;
        this.searchAreaHeight = 200.0;
        Object[] objectArray = new String[]{"biomes", "coordinates", "light", "moon_phase", "sky_light", "slime_chunk", "structures", "time_range", "under_open_sky", "weather", "y_height", "depth_submerged", "depth_surface", "fluid_submerged", "fluid_surface", "area_type_block", "grounded_type_block", "seafloor_type_block"};
        this.collectableConditions = CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean getHideUnknownPokemon() {
        return this.hideUnknownPokemon;
    }

    public final boolean getShowPokemonTooltips() {
        return this.showPokemonTooltips;
    }

    public final boolean getHideUnknownPokemonTooltips() {
        return this.hideUnknownPokemonTooltips;
    }

    public final boolean getHideNaturalBlockConditions() {
        return this.hideNaturalBlockConditions;
    }

    public final int getCheckSpawnWidth() {
        return this.checkSpawnWidth;
    }

    public final int getCheckSpawnHeight() {
        return this.checkSpawnHeight;
    }

    public final double getSearchAreaWidth() {
        return this.searchAreaWidth;
    }

    public final double getSearchAreaHeight() {
        return this.searchAreaHeight;
    }

    @NotNull
    public final FeatureWeights getPokemonFeatureWeights() {
        return this.pokemonFeatureWeights;
    }

    @NotNull
    public final List<String> getCollectableConditions() {
        return this.collectableConditions;
    }

    public final void save() {
        File configFile = new File(PATH);
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            GSON.toJson((Object)this, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            Cobblenav.INSTANCE.getLOGGER().error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/metacontent/cobblenav/config/CobblenavConfig$Companion;", "", "<init>", "()V", "Lcom/metacontent/cobblenav/config/CobblenavConfig;", "load", "()Lcom/metacontent/cobblenav/config/CobblenavConfig;", "", "PATH", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "cobblenav-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CobblenavConfig load() {
            File configFile = new File(CobblenavConfig.PATH);
            configFile.getParentFile().mkdirs();
            CobblenavConfig config = null;
            try {
                if (!configFile.exists()) {
                    configFile.createNewFile();
                }
                FileReader fileReader = new FileReader(configFile);
                CobblenavConfig cobblenavConfig = (CobblenavConfig)GSON.fromJson((Reader)fileReader, CobblenavConfig.class);
                if (cobblenavConfig == null) {
                    cobblenavConfig = new CobblenavConfig();
                }
                config = cobblenavConfig;
                fileReader.close();
            }
            catch (Exception e) {
                Cobblenav.INSTANCE.getLOGGER().error(e.getMessage(), (Throwable)e);
                config = new CobblenavConfig();
            }
            config.save();
            return config;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

