/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.api.utils;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class OptionUtils {
    public static Stream<Option<?>> getFlatOptions(YetAnotherConfigLib yacl) {
        return yacl.categories().stream().flatMap(category -> category.groups().stream()).flatMap(group -> {
            Stream<ListOption> stream;
            if (group instanceof ListOption) {
                ListOption list = (ListOption)group;
                stream = Stream.of(list);
            } else {
                stream = group.options().stream();
            }
            return stream;
        });
    }

    public static void consumeOptions(YetAnotherConfigLib yacl, Function<Option<?>, Boolean> consumer) {
        for (ConfigCategory category : yacl.categories()) {
            for (OptionGroup group : category.groups()) {
                if (group instanceof ListOption) {
                    ListOption list = (ListOption)group;
                    if (!consumer.apply(list).booleanValue()) continue;
                    return;
                }
                for (Option option : group.options()) {
                    if (!consumer.apply(option).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    public static void forEachOptions(YetAnotherConfigLib yacl, Consumer<Option<?>> consumer) {
        OptionUtils.consumeOptions(yacl, opt -> {
            consumer.accept((Option<?>)opt);
            return false;
        });
    }
}

