/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.hisroyalty.GachaMachine;
import com.hisroyalty.ModTags;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class GachaMachineBlock
extends class_2248 {
    public static final class_2758 LEVEL_X;
    public static final class_2758 LEVEL;
    public static final class_2753 FACING;
    public static final class_2754<class_2756> HALF;

    public GachaMachineBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2756.field_12607));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{HALF});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_28500(HALF).orElse(null) == class_2756.field_12609) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    private static int deserializeLevel() {
        int n;
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        File configFile = new File(configDir, "gachamachine/config.json");
        if (!configFile.exists()) {
            System.err.println("Config file not found: " + configFile.getAbsolutePath());
        }
        FileReader reader = new FileReader(configFile);
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            DataResult result = Codec.INT.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            Integer value = result.resultOrPartial(System.err::println).orElse(3);
            n = value;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return 3;
            }
        }
        reader.close();
        return n;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10084()).method_45474();
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return Collections.emptyList();
        }
        return super.method_9560(state, builder);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!world.method_8608()) {
            world.method_8501(pos.method_10084(), (class_2680)((class_2680)this.method_9564().method_11657(HALF, (Comparable)class_2756.field_12609)).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING))));
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            boolean valid = true;
            class_2756 half = (class_2756)state.method_11654(HALF);
            if (!(half != class_2756.field_12607 || direction != class_2350.field_11036 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) == class_2756.field_12609)) {
                valid = false;
            }
            if (!(half != class_2756.field_12609 || direction != class_2350.field_11033 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) == class_2756.field_12607)) {
                valid = false;
            }
            if (!valid) {
                return class_2246.field_10124.method_9564();
            }
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean isValidItem(class_1799 stack) {
        return stack.method_31573(ModTags.Items.CURRENCY_ITEMS);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.isValidItem(stack)) {
            class_5250 message;
            class_6862<class_1792> currencyTag = ModTags.Items.CURRENCY_ITEMS;
            StringBuilder itemNames = new StringBuilder();
            for (class_6880 itemRegistryEntry : class_7923.field_41178.method_40260(currencyTag)) {
                String itemName = ((class_5321)itemRegistryEntry.method_40230().get()).method_29177().method_12832();
                itemNames.append(itemName).append(", ");
            }
            if (itemNames.length() > 0) {
                itemNames.setLength(itemNames.length() - 2);
            }
            if ((message = class_2561.method_43469((String)"message.gacha_machine.invalid_currency", (Object[])new Object[]{class_2561.method_43470((String)itemNames.toString()).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10977(class_124.field_1061))).getString().length() <= 128) {
                player.method_7353((class_2561)message, true);
            } else {
                player.method_7353((class_2561)message, false);
            }
            return class_9062.field_47733;
        }
        if (this.isValidItem(stack)) {
            int currentLevel = (Integer)state.method_11654((class_2769)LEVEL);
            if (currentLevel < GachaMachineBlock.deserializeLevel() - 1) {
                this.updateLevel(world, pos, state, currentLevel + 1);
                class_5250 text = class_2561.method_43470((String)"[").method_10852(class_2561.method_30163((String)String.valueOf(currentLevel + 1))).method_10852(class_2561.method_30163((String)"/")).method_10852(class_2561.method_30163((String)String.valueOf(GachaMachineBlock.deserializeLevel()))).method_10852(class_2561.method_30163((String)"]"));
                player.method_7353((class_2561)text, true);
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                world.method_8396(null, pos, class_3417.field_26980, class_3419.field_15245, 1.0f, 1.0f);
                return class_9062.field_47728;
            }
            if (!world.field_9236) {
                class_1799 capsule = this.getOutput(player);
                class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
                class_2338 spawnPos = pos;
                if (state.method_11654(HALF) == class_2756.field_12609) {
                    spawnPos = pos.method_10074();
                }
                double offsetX = (double)direction.method_10148() * 0.5;
                double offsetZ = (double)direction.method_10165() * 0.5;
                class_1542 capsuleEntity = new class_1542(world, (double)spawnPos.method_10263() + 0.5 + offsetX, (double)spawnPos.method_10264() + 0.5, (double)spawnPos.method_10260() + 0.5 + offsetZ, capsule);
                capsuleEntity.method_18800((double)direction.method_10148() * 0.2, 0.0, (double)direction.method_10165() * 0.2);
                world.method_8649((class_1297)capsuleEntity);
                this.updateLevel(world, pos, state, 0);
                world.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LEVEL);
    }

    public class_1799 getOutput(class_1657 player) {
        if (player == null) {
            System.err.println("Player is null");
            return class_1799.field_8037;
        }
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            System.err.println("Player is not in a server world");
            return class_1799.field_8037;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_8567 parameters = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51874(class_181.field_1226, (Object)player).method_51875(GachaMachine.GACHA_MACHINE_LOOT_CONTEXT);
        class_2960 lootTableId = class_2960.method_60655((String)"gachamachine", (String)"gacha_machine");
        class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableId));
        if (lootTable == null) {
            System.err.println("Loot table not found: " + String.valueOf(lootTableId));
            return class_1799.field_8037;
        }
        ObjectArrayList generatedLoot = lootTable.method_51878(parameters);
        if (generatedLoot == null || generatedLoot.isEmpty()) {
            System.err.println("No loot generated from table: " + String.valueOf(lootTableId));
            return class_1799.field_8037;
        }
        return (class_1799)generatedLoot.getFirst();
    }

    private void updateLevel(class_1937 world, class_2338 pos, class_2680 state, int newLevel) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        class_2338 otherHalfPos = half == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
        class_2680 otherHalfState = world.method_8320(otherHalfPos);
        if (otherHalfState.method_27852((class_2248)this) && otherHalfState.method_11654(HALF) != half) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
            world.method_8652(otherHalfPos, (class_2680)otherHalfState.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
        }
    }

    static {
        LEVEL = LEVEL_X = class_2758.method_11867((String)"level", (int)0, (int)GachaMachineBlock.deserializeLevel());
        FACING = class_2383.field_11177;
        HALF = class_2741.field_12533;
    }
}

