/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.BasketBlock;
import vectorwing.farmersdelight.common.block.entity.Basket;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BasketBlockEntity
extends class_2621
implements Basket {
    private class_2371<class_1799> items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private int transferCooldown = -1;

    public BasketBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntityTypes.BASKET.get(), pos, state);
    }

    protected void method_11014(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11014(compound, registries);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(compound)) {
            class_1262.method_5429((class_2487)compound, this.items, (class_7225.class_7874)registries);
        }
        this.transferCooldown = compound.method_10550("TransferCooldown");
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        if (!this.method_54872(compound)) {
            class_1262.method_5426((class_2487)compound, this.items, (class_7225.class_7874)registries);
        }
        compound.method_10569("TransferCooldown", this.transferCooldown);
    }

    public int method_5439() {
        return this.items.size();
    }

    public class_1799 method_5434(int index, int count) {
        this.method_54873(null);
        return class_1262.method_5430(this.method_11282(), (int)index, (int)count);
    }

    public void method_5447(int index, class_1799 stack) {
        this.method_54873(null);
        this.method_11282().set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    protected class_2561 method_17823() {
        return TextUtils.getTranslation("container.basket", new Object[0]);
    }

    public static boolean pullItems(class_1937 level, Basket basket, int facingIndex) {
        for (class_1542 itementity : BasketBlockEntity.getCaptureItems(level, basket, facingIndex)) {
            if (!BasketBlockEntity.captureItem(basket, itementity)) continue;
            return true;
        }
        return false;
    }

    public static class_1799 putStackInInventoryAllSlots(class_1263 destination, class_1799 stack) {
        int i = destination.method_5439();
        for (int j = 0; j < i && !stack.method_7960(); ++j) {
            stack = BasketBlockEntity.insertStack(destination, stack, j);
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(class_1263 inventoryIn, class_1799 stack, int index, @Nullable class_2350 side) {
        if (!inventoryIn.method_5437(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof class_1278) || ((class_1278)inventoryIn).method_5492(index, stack, side);
    }

    private static boolean canCombine(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7947() <= stack1.method_7914() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    private static class_1799 insertStack(class_1263 destination, class_1799 stack, int index) {
        class_1799 itemstack = destination.method_5438(index);
        if (BasketBlockEntity.canInsertItemInSlot(destination, stack, index, null)) {
            boolean flag = false;
            boolean isDestinationEmpty = destination.method_5442();
            if (itemstack.method_7960()) {
                destination.method_5447(index, stack);
                stack = class_1799.field_8037;
                flag = true;
            } else if (BasketBlockEntity.canCombine(itemstack, stack)) {
                int i = stack.method_7914() - itemstack.method_7947();
                int j = Math.min(stack.method_7947(), i);
                stack.method_7934(j);
                itemstack.method_7933(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                BasketBlockEntity firstBasket;
                if (isDestinationEmpty && destination instanceof BasketBlockEntity && !(firstBasket = (BasketBlockEntity)destination).mayTransfer()) {
                    int k = 0;
                    firstBasket.setTransferCooldown(8 - k);
                }
                destination.method_5431();
            }
        }
        return stack;
    }

    public static boolean captureItem(class_1263 inventory, class_1542 itemEntity) {
        boolean flag = false;
        class_1799 entityItemStack = itemEntity.method_6983().method_7972();
        class_1799 remainderStack = BasketBlockEntity.putStackInInventoryAllSlots(inventory, entityItemStack);
        if (remainderStack.method_7960()) {
            flag = true;
            itemEntity.method_31472();
        } else {
            itemEntity.method_6979(remainderStack);
        }
        return flag;
    }

    public static List<class_1542> getCaptureItems(class_1937 level, Basket basket, int facingIndex) {
        return basket.getFacingCollectionArea(facingIndex).method_1090().stream().flatMap(aabb -> level.method_8390(class_1542.class, aabb.method_989(basket.getLevelX() - 0.5, basket.getLevelY() - 0.5, basket.getLevelZ() - 0.5), class_1301.field_6154).stream()).collect(Collectors.toList());
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> itemsIn) {
        this.items = itemsIn;
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return class_1707.method_19245((int)id, (class_1661)player, (class_1263)this);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    private void updateHopper(Supplier<Boolean> supplier) {
        if (this.field_11863 != null && !this.field_11863.field_9236 && !this.isOnTransferCooldown() && ((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12515)).booleanValue()) {
            boolean flag = false;
            if (!this.isFull()) {
                flag = supplier.get();
            }
            if (flag) {
                this.setTransferCooldown(8);
                this.method_5431();
            }
        }
    }

    private boolean isFull() {
        for (class_1799 itemstack : this.items) {
            if (!itemstack.method_7960() && itemstack.method_7947() == itemstack.method_7914()) continue;
            return false;
        }
        return true;
    }

    public void onEntityCollision(class_1297 entity) {
        if (entity instanceof class_1542) {
            class_2338 blockpos = this.method_11016();
            int facing = ((class_2350)this.method_11010().method_11654((class_2769)BasketBlock.FACING)).method_10146();
            if (class_259.method_1074((class_265)class_259.method_1078((class_238)entity.method_5829().method_989((double)(-blockpos.method_10263()), (double)(-blockpos.method_10264()), (double)(-blockpos.method_10260()))), (class_265)this.getFacingCollectionArea(facing), (class_247)class_247.field_16896)) {
                this.updateHopper(() -> BasketBlockEntity.captureItem(this, (class_1542)entity));
            }
        }
    }

    @Override
    public double getLevelX() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    public static void pushItemsTick(class_1937 level, class_2338 pos, class_2680 state, BasketBlockEntity blockEntity) {
        --blockEntity.transferCooldown;
        if (!blockEntity.isOnTransferCooldown()) {
            blockEntity.setTransferCooldown(0);
            int facing = ((class_2350)state.method_11654((class_2769)BasketBlock.FACING)).method_10146();
            blockEntity.updateHopper(() -> BasketBlockEntity.pullItems(level, blockEntity, facing));
        }
    }
}

