/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CuttingBoardBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandlerContainer inventory = this.createHandler();
    private final class_1863.class_7266<CuttingBoardRecipeInput, CuttingBoardRecipe> quickCheck = class_1863.method_42302(ModRecipeTypes.CUTTING.get());
    private class_2960 lastRecipeID;
    private boolean isItemCarvingBoard = false;

    public CuttingBoardBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.CUTTING_BOARD.get(), pos, state);
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(CuttingBoardBlockEntity::getStorage, ModBlockEntityTypes.CUTTING_BOARD.get());
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        return this.getInventory();
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11014(compound, registries);
        this.isItemCarvingBoard = compound.method_10577("IsItemCarved");
        this.inventory.deserializeNBT(registries, compound.method_10562("Inventory"));
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT(registries));
        compound.method_10556("IsItemCarved", this.isItemCarvingBoard);
    }

    public boolean processStoredItemUsingTool(class_1799 toolStack, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.isItemCarvingBoard) {
            return false;
        }
        Optional<class_8786<CuttingBoardRecipe>> matchingRecipe = this.getMatchingRecipe(toolStack, player);
        matchingRecipe.ifPresent(recipe -> {
            List<class_1799> results = ((CuttingBoardRecipe)recipe.comp_1933()).rollResults(this.field_11863.field_9229, class_1890.method_8225((class_6880)this.field_11863.method_30349().method_30530(class_7924.field_41265).method_40290(class_1893.field_9130), (class_1799)toolStack));
            for (class_1799 resultStack : results) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)CuttingBoardBlock.FACING)).method_10160();
                ItemUtils.spawnItemEntity(this.field_11863, resultStack.method_7972(), (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, (float)direction.method_10148() * 0.2f, 0.0, (float)direction.method_10165() * 0.2f);
            }
            if (!this.field_11863.field_9236) {
                toolStack.method_7956(1, (class_3218)this.field_11863, (class_3222)player, item -> {});
            }
            this.playProcessingSound(((CuttingBoardRecipe)recipe.comp_1933()).getSoundEvent().orElse(null), toolStack, this.getStoredItem());
            this.removeItem();
            if (player instanceof class_3222) {
                ModAdvancements.USE_CUTTING_BOARD.get().trigger((class_3222)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<class_8786<CuttingBoardRecipe>> getMatchingRecipe(class_1799 toolStack, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        Optional recipe = this.quickCheck.method_42303((class_9695)new CuttingBoardRecipeInput(this.getStoredItem(), toolStack), this.field_11863);
        if (recipe.isPresent()) {
            if (((CuttingBoardRecipe)((class_8786)recipe.get()).comp_1933()).getTool().method_8093(toolStack)) {
                return recipe;
            }
            if (player != null) {
                player.method_7353((class_2561)TextUtils.getTranslation("block.cutting_board.invalid_tool", new Object[0]), true);
            }
        } else if (player != null) {
            player.method_7353((class_2561)TextUtils.getTranslation("block.cutting_board.invalid_item", new Object[0]), true);
        }
        return Optional.empty();
    }

    public void playProcessingSound(@Nullable class_3414 sound, class_1799 tool, class_1799 boardItem) {
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
            this.playSound(class_3417.field_14975, 1.0f, 1.0f);
        } else if (tool.method_31573(CommonTags.TOOLS_KNIFE)) {
            this.playSound(ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else {
            class_1792 class_17922 = boardItem.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2248 block = blockItem.method_7711();
                class_2498 soundType = block.method_9564().method_26231();
                this.playSound(soundType.method_10595(), 1.0f, 0.8f);
            } else {
                this.playSound(class_3417.field_15215, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
        }
    }

    public boolean addItem(class_1799 itemStack) {
        if (this.isEmpty() && !itemStack.method_7960()) {
            this.inventory.setStackInSlot(0, itemStack.method_7971(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(class_1799 tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            class_1799 item = this.getStoredItem().method_7971(1);
            this.inventoryChanged();
            return item;
        }
        return class_1799.field_8037;
    }

    public ItemStackHandlerContainer getInventory() {
        return this.inventory;
    }

    public class_1799 getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).method_7960();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public void method_11012() {
        super.method_11012();
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                CuttingBoardBlockEntity.this.inventoryChanged();
            }
        };
    }
}

