/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.command;

import com.cobblemon.mod.common.api.text.TextKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.command.arguments.BigIntegerArgumentType;
import fr.harmex.cobbledollars.common.config.BankConfig;
import fr.harmex.cobbledollars.common.config.CommonConfig;
import fr.harmex.cobbledollars.common.config.ShopConfig;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopConfigPacket;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import java.math.BigInteger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J-\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lfr/harmex/cobbledollars/common/command/CobbleDollarsCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "sourceStack", "Lnet/minecraft/class_3222;", "target", "Ljava/math/BigInteger;", "amount", "", "pay", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_3222;Ljava/math/BigInteger;)I", "Lnet/minecraft/class_1657;", "query", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_1657;)I", "", "targets", "give", "(Lnet/minecraft/class_2168;Ljava/util/Collection;Ljava/math/BigInteger;)I", "remove", "set", "reload", "(Lnet/minecraft/class_2168;)I", "common"})
public final class CobbleDollarsCommand {
    @NotNull
    public static final CobbleDollarsCommand INSTANCE = new CobbleDollarsCommand();

    private CobbleDollarsCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralCommandNode mainNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cobbledollars").then(class_2170.method_9247((String)"pay").then(class_2170.method_9244((String)"target", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$0))))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"target", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(CobbleDollarsCommand::register$lambda$1)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"give").requires(CobbleDollarsCommand::register$lambda$2)).then(class_2170.method_9244((String)"targets", (ArgumentType)((ArgumentType)class_2186.method_9308())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$3))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(CobbleDollarsCommand::register$lambda$4)).then(class_2170.method_9244((String)"targets", (ArgumentType)((ArgumentType)class_2186.method_9308())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$5))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(CobbleDollarsCommand::register$lambda$6)).then(class_2170.method_9244((String)"targets", (ArgumentType)((ArgumentType)class_2186.method_9308())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(0)).executes(CobbleDollarsCommand::register$lambda$7))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(CobbleDollarsCommand::register$lambda$8)).executes(CobbleDollarsCommand::register$lambda$9)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"cd").redirect((CommandNode)mainNode));
    }

    private final int pay(class_2168 sourceStack, class_3222 target, BigInteger amount) {
        class_3222 class_32222 = sourceStack.method_9207();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayerOrException(...)");
        if (amount.compareTo(PlayerExtensionKt.getCobbleDollars((class_1657)class_32222)) > 0) {
            sourceStack.method_9213((class_2561)MiscUtilsKt.cobbleDollarsCommand("pay.fail", new Object[0]));
            return 0;
        }
        class_3222 class_32223 = sourceStack.method_9207();
        Intrinsics.checkNotNullExpressionValue((Object)class_32223, (String)"getPlayerOrException(...)");
        class_1657 class_16572 = (class_1657)class_32223;
        BigInteger bigInteger = amount.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
        PlayerExtensionKt.addCobbleDollars(class_16572, bigInteger);
        PlayerExtensionKt.addCobbleDollars((class_1657)target, amount);
        Object[] objectArray = new Object[2];
        class_3222 class_32224 = sourceStack.method_44023();
        Intrinsics.checkNotNull((Object)class_32224);
        Intrinsics.checkNotNull((Object)class_32224.method_5476());
        objectArray[1] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default(amount, false, 1, null));
        target.method_43496((class_2561)MiscUtilsKt.cobbleDollarsCommand("pay.receive", objectArray));
        sourceStack.method_9226(() -> CobbleDollarsCommand.pay$lambda$10(amount, target), true);
        return amount.intValue();
    }

    private final int query(class_2168 sourceStack, class_1657 target) {
        BigInteger cobbleDollars = PlayerExtensionKt.getCobbleDollars(target);
        sourceStack.method_9226(() -> CobbleDollarsCommand.query$lambda$11(target, cobbleDollars), false);
        return cobbleDollars.intValue();
    }

    private final int give(class_2168 sourceStack, Collection<? extends class_3222> targets, BigInteger amount) {
        for (class_3222 class_32222 : targets) {
            PlayerExtensionKt.addCobbleDollars((class_1657)class_32222, amount);
        }
        if (targets.size() == 1) {
            sourceStack.method_9226(() -> CobbleDollarsCommand.give$lambda$12(amount, targets), true);
        } else {
            sourceStack.method_9226(() -> CobbleDollarsCommand.give$lambda$13(amount, targets), true);
        }
        return targets.size();
    }

    private final int remove(class_2168 sourceStack, Collection<? extends class_3222> targets, BigInteger amount) {
        for (class_3222 class_32222 : targets) {
            class_1657 class_16572 = (class_1657)class_32222;
            BigInteger bigInteger = amount.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
            PlayerExtensionKt.addCobbleDollars(class_16572, bigInteger);
        }
        if (targets.size() == 1) {
            sourceStack.method_9226(() -> CobbleDollarsCommand.remove$lambda$14(amount, targets), true);
        } else {
            sourceStack.method_9226(() -> CobbleDollarsCommand.remove$lambda$15(amount, targets), true);
        }
        return targets.size();
    }

    private final int set(class_2168 sourceStack, Collection<? extends class_3222> targets, BigInteger amount) {
        for (class_3222 class_32222 : targets) {
            PlayerExtensionKt.setCobbleDollars((class_1657)class_32222, amount);
        }
        if (targets.size() == 1) {
            sourceStack.method_9226(() -> CobbleDollarsCommand.set$lambda$16(amount, targets), true);
        } else {
            sourceStack.method_9226(() -> CobbleDollarsCommand.set$lambda$17(amount, targets), true);
        }
        return targets.size();
    }

    private final int reload(class_2168 sourceStack) {
        CommonConfig.Companion.load();
        ShopConfig.Companion.load();
        BankConfig.Companion.load();
        CobbleDollarsNetwork.INSTANCE.sendToAllPlayers(new SyncShopConfigPacket(CobbleDollars.INSTANCE.getShopConfig().getDefaultShop(), CobbleDollars.INSTANCE.getBankConfig().getBank()));
        sourceStack.method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)"Reloaded CobbleDollars config!"), false);
        return 1;
    }

    private static final int register$lambda$0(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.pay(class_21682, class_32222, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$1(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.query(class_21682, (class_1657)class_32222);
    }

    private static final boolean register$lambda$2(class_2168 it) {
        return it.method_9259(2);
    }

    private static final int register$lambda$3(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Collection collection = class_2186.method_9312((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.give(class_21682, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final boolean register$lambda$4(class_2168 it) {
        return it.method_9259(2);
    }

    private static final int register$lambda$5(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Collection collection = class_2186.method_9312((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.remove(class_21682, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final boolean register$lambda$6(class_2168 it) {
        return it.method_9259(2);
    }

    private static final int register$lambda$7(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Collection collection = class_2186.method_9312((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.set(class_21682, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final boolean register$lambda$8(class_2168 it) {
        return it.method_9259(2);
    }

    private static final int register$lambda$9(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.reload((class_2168)object);
    }

    private static final class_2561 pay$lambda$10(BigInteger $amount, class_3222 $target) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)$target.method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("pay.success", objectArray);
    }

    private static final class_2561 query$lambda$11(class_1657 $target, BigInteger $cobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$cobbleDollars, (String)"$cobbleDollars");
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)$target.method_5476());
        objectArray[1] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($cobbleDollars, false, 1, null));
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("query.success", objectArray);
    }

    private static final class_2561 give$lambda$12(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((class_3222)$targets.iterator().next()).method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("give.success.single", objectArray);
    }

    private static final class_2561 give$lambda$13(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("give.success.multiple", objectArray);
    }

    private static final class_2561 remove$lambda$14(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((class_3222)$targets.iterator().next()).method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("remove.success.single", objectArray);
    }

    private static final class_2561 remove$lambda$15(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.red((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("remove.success.multiple", objectArray);
    }

    private static final class_2561 set$lambda$16(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((class_3222)$targets.iterator().next()).method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("set.success.single", objectArray);
    }

    private static final class_2561 set$lambda$17(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("set.success.multiple", objectArray);
    }
}

