/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.utils.extensions;

import com.cobblemon.mod.common.api.text.TextKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncBankPacket;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopPacket;
import fr.harmex.cobbledollars.common.utils.CobbleDollarsPlayer;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import fr.harmex.cobbledollars.common.world.entity.ClientSideCobbleMerchant;
import fr.harmex.cobbledollars.common.world.inventory.BankMenu;
import fr.harmex.cobbledollars.common.world.inventory.ShopMenu;
import fr.harmex.cobbledollars.common.world.item.trading.ICobbleMerchant;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\b\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\u0007\u001a\u0019\u0010\n\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0019\u0010\r\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\f\u001a\u00020\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001b\u0010\u0010\u001a\u00020\t*\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0010\u0010\u000b\u001a\u0019\u0010\u0014\u001a\u00020\u0013*\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a'\u0010\u0019\u001a\u00020\u0005*\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u001d\u0010\u001b\u001a\u00020\u0005*\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a!\u0010 \u001a\u00020\t*\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b \u0010!\u001a\u001b\u0010\"\u001a\u0004\u0018\u00010\u0001*\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\"\u0010#\u001a\u0019\u0010$\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b$\u0010%\"\u001c\u0010(\u001a\n '*\u0004\u0018\u00010&0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lnet/minecraft/class_1657;", "Ljava/math/BigInteger;", "getCobbleDollars", "(Lnet/minecraft/class_1657;)Ljava/math/BigInteger;", "amount", "", "setCobbleDollars", "(Lnet/minecraft/class_1657;Ljava/math/BigInteger;)V", "addCobbleDollars", "", "subCobbleDollars", "(Lnet/minecraft/class_1657;Ljava/math/BigInteger;)Z", "unitPrice", "getMaxAmountPurchasable", "(Lnet/minecraft/class_1657;Ljava/math/BigInteger;)Ljava/math/BigInteger;", "price", "canBuy", "Lnet/minecraft/class_1799;", "itemStack", "", "getMaxAmountObtainable", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1799;)I", "Lfr/harmex/cobbledollars/common/world/item/trading/ICobbleMerchant;", "cobbleMerchant", "isEditMode", "openShop", "(Lnet/minecraft/class_1657;Lfr/harmex/cobbledollars/common/world/item/trading/ICobbleMerchant;Z)V", "openBank", "(Lnet/minecraft/class_1657;Lfr/harmex/cobbledollars/common/world/item/trading/ICobbleMerchant;)V", "Ljava/util/UUID;", "Lnet/minecraft/server/MinecraftServer;", "server", "addOfflineCobbleDollars", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;Ljava/math/BigInteger;)Z", "getOfflineCobbleDollars", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;)Ljava/math/BigInteger;", "earnOfflineCobbleDollars", "(Lnet/minecraft/class_1657;Lnet/minecraft/server/MinecraftServer;)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "common"})
public final class PlayerExtensionKt {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @NotNull
    public static final BigInteger getCobbleDollars(@NotNull class_1657 $this$getCobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$this$getCobbleDollars, (String)"<this>");
        return ((CobbleDollarsPlayer)$this$getCobbleDollars).cobbleDollars$getCobbleDollars();
    }

    public static final void setCobbleDollars(@NotNull class_1657 $this$setCobbleDollars, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$setCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        ((CobbleDollarsPlayer)$this$setCobbleDollars).cobbleDollars$setCobbleDollars(amount);
    }

    public static final void addCobbleDollars(@NotNull class_1657 $this$addCobbleDollars, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        ((CobbleDollarsPlayer)$this$addCobbleDollars).cobbleDollars$addCobbleDollars(amount);
    }

    public static final boolean subCobbleDollars(@NotNull class_1657 $this$subCobbleDollars, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$subCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return ((CobbleDollarsPlayer)$this$subCobbleDollars).cobbleDollars$subCobbleDollars(amount);
    }

    @NotNull
    public static final BigInteger getMaxAmountPurchasable(@NotNull class_1657 $this$getMaxAmountPurchasable, @NotNull BigInteger unitPrice) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$getMaxAmountPurchasable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unitPrice, (String)"unitPrice");
        if (Intrinsics.areEqual((Object)unitPrice, (Object)BigInteger.ZERO)) {
            bigInteger = new BigInteger("9999");
        } else {
            BigInteger bigInteger2 = PlayerExtensionKt.getCobbleDollars($this$getMaxAmountPurchasable).divide(unitPrice);
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"divide(...)");
        }
        return bigInteger;
    }

    public static final boolean canBuy(@NotNull class_1657 $this$canBuy, @Nullable BigInteger price) {
        Intrinsics.checkNotNullParameter((Object)$this$canBuy, (String)"<this>");
        return price != null && PlayerExtensionKt.getCobbleDollars($this$canBuy).compareTo(price) >= 0;
    }

    public static final int getMaxAmountObtainable(@NotNull class_1657 $this$getMaxAmountObtainable, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxAmountObtainable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int spaceAvailable = 0;
        Iterator iterator = $this$getMaxAmountObtainable.method_31548().field_7547.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            class_1799 slotStack = (class_1799)iterator2.next();
            if (Intrinsics.areEqual((Object)slotStack, (Object)class_1799.field_8037)) {
                spaceAvailable += itemStack.method_7914();
            }
            if (!Intrinsics.areEqual((Object)slotStack.method_7909(), (Object)itemStack.method_7909()) || !Intrinsics.areEqual((Object)slotStack.method_57353(), (Object)itemStack.method_57353())) continue;
            spaceAvailable += itemStack.method_7914() - slotStack.method_7947();
        }
        return spaceAvailable;
    }

    @JvmOverloads
    public static final void openShop(@NotNull class_1657 $this$openShop, @NotNull ICobbleMerchant cobbleMerchant, boolean isEditMode) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cobbleMerchant, (String)"cobbleMerchant");
        $this$openShop.method_17355((class_3908)new class_747((arg_0, arg_1, arg_2) -> PlayerExtensionKt.openShop$lambda$0(cobbleMerchant, arg_0, arg_1, arg_2), (class_2561)MiscUtilsKt.cobbleDollarsScreen("shop"))).ifPresent(arg_0 -> PlayerExtensionKt.openShop$lambda$1($this$openShop, cobbleMerchant, isEditMode, arg_0));
    }

    public static /* synthetic */ void openShop$default(class_1657 class_16572, ICobbleMerchant iCobbleMerchant, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            iCobbleMerchant = new ClientSideCobbleMerchant();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        PlayerExtensionKt.openShop(class_16572, iCobbleMerchant, bl);
    }

    @JvmOverloads
    public static final void openBank(@NotNull class_1657 $this$openBank, @NotNull ICobbleMerchant cobbleMerchant) {
        Intrinsics.checkNotNullParameter((Object)$this$openBank, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cobbleMerchant, (String)"cobbleMerchant");
        $this$openBank.method_17355((class_3908)new class_747((arg_0, arg_1, arg_2) -> PlayerExtensionKt.openBank$lambda$2(cobbleMerchant, arg_0, arg_1, arg_2), (class_2561)MiscUtilsKt.cobbleDollarsScreen("bank"))).ifPresent(arg_0 -> PlayerExtensionKt.openBank$lambda$3($this$openBank, cobbleMerchant, arg_0));
    }

    public static /* synthetic */ void openBank$default(class_1657 class_16572, ICobbleMerchant iCobbleMerchant, int n, Object object) {
        if ((n & 1) != 0) {
            iCobbleMerchant = new ClientSideCobbleMerchant();
        }
        PlayerExtensionKt.openBank(class_16572, iCobbleMerchant);
    }

    public static final boolean addOfflineCobbleDollars(@NotNull UUID $this$addOfflineCobbleDollars, @NotNull MinecraftServer server, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addOfflineCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        try {
            BigInteger bigInteger;
            File cobbleDollarsStoreRoot;
            block5: {
                block4: {
                    cobbleDollarsStoreRoot = server.method_27050(class_5218.field_24188).resolve("cobbledollars/" + $this$addOfflineCobbleDollars + ".json").toFile();
                    cobbleDollarsStoreRoot.getParentFile().mkdirs();
                    bigInteger = PlayerExtensionKt.getOfflineCobbleDollars($this$addOfflineCobbleDollars, server);
                    if (bigInteger == null) break block4;
                    BigInteger bigInteger2 = bigInteger.add(amount);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    bigInteger = bigInteger2;
                    if (bigInteger2 != null) break block5;
                }
                bigInteger = amount;
            }
            BigInteger totalAmount = bigInteger;
            FileWriter writer = new FileWriter(cobbleDollarsStoreRoot);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("offlineEarnings", (Number)totalAmount);
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static final BigInteger getOfflineCobbleDollars(@NotNull UUID $this$getOfflineCobbleDollars, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)$this$getOfflineCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            File cobbleDollarsStoreRoot = server.method_27050(class_5218.field_24188).resolve("cobbledollars/" + $this$getOfflineCobbleDollars + ".json").toFile();
            if (cobbleDollarsStoreRoot.exists()) {
                FileReader reader = new FileReader(cobbleDollarsStoreRoot);
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                return jsonObject.get("offlineEarnings").getAsBigInteger();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final void earnOfflineCobbleDollars(@NotNull class_1657 $this$earnOfflineCobbleDollars, @NotNull MinecraftServer server) {
        block1: {
            BigInteger offlineEarnings;
            Intrinsics.checkNotNullParameter((Object)$this$earnOfflineCobbleDollars, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            File cobbleDollarsStoreRoot = server.method_27050(class_5218.field_24188).resolve("cobbledollars/" + $this$earnOfflineCobbleDollars.method_5667() + ".json").toFile();
            if (!cobbleDollarsStoreRoot.exists()) break block1;
            UUID uUID = $this$earnOfflineCobbleDollars.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            BigInteger bigInteger = offlineEarnings = PlayerExtensionKt.getOfflineCobbleDollars(uUID, server);
            if (bigInteger != null) {
                BigInteger offlineEarnings2 = bigInteger;
                boolean bl = false;
                PlayerExtensionKt.addCobbleDollars($this$earnOfflineCobbleDollars, offlineEarnings2);
                Object[] objectArray = new Object[]{TextKt.green((class_5250)BigIntegerExtensionsKt.format$default(offlineEarnings2, false, 1, null))};
                $this$earnOfflineCobbleDollars.method_43496((class_2561)MiscUtilsKt.cobbleDollarsLang("chat", "offline_earnings", objectArray));
                cobbleDollarsStoreRoot.delete();
            }
        }
    }

    @JvmOverloads
    public static final void openShop(@NotNull class_1657 $this$openShop, @NotNull ICobbleMerchant cobbleMerchant) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cobbleMerchant, (String)"cobbleMerchant");
        PlayerExtensionKt.openShop$default($this$openShop, cobbleMerchant, false, 2, null);
    }

    @JvmOverloads
    public static final void openShop(@NotNull class_1657 $this$openShop) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        PlayerExtensionKt.openShop$default($this$openShop, null, false, 3, null);
    }

    @JvmOverloads
    public static final void openBank(@NotNull class_1657 $this$openBank) {
        Intrinsics.checkNotNullParameter((Object)$this$openBank, (String)"<this>");
        PlayerExtensionKt.openBank$default($this$openBank, null, 1, null);
    }

    private static final class_1703 openShop$lambda$0(ICobbleMerchant $cobbleMerchant, int containerId, class_1661 playerInventory, class_1657 class_16572) {
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        Intrinsics.checkNotNull((Object)playerInventory);
        return new ShopMenu(containerId, playerInventory, null, $cobbleMerchant, 4, null);
    }

    private static final void openShop$lambda$1(class_1657 $this_openShop, ICobbleMerchant $cobbleMerchant, boolean $isEditMode, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_openShop, (String)"$this_openShop");
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        CobbleDollarsNetwork.INSTANCE.sendPacket((class_3222)$this_openShop, new SyncShopPacket(it, $cobbleMerchant.getShop(), $cobbleMerchant.getMerchantUUID(), $isEditMode));
    }

    private static final class_1703 openBank$lambda$2(ICobbleMerchant $cobbleMerchant, int containerId, class_1661 playerInventory, class_1657 class_16572) {
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        Intrinsics.checkNotNull((Object)playerInventory);
        return new BankMenu(containerId, playerInventory, null, $cobbleMerchant, 4, null);
    }

    private static final void openBank$lambda$3(class_1657 $this_openBank, ICobbleMerchant $cobbleMerchant, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_openBank, (String)"$this_openBank");
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        CobbleDollarsNetwork.INSTANCE.sendPacket((class_3222)$this_openBank, new SyncBankPacket(it, $cobbleMerchant.getMerchantUUID()));
    }
}

