/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.ui.core.CursorStyle;
import java.util.EnumMap;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class CursorAdapter {
    protected static final CursorStyle[] ACTIVE_STYLES = new CursorStyle[]{CursorStyle.POINTER, CursorStyle.TEXT, CursorStyle.HAND, CursorStyle.CROSSHAIR, CursorStyle.MOVE, CursorStyle.HORIZONTAL_RESIZE, CursorStyle.VERTICAL_RESIZE, CursorStyle.NWSE_RESIZE, CursorStyle.NESW_RESIZE, CursorStyle.NOT_ALLOWED};
    protected final EnumMap<CursorStyle, Long> cursors = new EnumMap(CursorStyle.class);
    protected final long windowHandle;
    protected CursorStyle lastCursorStyle = CursorStyle.POINTER;
    protected boolean disposed = false;

    protected CursorAdapter(long windowHandle) {
        this.windowHandle = windowHandle;
        for (CursorStyle style : ACTIVE_STYLES) {
            long pointer = GLFW.glfwCreateStandardCursor((int)style.glfw);
            if (pointer == 0L) continue;
            this.cursors.put(style, pointer);
        }
    }

    public static CursorAdapter ofClientWindow() {
        return new CursorAdapter(class_310.method_1551().method_22683().method_4490());
    }

    public static CursorAdapter ofWindow(class_1041 window) {
        return new CursorAdapter(window.method_4490());
    }

    public static CursorAdapter ofWindow(long windowHandle) {
        return new CursorAdapter(windowHandle);
    }

    public void applyStyle(CursorStyle style) {
        if (this.disposed || this.lastCursorStyle == style) {
            return;
        }
        if (style == CursorStyle.NONE) {
            GLFW.glfwSetCursor((long)this.windowHandle, (long)0L);
        } else {
            GLFW.glfwSetCursor((long)this.windowHandle, (long)this.cursors.getOrDefault((Object)style, 0L));
        }
        this.lastCursorStyle = style;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.cursors.values().forEach(GLFW::glfwDestroyCursor);
        this.disposed = true;
    }
}

