/*
 * Decompiled with CFR 0.152.
 */
package com.luismaia.config;

import com.google.gson.Gson;
import com.luismaia.CobblemonWikiGui;
import com.luismaia.config.CobblemonWikiGuiConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0019\u0010\b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J\u0019\u0010\u000b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\f\u0010\tJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0019J\r\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001c\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001c\u0010#\u001a\n \"*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010!R\u001c\u0010%\u001a\n \"*\u0004\u0018\u00010$0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R$\u0010(\u001a\u0004\u0018\u00010'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/luismaia/config/ConfigManager;", "", "<init>", "()V", "", "initConfig", "Lnet/minecraft/class_3222;", "player", "createFileConfig", "(Lnet/minecraft/class_3222;)V", "loadConfig", "createInitialDataConfigJson", "reload", "Ljava/nio/file/Path;", "getRootPath", "()Ljava/nio/file/Path;", "", "json", "", "validateConfigJson", "(Ljava/lang/String;)Z", "Lcom/luismaia/config/ConfigManager$ConfigFileStatus;", "configFileStatus", "()Lcom/luismaia/config/ConfigManager$ConfigFileStatus;", "configFileExistsAndNotEmpty", "()Z", "configFileExists", "configFileNotEmpty", "isEnablePermissionNodes", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "rootPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configFilepathName", "Ljava/io/File;", "configFile", "Ljava/io/File;", "Lcom/luismaia/config/CobblemonWikiGuiConfig;", "config", "Lcom/luismaia/config/CobblemonWikiGuiConfig;", "getConfig", "()Lcom/luismaia/config/CobblemonWikiGuiConfig;", "setConfig", "(Lcom/luismaia/config/CobblemonWikiGuiConfig;)V", "ConfigFileStatus", "Cobblemon-Wiki-Gui"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\ncom/luismaia/config/ConfigManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,203:1\n147#2:204\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\ncom/luismaia/config/ConfigManager\n*L\n153#1:204\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static final Logger logger = CobblemonWikiGui.INSTANCE.getLOGGER();
    @NotNull
    private static final Path rootPath;
    private static final Path configFilepathName;
    private static final File configFile;
    @Nullable
    private static CobblemonWikiGuiConfig config;

    private ConfigManager() {
    }

    @Nullable
    public final CobblemonWikiGuiConfig getConfig() {
        return config;
    }

    public final void setConfig(@Nullable CobblemonWikiGuiConfig cobblemonWikiGuiConfig) {
        config = cobblemonWikiGuiConfig;
    }

    private final void initConfig() {
        Path parentDirectory = configFilepathName.getParent();
        if (parentDirectory != null && Files.notExists(parentDirectory, new LinkOption[0])) {
            Files.createDirectories(parentDirectory, new FileAttribute[0]);
        }
        this.createFileConfig(null);
    }

    private final void createFileConfig(class_3222 player) {
        try {
            if (Files.notExists(configFilepathName, new LinkOption[0])) {
                logger.error("Config file does not exist.");
                class_3222 class_32222 = player;
                if (class_32222 != null) {
                    CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
                    class_32222.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Creating a new file config.json").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))));
                }
                Files.createFile(configFilepathName, new FileAttribute[0]);
                logger.info("File config.json created!");
                class_3222 class_32223 = player;
                if (class_32223 != null) {
                    CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
                    class_32223.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"File config.json created!")));
                }
            } else {
                logger.info("File config.json already exists!");
                class_3222 class_32224 = player;
                if (class_32224 != null) {
                    CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
                    class_32224.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"File config.json already exists!")));
                }
            }
        }
        catch (Exception e) {
            logger.error("Houve um problema! " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfig() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.configFileStatus().ordinal()]) {
            case 1: {
                this.createFileConfig(null);
                this.createInitialDataConfigJson(null);
                break;
            }
            case 2: {
                logger.info("Config file is empty.");
                this.createInitialDataConfigJson(null);
                break;
            }
            case 3: {
                logger.info("Config file is invalid.");
                logger.info("Format the file \"config.json\" correctly");
                break;
            }
            case 4: {
                logger.info("Config file is valid.");
                logger.info("Loading config.json");
                Gson gson = new Gson();
                Closeable closeable = new FileReader(configFile);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl = false;
                    config = (CobblemonWikiGuiConfig)gson.fromJson((Reader)reader, CobblemonWikiGuiConfig.class);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createInitialDataConfigJson(class_3222 player) {
        logger.info("Creating default data for config.json");
        class_3222 class_32222 = player;
        if (class_32222 != null) {
            CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
            class_32222.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Creating default data for config.json")));
        }
        try {
            configFile.getParentFile().mkdirs();
            Gson gson = new Gson();
            Closeable closeable = new FileWriter(configFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                gson.toJson((Object)new CobblemonWikiGuiConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 0xFFFFFFF, null), (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            logger.info("Initial default data for config.json created!");
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload(@Nullable class_3222 player) {
        class_3222 class_32222 = player;
        if (class_32222 != null) {
            CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
            class_32222.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Reloading config.json...")));
        }
        logger.info("Reloading config.json...");
        switch (WhenMappings.$EnumSwitchMapping$0[this.configFileStatus().ordinal()]) {
            case 1: {
                this.createFileConfig(player);
                this.createInitialDataConfigJson(player);
                break;
            }
            case 2: {
                logger.info("Config file is empty.");
                this.createInitialDataConfigJson(player);
                break;
            }
            case 3: {
                logger.info("Config file is invalid.");
                logger.info("Format the file \"config.json\" correctly");
                class_3222 class_32223 = player;
                if (class_32223 != null) {
                    CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
                    class_32223.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Config file is invalid. Format the file \"config.json\" correctly")).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
                }
                break;
            }
            case 4: {
                logger.info("Config file is valid.");
                logger.info("Re-Loading config.json");
                Gson gson = new Gson();
                Closeable closeable = new FileReader(configFile);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl = false;
                    config = (CobblemonWikiGuiConfig)gson.fromJson((Reader)reader, CobblemonWikiGuiConfig.class);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                class_3222 class_32224 = player;
                if (class_32224 != null) {
                    CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
                    class_32224.method_43496((class_2561)class_2561.method_43470((String)(cobblemonWikiGuiConfig != null ? cobblemonWikiGuiConfig.getChatTitle() : null)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Success reload config.json")));
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final Path getRootPath() {
        return rootPath;
    }

    private final boolean validateConfigJson(String json) {
        boolean bl;
        try {
            Json jsonParser;
            Json this_$iv = jsonParser = JsonKt.Json$default(null, ConfigManager::validateConfigJson$lambda$3, (int)1, null);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this_$iv.decodeFromString((DeserializationStrategy)CobblemonWikiGuiConfig.Companion.serializer(), json);
            bl = true;
        }
        catch (SerializationException e) {
            logger.error("Serialization exception! " + e);
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private final ConfigFileStatus configFileStatus() {
        if (!this.configFileExists()) {
            return ConfigFileStatus.NOT_EXIST;
        }
        if (!this.configFileNotEmpty()) {
            return ConfigFileStatus.EMPTY;
        }
        try {
            File file = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configFile");
            if (!this.validateConfigJson(FilesKt.readText$default((File)file, null, (int)1, null))) {
                return ConfigFileStatus.INVALID;
            }
        }
        catch (SerializationException e) {
            return ConfigFileStatus.INVALID;
        }
        catch (IllegalArgumentException e) {
            return ConfigFileStatus.INVALID;
        }
        return ConfigFileStatus.VALID;
    }

    private final boolean configFileExistsAndNotEmpty() {
        return this.configFileExists() && this.configFileNotEmpty();
    }

    private final boolean configFileExists() {
        return configFile.exists() && configFile.length() != 0L;
    }

    private final boolean configFileNotEmpty() {
        return configFile.length() != 0L;
    }

    public final boolean isEnablePermissionNodes() {
        CobblemonWikiGuiConfig cobblemonWikiGuiConfig = config;
        if (cobblemonWikiGuiConfig == null) {
            return false;
        }
        return cobblemonWikiGuiConfig.isEnablePermissionNodes();
    }

    private static final Unit validateConfigJson$lambda$3(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    static {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("cobblemon-wiki-gui/");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        rootPath = path;
        configFilepathName = rootPath.resolve("config.json");
        configFile = configFilepathName.toFile();
        logger.info("============================================");
        logger.info("Initialize Config module");
        logger.info("--------------------------------------------");
        INSTANCE.initConfig();
        logger.info("============================================");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/luismaia/config/ConfigManager$ConfigFileStatus;", "", "", "number", "<init>", "(Ljava/lang/String;II)V", "NOT_EXIST", "EMPTY", "INVALID", "VALID", "Cobblemon-Wiki-Gui"})
    private static final class ConfigFileStatus
    extends Enum<ConfigFileStatus> {
        public static final /* enum */ ConfigFileStatus NOT_EXIST = new ConfigFileStatus(1);
        public static final /* enum */ ConfigFileStatus EMPTY = new ConfigFileStatus(2);
        public static final /* enum */ ConfigFileStatus INVALID = new ConfigFileStatus(3);
        public static final /* enum */ ConfigFileStatus VALID = new ConfigFileStatus(4);
        private static final /* synthetic */ ConfigFileStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConfigFileStatus(int number) {
        }

        public static ConfigFileStatus[] values() {
            return (ConfigFileStatus[])$VALUES.clone();
        }

        public static ConfigFileStatus valueOf(String value) {
            return Enum.valueOf(ConfigFileStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigFileStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = configFileStatusArray = new ConfigFileStatus[]{ConfigFileStatus.NOT_EXIST, ConfigFileStatus.EMPTY, ConfigFileStatus.INVALID, ConfigFileStatus.VALID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigFileStatus.values().length];
            try {
                nArray[ConfigFileStatus.NOT_EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigFileStatus.EMPTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigFileStatus.INVALID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigFileStatus.VALID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

