/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Arrays;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_3222;

public class PokemonMeleeAttackGoal
extends class_1366 {
    private final double speedModifier;
    public int ticksUntilNewAngerParticle = 0;
    public int ticksUntilNewAngerCry = 0;

    public PokemonMeleeAttackGoal(class_1314 mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(mob, speedModifier, followingTargetEvenIfNotSeen);
        this.speedModifier = speedModifier;
    }

    public void method_6268() {
        PokemonEntity pokemonEntity = (PokemonEntity)this.field_6503;
        class_1309 owner = pokemonEntity.method_35057();
        if (owner == null) {
            if (this.ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry((class_1308)this.field_6503);
                this.ticksUntilNewAngerParticle = 10;
            } else {
                --this.ticksUntilNewAngerParticle;
            }
            if (this.ticksUntilNewAngerCry < 1) {
                pokemonEntity.cry();
                this.ticksUntilNewAngerCry = 100 + (int)(Math.random() * 200.0);
            } else {
                --this.ticksUntilNewAngerCry;
            }
        }
        super.method_6268();
        this.changeMoveSpeed();
    }

    private void changeMoveSpeed() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            this.field_6503.method_5942().method_6344(0.0);
        } else {
            this.field_6503.method_5942().method_6344(this.speedModifier);
        }
    }

    public boolean isTargetInBattle() {
        class_1309 class_13092 = this.field_6503.method_5968();
        if (class_13092 instanceof class_3222) {
            class_3222 targetAsPlayer = (class_3222)class_13092;
            return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(targetAsPlayer) != null;
        }
        return false;
    }

    public boolean method_6264() {
        class_1314 class_13142 = this.field_6503;
        if (class_13142 instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)class_13142;
            return !PokemonUtils.moveCommandAvailable(pokemonEntity) && PokemonUtils.shouldMelee(pokemonEntity) && PokemonUtils.shouldFightTarget(pokemonEntity) && super.method_6264();
        }
        return false;
    }

    public boolean method_6266() {
        return PokemonUtils.shouldFightTarget((PokemonEntity)this.field_6503) && super.method_6266() && !PokemonUtils.moveCommandAvailable((PokemonEntity)this.field_6503);
    }

    protected void method_6288(class_1309 target) {
        if (this.method_53715(target)) {
            this.method_28346();
            this.pokemonDoHurtTarget((class_1297)target);
        }
    }

    public boolean pokemonDoHurtTarget(class_1297 hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)this.field_6503;
        if (!this.pokemonTryForceEncounter(pokemonEntity, hurtTarget)) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null && Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                PokemonAttackEffect.dealAoEDamage(pokemonEntity, (class_1297)pokemonEntity, true);
                if (PokemonUtils.isMeleeAttackMove(move)) {
                    PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
                } else {
                    PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
                }
                return true;
            }
            PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(pokemonEntity, hurtTarget);
        }
        return false;
    }

    public boolean pokemonTryForceEncounter(PokemonEntity attackingPokemon, class_1297 hurtTarget) {
        if (hurtTarget instanceof PokemonEntity) {
            PokemonEntity defendingPokemon = (PokemonEntity)hurtTarget;
            if (attackingPokemon.getPokemon().isPlayerOwned()) {
                if (defendingPokemon.getPokemon().isPlayerOwned()) {
                    if (CobblemonFightOrFlight.commonConfig().force_player_battle_on_pokemon_hurt) {
                        return this.pokemonForceEncounterPvP(attackingPokemon, defendingPokemon);
                    }
                } else if (CobblemonFightOrFlight.commonConfig().force_wild_battle_on_pokemon_hurt) {
                    return this.pokemonForceEncounterPvE(attackingPokemon, defendingPokemon);
                }
            } else if (defendingPokemon.getPokemon().isPlayerOwned() && CobblemonFightOrFlight.commonConfig().force_wild_battle_on_pokemon_hurt) {
                return this.pokemonForceEncounterPvE(defendingPokemon, attackingPokemon);
            }
        }
        return false;
    }

    public boolean pokemonForceEncounterPvP(PokemonEntity playerPokemon, PokemonEntity opponentPokemon) {
        class_1309 class_13092 = playerPokemon.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            class_13092 = opponentPokemon.method_35057();
            if (class_13092 instanceof class_3222) {
                class_3222 serverOpponent = (class_3222)class_13092;
                if (serverPlayer == serverOpponent || !this.canBattlePlayer(serverPlayer) || !this.canBattlePlayer(serverOpponent)) {
                    return false;
                }
                BattleBuilder.INSTANCE.pvp1v1(serverPlayer, serverOpponent, null, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false);
            }
        }
        return false;
    }

    public boolean pokemonForceEncounterPvE(PokemonEntity playerPokemon, PokemonEntity wildPokemon) {
        class_1309 class_13092 = playerPokemon.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if (!this.canBattlePlayer(serverPlayer)) {
                return false;
            }
            BattleBuilder.INSTANCE.pve(serverPlayer, wildPokemon, playerPokemon.getPokemon().getUuid(), BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.config.getDefaultFleeDistance(), (PartyStore)Cobblemon.INSTANCE.getStorage().getParty(serverPlayer));
        }
        return false;
    }

    public boolean canBattlePlayer(class_3222 serverPlayer) {
        boolean playerHasAlivePokemon = false;
        for (Pokemon pokemon : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
            if (pokemon.isFainted()) continue;
            playerHasAlivePokemon = true;
            break;
        }
        return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(serverPlayer) == null && playerHasAlivePokemon && serverPlayer.method_5805();
    }
}

