/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import java.util.EnumSet;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.goals.PokemonAttackGoal;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PokemonRangedAttackGoal
extends PokemonAttackGoal {
    private final PokemonEntity pokemonEntity;
    private final class_1309 livingEntity;
    @Nullable
    private class_1309 target;
    private final double speedModifier;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public PokemonRangedAttackGoal(class_1309 pokemonEntity, double speedModifier, float attackRadius) {
        this.setAttackTime(-1);
        this.livingEntity = pokemonEntity;
        if (!(pokemonEntity instanceof PokemonEntity)) {
            throw new IllegalArgumentException("PokemonRangedAttackGoal requires a PokemonEntity");
        }
        this.pokemonEntity = (PokemonEntity)pokemonEntity;
        this.speedModifier = speedModifier;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    @Override
    public boolean method_6264() {
        if (!PokemonUtils.shouldShoot(this.pokemonEntity) || PokemonUtils.moveCommandAvailable(this.pokemonEntity)) {
            return false;
        }
        if (this.pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
            return false;
        }
        class_1309 livingEntity = this.pokemonEntity.method_5968();
        if (livingEntity != null && livingEntity.method_5805()) {
            this.target = livingEntity;
            return PokemonUtils.shouldFightTarget(this.pokemonEntity);
        }
        return false;
    }

    public boolean method_6266() {
        if (this.target == null) {
            return false;
        }
        return (this.method_6264() || !this.pokemonEntity.getNavigation().method_6357()) && !this.isTargetInBattle();
    }

    public void method_6270() {
        this.target = null;
        this.seeTime = 0;
        this.setAttackTime(-1);
    }

    public boolean method_38846() {
        return true;
    }

    public boolean isTargetInBattle() {
        class_1309 class_13092 = this.pokemonEntity.method_5968();
        if (class_13092 instanceof class_3222) {
            class_3222 targetAsPlayer = (class_3222)class_13092;
            return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(targetAsPlayer) != null;
        }
        return false;
    }

    @Override
    public void method_6268() {
        super.method_6268();
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            this.pokemonEntity.getNavigation().method_6344(0.0);
        }
        if (this.target != null) {
            double d = this.pokemonEntity.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
            boolean bl = this.pokemonEntity.method_5985().method_6369((class_1297)this.target);
            if (bl) {
                ++this.seeTime;
            } else {
                this.seeTime = 0;
                this.resetAttackTime(d);
            }
            if (!(d > (double)this.attackRadiusSqr) && this.seeTime >= 5 && bl) {
                this.pokemonEntity.getNavigation().method_6340();
                ++this.strafingTime;
            } else {
                this.pokemonEntity.getNavigation().method_6335((class_1297)this.target, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 10) {
                if ((double)this.pokemonEntity.method_59922().method_43057() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.pokemonEntity.method_59922().method_43057() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d > (double)(this.attackRadiusSqr * 0.8f)) {
                    this.strafingBackwards = false;
                } else if (d < (double)(this.attackRadiusSqr * 0.2f)) {
                    this.strafingBackwards = true;
                }
                this.pokemonEntity.method_5962().method_6243(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                class_1297 vehicle = this.pokemonEntity.method_49694();
                if (vehicle instanceof class_1308) {
                    class_1308 mob = (class_1308)vehicle;
                    mob.method_5951((class_1297)this.livingEntity, 30.0f, 30.0f);
                }
            }
            this.pokemonEntity.method_5988().method_35111((class_1297)this.target);
            ((PokemonInterface)this.pokemonEntity).setAttackTime(((PokemonInterface)this.pokemonEntity).getAttackTime() - 1);
            if (this.getAttackTime() == 7 && ((PokemonInterface)this.pokemonEntity).usingSound()) {
                PokemonUtils.createSonicBoomParticle(this.pokemonEntity, this.target);
            }
            if (this.getAttackTime() % 5 == 0 && ((PokemonInterface)this.pokemonEntity).usingMagic()) {
                PokemonAttackEffect.makeMagicAttackParticle(this.pokemonEntity, (class_1297)this.target);
            }
            if (this.getAttackTime() == 0) {
                if (!bl) {
                    return;
                }
                this.resetAttackTime(d);
                this.performRangedAttack(this.target);
            } else if (this.getAttackTime() < 0) {
                this.resetAttackTime(d);
            }
        }
    }

    @Override
    protected PokemonEntity getPokemonEntity() {
        return this.pokemonEntity;
    }

    protected void performRangedAttack(class_1309 target) {
        PokemonAttackEffect.pokemonPerformRangedAttack(this.pokemonEntity, target);
    }
}

