/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.cobblemon.mod.common.net.messages.client.effect.RunPosableMoLangPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.evolution.progress.UseMoveEvolutionProgress;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.MoveData;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PokemonUtils {
    public static boolean shouldMelee(PokemonEntity pokemonEntity) {
        boolean b3;
        Move move = PokemonUtils.getMeleeMove(pokemonEntity);
        boolean b1 = pokemonEntity.getPokemon().getAttack() > pokemonEntity.getPokemon().getSpecialAttack();
        boolean b2 = pokemonEntity.method_35057() == null;
        boolean bl = b3 = move != null;
        if (b2) {
            return b1 || !CobblemonFightOrFlight.commonConfig().wild_pokemon_ranged_attack;
        }
        return b3;
    }

    public static boolean shouldShoot(PokemonEntity pokemonEntity) {
        boolean b3;
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        boolean b1 = pokemonEntity.getPokemon().getAttack() < pokemonEntity.getPokemon().getSpecialAttack();
        boolean b2 = pokemonEntity.method_35057() == null;
        boolean bl = b3 = move != null;
        if (b2) {
            return b1 && CobblemonFightOrFlight.commonConfig().wild_pokemon_ranged_attack;
        }
        return b3;
    }

    public static boolean shouldFightTarget(PokemonEntity pokemonEntity) {
        if (pokemonEntity.getPokemon().getLevel() < CobblemonFightOrFlight.commonConfig().minimum_attack_level) {
            return false;
        }
        class_1309 owner = pokemonEntity.method_35057();
        if (owner != null) {
            PokemonEntity targetPokemon;
            class_1309 targetOwner;
            if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner || pokemonEntity.method_5968() == null || pokemonEntity.method_5968() == owner) {
                return false;
            }
            class_1309 class_13092 = pokemonEntity.method_5968();
            if (class_13092 instanceof PokemonEntity && (targetOwner = (targetPokemon = (PokemonEntity)class_13092).method_35057()) != null) {
                if (targetOwner == owner) {
                    return false;
                }
                if (!CobblemonFightOrFlight.commonConfig().do_player_pokemon_attack_other_player_pokemon) {
                    return false;
                }
            }
            if (pokemonEntity.method_5968() instanceof class_1657 && !CobblemonFightOrFlight.commonConfig().do_player_pokemon_attack_other_players) {
                return false;
            }
        } else if (pokemonEntity.method_5968() != null) {
            if (CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) <= 0.0) {
                return false;
            }
            class_1309 targetEntity = pokemonEntity.method_5968();
            if (pokemonEntity.method_5649(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321()) > 400.0) {
                return false;
            }
        }
        return !pokemonEntity.isBusy();
    }

    public static Move getMove(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.info("PokemonEntity is null");
            return null;
        }
        String moveName = ((PokemonInterface)pokemonEntity).getCurrentMove() != null ? ((PokemonInterface)pokemonEntity).getCurrentMove() : pokemonEntity.getPokemon().getMoveSet().get(0).getName();
        Move move = null;
        boolean flag = false;
        if (moveName == null) {
            return null;
        }
        for (MoveTemplate m : pokemonEntity.getPokemon().getAllAccessibleMoves()) {
            move = m.create();
            if (!m.getName().equals(moveName)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            move = pokemonEntity.getPokemon().getMoveSet().get(0);
        }
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.warn("Returning a null move for no reason");
        }
        return move;
    }

    @Deprecated
    public static Move getMove(PokemonEntity pokemonEntity, boolean getSpecial) {
        boolean isPhysical;
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        boolean isSpecial = move.getDamageCategory() == DamageCategories.INSTANCE.getSPECIAL();
        boolean bl = isPhysical = move.getDamageCategory() == DamageCategories.INSTANCE.getPHYSICAL();
        if (isSpecial && getSpecial || isPhysical && !getSpecial) {
            ((PokemonInterface)pokemonEntity).setCurrentMove(move);
            return move;
        }
        return null;
    }

    public static boolean isMeleeAttackMove(Move move) {
        if (move == null) {
            return true;
        }
        String moveName = move.getName();
        boolean isSpecial = move.getDamageCategory() == DamageCategories.INSTANCE.getSPECIAL();
        boolean isPhysical = move.getDamageCategory() == DamageCategories.INSTANCE.getPHYSICAL();
        boolean b1 = isPhysical && !Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName) && !Arrays.stream(CobblemonFightOrFlight.moveConfig().physical_single_arrow_moves).toList().contains(moveName);
        boolean b2 = isSpecial && Arrays.stream(CobblemonFightOrFlight.moveConfig().special_contact_moves).toList().contains(moveName);
        return b1 || b2;
    }

    public static boolean isRangeAttackMove(Move move) {
        if (move == null) {
            return true;
        }
        String moveName = move.getName();
        boolean isSpecial = move.getDamageCategory() == DamageCategories.INSTANCE.getSPECIAL();
        boolean isPhysical = move.getDamageCategory() == DamageCategories.INSTANCE.getPHYSICAL();
        boolean b1 = isPhysical && (Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName) || Arrays.stream(CobblemonFightOrFlight.moveConfig().physical_single_arrow_moves).toList().contains(moveName));
        boolean b2 = isSpecial && !Arrays.stream(CobblemonFightOrFlight.moveConfig().special_contact_moves).toList().contains(moveName);
        return b1 || b2;
    }

    public static Move getMeleeMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        if (PokemonUtils.isMeleeAttackMove(move)) {
            ((PokemonInterface)pokemonEntity).setCurrentMove(move);
            return move;
        }
        return null;
    }

    public static Move getRangeAttackMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        if (PokemonUtils.isRangeAttackMove(move)) {
            ((PokemonInterface)pokemonEntity).setCurrentMove(move);
            return move;
        }
        return null;
    }

    public static boolean isSpecialMove(Move move) {
        return move.getDamageCategory() == DamageCategories.INSTANCE.getSPECIAL();
    }

    public static boolean isPhysicalMove(Move move) {
        return move.getDamageCategory() == DamageCategories.INSTANCE.getPHYSICAL();
    }

    public static void makeParticle(int particleAmount, class_1297 entity, class_2400 particleType) {
        class_1937 level = entity.method_37908();
        if (particleAmount > 0) {
            double d = 0.0;
            double e = 0.0;
            double f = 0.0;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)particleType, entity.method_23322(0.5), entity.method_23319(), entity.method_23325(0.5), particleAmount, d, e, f, 1.0);
            } else {
                for (int j = 0; j < particleAmount; ++j) {
                    level.method_8406((class_2394)particleType, entity.method_23322(0.5), entity.method_23319(), entity.method_23325(0.5), d, e, f);
                }
            }
        }
    }

    public static void setHurtByPlayer(PokemonEntity pokemonEntity, class_1297 target) {
        class_1309 owner = pokemonEntity.method_35057();
        if (owner instanceof class_1657) {
            class_1657 player = (class_1657)owner;
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                livingEntity.method_29505(player);
            }
        }
    }

    public static boolean canTaunt(PokemonEntity pokemonEntity) {
        if (!CobblemonFightOrFlight.moveConfig().taunt_moves_needed) {
            return true;
        }
        boolean result = false;
        MoveSet moveSet = pokemonEntity.getPokemon().getMoveSet();
        for (Move move : moveSet) {
            if (!Arrays.stream(CobblemonFightOrFlight.moveConfig().taunting_moves).toList().contains(move.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isExplosiveMove(String moveName) {
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().explosive_moves).toList().contains(moveName);
    }

    public static void createSonicBoomParticle(PokemonEntity pokemonEntity, class_1309 target) {
        if (target == null) {
            return;
        }
        float height = pokemonEntity.method_5751();
        class_243 vec1 = pokemonEntity.method_19538().method_1031(0.0, (double)height, 0.0);
        class_243 vec2 = target.method_33571().method_1020(vec1);
        class_243 vec3 = vec2.method_1029();
        for (int i = 1; i < class_3532.method_15357((double)vec2.method_1033()) + 1; ++i) {
            class_243 vec4 = vec1.method_1019(vec3.method_1021((double)i));
            class_1937 level = target.method_37908();
            if (!(level instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199((class_2394)class_2398.field_38908, vec4.field_1352, vec4.field_1351, vec4.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void sendAnimationPacket(PokemonEntity pokemonEntity, String mode) {
        if (!pokemonEntity.method_37908().field_9236) {
            PlayPosableAnimationPacket pkt = new PlayPosableAnimationPacket(pokemonEntity.method_5628(), Set.of(mode), List.of());
            pokemonEntity.method_37908().method_8390(class_3222.class, class_238.method_30048((class_243)pokemonEntity.method_19538(), (double)64.0, (double)64.0, (double)64.0), livingEntity -> true).forEach(arg_0 -> ((PlayPosableAnimationPacket)pkt).sendToPlayer(arg_0));
        }
    }

    public static void updateMoveEvolutionProgress(Pokemon pokemon, MoveTemplate move) {
        if (UseMoveEvolutionProgress.Companion.supports(pokemon, move) && CobblemonFightOrFlight.commonConfig().can_progress_use_move_evoluiton) {
            UseMoveEvolutionProgress progress = (UseMoveEvolutionProgress)pokemon.getEvolutionProxy().current().progressFirstOrCreate(evolutionProgress -> {
                if (evolutionProgress instanceof UseMoveEvolutionProgress) {
                    UseMoveEvolutionProgress umep = (UseMoveEvolutionProgress)evolutionProgress;
                    return umep.currentProgress().getMove().equals(move);
                }
                return false;
            }, UseMoveEvolutionProgress::new);
            progress.updateProgress(new UseMoveEvolutionProgress.Progress(move, progress.currentProgress().getAmount() + 1));
        }
    }

    public static boolean shouldRetreat(PokemonEntity pokemonEntity) {
        class_1799 i = pokemonEntity.getPokemon().heldItem();
        return pokemonEntity.method_35057() != null && (double)pokemonEntity.method_6032() < (double)pokemonEntity.method_6063() * 0.5 && Arrays.stream(CobblemonFightOrFlight.moveConfig().emergency_exit_like_abilities).toList().contains(pokemonEntity.getPokemon().getAbility().getName());
    }

    public static void makeCobblemonParticle(class_1297 entity, String particleName) {
        if (entity != null) {
            RunPosableMoLangPacket packet = new RunPosableMoLangPacket(entity.method_5628(), Set.of(String.format("q.particle('cobblemon:%s', 'target')", particleName)));
            packet.sendToPlayersAround(entity.method_23317(), entity.method_23318(), entity.method_23321(), 50.0, entity.method_37908().method_27983(), serverPlayer -> false);
        }
    }

    public static class_1799 getHeldItem(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            return null;
        }
        return PokemonUtils.getHeldItem(pokemonEntity.getPokemon());
    }

    public static class_1799 getHeldItem(Pokemon pokemon) {
        if (pokemon == null) {
            return null;
        }
        return pokemon.heldItem();
    }

    public static boolean isUsingNewHealthMechanic() {
        return CobblemonFightOrFlight.commonConfig().shouldOverrideUpdateMaxHealth;
    }

    public static int getMaxHealth(PokemonEntity pokemonEntity) {
        return PokemonUtils.getMaxHealth(pokemonEntity.getPokemon());
    }

    public static int getHPStat(Pokemon pokemon) {
        return pokemon.getMaxHealth();
    }

    public static int getMaxHealth(Pokemon pokemon) {
        int hpStat = PokemonUtils.getHPStat(pokemon);
        int minStat = CobblemonFightOrFlight.commonConfig().min_HP_required_stat;
        int midStat = CobblemonFightOrFlight.commonConfig().mid_HP_required_stat;
        int maxStat = CobblemonFightOrFlight.commonConfig().max_HP_required_stat;
        int stat = class_3532.method_15340((int)hpStat, (int)minStat, (int)maxStat);
        int minHealth = CobblemonFightOrFlight.commonConfig().min_HP;
        int midHealth = CobblemonFightOrFlight.commonConfig().mid_HP;
        int maxHealth = CobblemonFightOrFlight.commonConfig().max_HP;
        int health = minHealth;
        health = Math.round(stat < midStat ? class_3532.method_16439((float)((float)(stat - minStat) / (float)(midStat - minStat)), (float)minHealth, (float)midHealth) : class_3532.method_16439((float)((float)(stat - midStat) / (float)(maxStat - midStat)), (float)midHealth, (float)maxHealth));
        return health;
    }

    public static void entityHpToPokemonHp(PokemonEntity pokemonEntity, float amount, boolean isHealing) {
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.getCurrentHealth() == 0 || pokemonEntity.isBattling() || pokemonEntity.method_35057() == null && !CobblemonFightOrFlight.commonConfig().enable_health_sync_for_wild_pokemon) {
            return;
        }
        float ratio = amount / (float)PokemonUtils.getMaxHealth(pokemonEntity);
        int val = pokemon.getCurrentHealth() + (int)Math.floor(ratio * (float)PokemonUtils.getHPStat(pokemon)) * (isHealing ? 1 : -1);
        pokemon.setCurrentHealth(val);
    }

    public static boolean isSheerForce(PokemonEntity pokemonEntity) {
        return pokemonEntity.getPokemon().getAbility().getName().equals("sheerforce");
    }

    public static boolean canActivateSheerForce(PokemonEntity pokemonEntity) {
        Move move;
        if (pokemonEntity != null && PokemonUtils.isSheerForce(pokemonEntity) && (move = PokemonUtils.getMove(pokemonEntity)) != null && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.canActivateSheerForce()) continue;
                return true;
            }
        }
        return false;
    }

    public static PokeStaffComponent.CMDMODE getCommandMode(PokemonEntity pokemon) {
        try {
            return PokeStaffComponent.CMDMODE.valueOf(((PokemonInterface)pokemon).getCommand());
        }
        catch (IllegalArgumentException e) {
            return PokeStaffComponent.CMDMODE.NOCMD;
        }
    }

    public static boolean WildPokemonCanPerformUnprovokedAttack(PokemonEntity pokemonEntity) {
        return pokemonEntity != null && CobblemonFightOrFlight.commonConfig().do_pokemon_attack_unprovoked && pokemonEntity.getPokemon().getLevel() >= CobblemonFightOrFlight.commonConfig().minimum_attack_unprovoked_level && !pokemonEntity.getPokemon().isPlayerOwned();
    }

    public static String getCommandData(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getCommandData();
    }

    public static boolean moveCommandAvailable(PokemonEntity pokemonEntity) {
        return PokeStaffComponent.CMDMODE.MOVE == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean moveAttackCommandAvailable(PokemonEntity pokemonEntity) {
        return PokeStaffComponent.CMDMODE.MOVE_ATTACK == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean stayCommandAvailable(PokemonEntity pokemonEntity) {
        return PokeStaffComponent.CMDMODE.STAY == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean attackPositionAvailable(PokemonEntity pokemonEntity) {
        return PokeStaffComponent.CMDMODE.ATTACK_POSITION == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean shouldDisableFollowOwner(PokemonEntity pokemon) {
        PokeStaffComponent.CMDMODE cmd = PokemonUtils.getCommandMode(pokemon);
        switch (cmd) {
            case ATTACK: 
            case ATTACK_POSITION: 
            case MOVE_ATTACK: 
            case STAY: 
            case MOVE: {
                return true;
            }
        }
        return false;
    }

    public static void clearCommand(PokemonEntity pokemonEntity) {
        ((PokemonInterface)pokemonEntity).setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        ((PokemonInterface)pokemonEntity).setCommandData("");
    }

    public static void finishMoving(PokemonEntity pokemonEntity) {
        if (CobblemonFightOrFlight.commonConfig().stay_after_move_command) {
            if (PokemonUtils.moveCommandAvailable(pokemonEntity)) {
                ((PokemonInterface)pokemonEntity).setCommand(PokeStaffComponent.CMDMODE.STAY.name());
                pokemonEntity.getNavigation().method_6340();
            }
        } else {
            PokemonUtils.clearCommand(pokemonEntity);
        }
    }

    public static void pokemonEntityApproachPos(PokemonEntity pokemonEntity, class_2338 pos, double speedModifier) {
        if (pos != class_2338.field_10980 && pokemonEntity.getNavigation().method_6357()) {
            pokemonEntity.getNavigation().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), speedModifier);
        }
    }

    public static float getAttackRadius() {
        return 16.0f;
    }

    public static boolean shouldStopRunningAfterHurt(PokemonEntity pokemonEntity) {
        if (CobblemonFightOrFlight.commonConfig().stop_running_after_hurt) {
            return pokemonEntity.method_6032() < pokemonEntity.method_6063();
        }
        return false;
    }

    public static boolean shouldCheckPokeStaff() {
        return true;
    }
}

