/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils.listeners;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.MoveData;
import me.rufia.fightorflight.data.MoveDataContainer;
import me.rufia.fightorflight.data.container.StatChangeMoveDataContainer;
import me.rufia.fightorflight.data.container.StatusEffectMoveDataContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class MoveDataListener
extends class_4080<Map<class_2960, MoveDataContainer>> {
    protected Map<class_2960, MoveDataContainer> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap<class_2960, MoveDataContainer> map = new HashMap<class_2960, MoveDataContainer>();
        CobblemonFightOrFlight.LOGGER.info("[FOF] Preparing to read");
        this.prepareTag(resourceManager, "stat", (Type)((Object)StatChangeMoveDataContainer.class), (Map<class_2960, MoveDataContainer>)map);
        this.prepareTag(resourceManager, "status", (Type)((Object)StatusEffectMoveDataContainer.class), (Map<class_2960, MoveDataContainer>)map);
        return map;
    }

    private void prepareTag(class_3300 resourceManager, String tagName, Type type, Map<class_2960, MoveDataContainer> map) {
        for (Map.Entry entry : resourceManager.method_14488("fof_move_data/" + tagName, fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            class_2960 resourceLocation = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.method_14482()));
                Gson gson = new Gson();
                map.put(resourceLocation, (MoveDataContainer)gson.fromJson(reader, type));
            }
            catch (Exception e) {
                CobblemonFightOrFlight.LOGGER.warn("Failed to read {}", (Object)resourceLocation);
            }
        }
    }

    private void register(Map<String, ? extends MoveData> dataMap) {
        for (Map.Entry<String, ? extends MoveData> mapEntry : dataMap.entrySet()) {
            if (MoveData.moveData.containsKey(mapEntry.getKey())) {
                if (MoveData.moveData.get(mapEntry.getKey()) == null) continue;
                MoveData.moveData.get(mapEntry.getKey()).add(mapEntry.getValue());
                continue;
            }
            MoveData.moveData.put(mapEntry.getKey(), new ArrayList());
            MoveData.moveData.get(mapEntry.getKey()).add(mapEntry.getValue());
        }
    }

    protected void apply(Map<class_2960, MoveDataContainer> map, class_3300 resourceManager, class_3695 profiler) {
        MoveData.moveData.clear();
        int fileCount = 0;
        for (Map.Entry<class_2960, MoveDataContainer> entry : map.entrySet()) {
            class_2960 location = entry.getKey();
            MoveDataContainer container = entry.getValue();
            Map<String, MoveData> dataMap = null;
            if (container instanceof StatChangeMoveDataContainer) {
                StatChangeMoveDataContainer statChangeMoveDataContainer = (StatChangeMoveDataContainer)container;
                dataMap = statChangeMoveDataContainer.build();
            } else if (container instanceof StatusEffectMoveDataContainer) {
                StatusEffectMoveDataContainer statusEffectMoveDataContainer = (StatusEffectMoveDataContainer)container;
                dataMap = statusEffectMoveDataContainer.build();
            }
            if (dataMap == null) continue;
            this.register(dataMap);
            ++fileCount;
        }
        CobblemonFightOrFlight.LOGGER.info("[FOF] {} move data files processed.", (Object)fileCount);
    }
}

