/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import tschipp.carryon.Constants;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.platform.Services;

public class CarriedObjectRender {
    private static SequencedMap<class_1921, class_9799> builders = new LinkedHashMap<class_1921, class_9799>(Map.of(class_1921.method_23590(), new class_9799(class_1921.method_23590().method_22722()), class_1921.method_27949(), new class_9799(class_1921.method_27949().method_22722()), class_1921.method_30676(), new class_9799(class_1921.method_30676().method_22722()), class_1921.method_23591(), new class_9799(class_1921.method_23591().method_22722()), class_1921.method_29707(), new class_9799(class_1921.method_29707().method_22722())));

    public static boolean drawFirstPerson(class_1657 player, class_4597 buffer, class_4587 matrix, int light, float partialTicks) {
        if (Services.PLATFORM.isModLoaded("firstperson") || Services.PLATFORM.isModLoaded("firstpersonmod")) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        try {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                CarriedObjectRender.drawFirstPersonBlock(player, buffer, matrix, light, CarryRenderHelper.getRenderState(player));
            } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                CarriedObjectRender.drawFirstPersonEntity(player, buffer, matrix, light, partialTicks);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript.ScriptRender render = carry.getActiveScript().get().scriptRender();
            if (!render.renderLeftArm() && player.method_6068() == class_1306.field_6182) {
                return false;
            }
            if (!render.renderRightArm() && player.method_6068() == class_1306.field_6183) {
                return false;
            }
        }
        return carry.isCarrying();
    }

    private static void drawFirstPersonBlock(class_1657 player, class_4597 buffer, class_4587 matrix, int light, class_2680 state) {
        matrix.method_22903();
        matrix.method_22905(2.5f, 2.5f, 2.5f);
        matrix.method_22904(0.0, -0.5, -1.0);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(state.method_26204())) {
            matrix.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            matrix.method_22907(class_7833.field_40713.rotationDegrees(8.0f));
        } else {
            matrix.method_22907(class_7833.field_40714.rotationDegrees(8.0f));
        }
        if (carry.getActiveScript().isPresent()) {
            CarryRenderHelper.performScriptTransformation(matrix, carry.getActiveScript().get());
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_1799 stack = new class_1799((class_1935)state.method_26204().method_8389());
        class_1087 model = CarryRenderHelper.getRenderBlock(player);
        CarryRenderHelper.renderBakedModel(stack, matrix, buffer, light, model);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrix.method_22909();
    }

    private static void drawFirstPersonEntity(class_1657 player, class_4597 buffer, class_4587 matrix, int light, float partialTicks) {
        class_898 manager = class_310.method_1551().method_1561();
        class_1297 entity = CarryRenderHelper.getRenderEntity(player);
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (entity != null) {
            class_243 playerpos = CarryRenderHelper.getExactPos((class_1297)player, partialTicks);
            entity.method_5814(playerpos.field_1352, playerpos.field_1351, playerpos.field_1350);
            entity.field_6004 = 0.0f;
            entity.field_5982 = 0.0f;
            entity.method_5847(0.0f);
            float height = entity.method_17682();
            float width = entity.method_17681();
            matrix.method_22903();
            matrix.method_22905(0.8f, 0.8f, 0.8f);
            matrix.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            matrix.method_22904(0.0, (double)(-height) - 0.1, (double)width + 0.1);
            manager.method_3948(false);
            Optional<CarryOnScript> res = carry.getActiveScript();
            if (res.isPresent()) {
                CarryOnScript script = res.get();
                CarryRenderHelper.performScriptTransformation(matrix, script);
            }
            if (entity instanceof class_1309) {
                ((class_1309)entity).field_6235 = 0;
            }
            try {
                manager.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, buffer, light);
            }
            catch (Exception exception) {
                // empty catch block
            }
            manager.method_3948(true);
            matrix.method_22909();
        }
    }

    public static void drawThirdPerson(float partialticks, Matrix4f mat) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        int light = 0;
        int perspective = CarryRenderHelper.getPerspective();
        class_898 manager = mc.method_1561();
        class_4587 matrix = new class_4587();
        matrix.method_34425(mat);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        class_4597.class_4598 buffer = class_4597.method_22992(builders, (class_9799)((class_9799)builders.get(class_1921.method_23590())));
        for (class_1657 player : level.method_18456()) {
            try {
                class_1297 entity;
                CarryOnData carry = CarryOnDataManager.getCarryData(player);
                if (perspective == 0 && player == mc.field_1724 && !Services.PLATFORM.isModLoaded("firstperson") && !Services.PLATFORM.isModLoaded("firstpersonmod") && !Services.PLATFORM.isModLoaded("realcamera")) continue;
                light = manager.method_23839((class_1297)player, partialticks);
                if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                    class_2680 state = CarryRenderHelper.getRenderState(player);
                    CarryRenderHelper.applyBlockTransformations(player, partialticks, matrix, state.method_26204());
                    class_1799 tileItem = new class_1799((class_1935)state.method_26204().method_8389());
                    class_1087 model = CarryRenderHelper.getRenderBlock(player);
                    Optional<CarryOnScript> res = carry.getActiveScript();
                    if (res.isPresent()) {
                        CarryOnScript script = res.get();
                        CarryRenderHelper.performScriptTransformation(matrix, script);
                    }
                    RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                    RenderSystem.enableCull();
                    class_4587.class_4665 p = matrix.method_23760();
                    class_4587 copy = new class_4587();
                    copy.method_34425(p.method_23761());
                    matrix.method_22909();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    CarryRenderHelper.renderBakedModel(tileItem, copy, (class_4597)buffer, light, model);
                    matrix.method_22909();
                    continue;
                }
                if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) || (entity = CarryRenderHelper.getRenderEntity(player)) == null) continue;
                CarryRenderHelper.applyEntityTransformations(player, partialticks, matrix, entity);
                manager.method_3948(false);
                Optional<CarryOnScript> res = carry.getActiveScript();
                if (res.isPresent()) {
                    CarryOnScript script = res.get();
                    CarryRenderHelper.performScriptTransformation(matrix, script);
                }
                if (entity instanceof class_1309) {
                    class_1309 le = (class_1309)entity;
                    le.field_6235 = 0;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                manager.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, (class_4597)buffer, light);
                matrix.method_22909();
                manager.method_3948(true);
                matrix.method_22909();
            }
            catch (Exception exception) {}
        }
        buffer.method_37104();
        buffer.method_22994(class_1921.method_23572((class_2960)class_1059.field_5275));
        buffer.method_22994(class_1921.method_23576((class_2960)class_1059.field_5275));
        buffer.method_22994(class_1921.method_23578((class_2960)class_1059.field_5275));
        buffer.method_22994(class_1921.method_23584((class_2960)class_1059.field_5275));
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

