/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import org.apache.commons.lang3.function.TriFunction;

public interface IInventoryPartHandler {
    public static final IInventoryPartHandler EMPTY = () -> "EMPTY";

    default public int getSlotLimit(int slot) {
        return 0;
    }

    default public boolean isSlotAccessible(int slot) {
        return false;
    }

    default public int getStackLimit(int slot, class_1799 stack) {
        return 0;
    }

    default public class_1799 extractItem(int slot, int amount, boolean simulate) {
        return class_1799.field_8037;
    }

    default public class_1799 insertItem(int slot, class_1799 stack, boolean simulate, TriFunction<Integer, class_1799, Boolean, class_1799> insertSuper) {
        return stack;
    }

    default public void setStackInSlot(int slot, class_1799 stack, BiConsumer<Integer, class_1799> setStackInSlotSuper) {
    }

    default public boolean isItemValid(int slot, ItemVariant resource, int count) {
        return this.isItemValid(slot, resource.toStack(count));
    }

    default public boolean isItemValid(int slot, class_1799 stack) {
        return false;
    }

    default public class_1799 getStackInSlot(int slot, IntFunction<class_1799> getStackInSlotSuper) {
        return class_1799.field_8037;
    }

    default public boolean canBeReplaced() {
        return false;
    }

    default public int getSlots() {
        return 0;
    }

    public String getName();

    @Nullable
    default public Pair<class_2960, class_2960> getNoItemIcon(int slot) {
        return null;
    }

    default public class_1792 getFilterItem(int slot) {
        return class_1802.field_8162;
    }

    default public void onSlotLimitChange() {
    }

    default public Set<Integer> getNoSortSlots() {
        return Set.of();
    }

    default public void onSlotFilterChanged(int slot) {
    }

    default public boolean isFilterItem(class_1792 item) {
        return false;
    }

    default public Map<class_1792, Set<Integer>> getFilterItems() {
        return Map.of();
    }

    default public void onInit() {
    }

    public static interface Factory {
        public IInventoryPartHandler create(InventoryHandler var1, SlotRange var2, Supplier<MemorySettingsCategory> var3);
    }

    public static class Default
    implements IInventoryPartHandler {
        public static final String NAME = "default";
        private final InventoryHandler parent;
        private final int slots;

        public Default(InventoryHandler parent, int slots) {
            this.parent = parent;
            this.slots = slots;
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.parent.getBaseSlotLimit();
        }

        @Override
        public int getStackLimit(int slot, class_1799 stack) {
            return this.parent.getBaseStackLimit(stack);
        }

        @Override
        public class_1799 extractItem(int slot, int amount, boolean simulate) {
            return this.parent.extractItemInternal(slot, amount, simulate);
        }

        @Override
        public class_1799 insertItem(int slot, class_1799 stack, boolean simulate, TriFunction<Integer, class_1799, Boolean, class_1799> insertSuper) {
            return (class_1799)insertSuper.apply((Object)slot, (Object)stack, (Object)simulate);
        }

        @Override
        public void setStackInSlot(int slot, class_1799 stack, BiConsumer<Integer, class_1799> setStackInSlotSuper) {
            setStackInSlotSuper.accept(slot, stack);
        }

        @Override
        public boolean isItemValid(int slot, class_1799 stack) {
            return true;
        }

        @Override
        public class_1799 getStackInSlot(int slot, IntFunction<class_1799> getStackInSlotSuper) {
            return getStackInSlotSuper.apply(slot);
        }

        @Override
        public boolean canBeReplaced() {
            return true;
        }

        @Override
        public boolean isSlotAccessible(int slot) {
            return true;
        }

        @Override
        public int getSlots() {
            return this.slots;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

