/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3611;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private final XpPumpUpgradeConfig xpPumpUpgradeConfig;

    protected XpPumpUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.xpPumpUpgradeConfig = ((XpPumpUpgradeItem)this.upgradeItem).getXpPumpUpgradeConfig();
    }

    @Override
    public void tick(@Nullable class_1297 entity, class_1937 level, class_2338 pos) {
        if (entity != null && !(entity instanceof class_1657) || this.isInCooldown(level)) {
            return;
        }
        if (entity == null) {
            class_238 searchBox = new class_238(pos).method_1014(3.0);
            for (class_1657 player : level.method_18456()) {
                if (!searchBox.method_1008(player.method_23317(), player.method_23318(), player.method_23321())) continue;
                this.interactWithPlayer(player);
                this.mendItems(player);
            }
        } else {
            class_1657 player = entity instanceof class_1657 ? (class_1657)entity : null;
            this.interactWithPlayer(player);
            this.mendItems(player);
        }
        this.setCooldown(level, 5);
    }

    private void mendItems(class_1657 player) {
        if (Boolean.FALSE.equals(this.xpPumpUpgradeConfig.mendingOn.get()) || !this.shouldMendItems()) {
            return;
        }
        class_1890.method_8204((class_9331)class_9701.field_51652, (class_1309)player, class_1799::method_7986).ifPresent(item -> {
            float xpToTryDrain;
            class_1799 itemStack = item.comp_2682();
            if (!itemStack.method_7960() && itemStack.method_7986() && itemStack.getXpRepairRatio() > 0.0f && (xpToTryDrain = Math.min((float)((Integer)this.xpPumpUpgradeConfig.maxXpPointsPerMending.get()).intValue(), (float)itemStack.method_7919() / itemStack.getXpRepairRatio())) > 0.0f) {
                this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
                    FluidStack drained;
                    try (Transaction outer = Transaction.openOuter();){
                        drained = fluidHandler.extract(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(xpToTryDrain), (TransactionContext)outer, false);
                        outer.commit();
                    }
                    float xpDrained = XpHelper.liquidToExperience((int)drained.getAmount());
                    int durationToRepair = (int)(xpDrained * itemStack.getXpRepairRatio());
                    itemStack.method_7974(itemStack.method_7919() - durationToRepair);
                });
            }
        });
    }

    private void interactWithPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if (direction == AutomationDirection.INPUT) {
                if (level < player.field_7520 || level == player.field_7520 && player.field_7510 > 0.0f) {
                    this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, level, false);
                }
            } else if (direction == AutomationDirection.OUTPUT && level > player.field_7520) {
                this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        FluidStack drained;
        int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
        try (Transaction outer = Transaction.openOuter();){
            drained = fluidHandler.extract(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToGive), (TransactionContext)outer, ignoreInOutLimit);
            outer.commit();
        }
        if (!drained.isEmpty()) {
            player.method_7255((int)XpHelper.liquidToExperience((int)drained.getAmount()));
        }
    }

    private void tryFillTankWithPlayerExperience(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        long filled;
        int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
        try (Transaction outer = Transaction.openOuter();){
            filled = fluidHandler.insert(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToTake), (class_3611)ModFluids.XP_STILL.get(), (TransactionContext)outer, ignoreInOutLimit);
            outer.commit();
        }
        if (filled > 0L) {
            player.method_7255((int)(-XpHelper.liquidToExperience(filled)));
        }
    }

    public void takeLevelsFromPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, Math.max(player.field_7520 - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, player.field_7520 + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return (AutomationDirection)((Object)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.AUTOMATION_DIRECTION, (Object)AutomationDirection.INPUT));
    }

    public void setDirection(AutomationDirection direction) {
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.AUTOMATION_DIRECTION, (Object)direction);
        this.save();
    }

    public void setLevel(int level) {
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.LEVEL, (Object)level);
        this.save();
    }

    public int getLevel() {
        return (Integer)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.LEVEL, (Object)10);
    }

    public void setLevelsToStore(int levelsToStore) {
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.LEVELS_TO_STORE, (Object)levelsToStore);
        this.save();
    }

    public int getLevelsToStore() {
        return (Integer)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.LEVELS_TO_STORE, (Object)1);
    }

    public void setLevelsToTake(int levelsToTake) {
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.LEVELS_TO_TAKE, (Object)levelsToTake);
        this.save();
    }

    public int getLevelsToTake() {
        return (Integer)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.LEVELS_TO_TAKE, (Object)1);
    }

    public boolean shouldMendItems() {
        return (Boolean)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.MEND_ITEMS, (Object)true);
    }

    public void setMendItems(boolean mendItems) {
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.MEND_ITEMS, (Object)mendItems);
        this.save();
    }
}

