/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.gdarp.pack_finders;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7670;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public class GlobalPackFinder
implements class_3285 {
    private static final Predicate<Path> IS_VALID_RESOURCE_PACK = pack -> {
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("assets/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("assets/"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static final Predicate<Path> IS_VALID_DATA_PACK = pack -> {
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("data/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("data"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static class_5352 GLOBAL = class_5352.method_45281(name -> name.method_27661().method_27693(" (Global)").method_27692(class_124.field_1075), (boolean)true);
    private static class_5352 GLOBAL_OPT = class_5352.method_45281(name -> name.method_27661().method_27693(" (Global Optional)").method_27692(class_124.field_1062), (boolean)false);
    private final class_3264 packType;
    private final boolean forcedPacks;
    private final ImmutableList<Path> packLocations;

    public GlobalPackFinder(class_3264 packType, boolean required, List<Path> packLocations) {
        this.packType = packType;
        this.forcedPacks = required;
        this.packLocations = ImmutableList.builder().addAll(packLocations).build();
    }

    public void method_14453(Consumer<class_3288> packRegistrar) {
        this.discoverResourcePacks(path -> {
            class_3288.class_7680 resourceSupplier = null;
            resourceSupplier = Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip") ? this.createFilePack((Path)path) : this.createFolderPack((Path)path);
            if (resourceSupplier == null) {
                return;
            }
            class_3288 pack = class_3288.method_45275((class_9224)new class_9224(path.getFileName().toString(), (class_2561)class_2561.method_43470((String)path.getFileName().toString()), this.forcedPacks ? GLOBAL : GLOBAL_OPT, Optional.empty()), (class_3288.class_7680)resourceSupplier, (class_3264)this.packType, (class_9225)new class_9225(this.forcedPacks, class_3288.class_3289.field_14280, true));
            if (pack != null) {
                packRegistrar.accept(pack);
            }
        });
    }

    private class_3288.class_7680 createFilePack(Path path) {
        Object supplier = null;
        FileSystem fs = path.getFileSystem();
        if (this.packType == class_3264.field_14188 && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == class_3264.field_14190 && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        if (fs == FileSystems.getDefault() || fs instanceof class_7670) {
            return new class_3258.class_8615(path);
        }
        return null;
    }

    private class_3288.class_7680 createFolderPack(Path path) {
        if (this.packType == class_3264.field_14188 && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == class_3264.field_14190 && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        return new class_3259.class_8619(path);
    }

    private void discoverResourcePacks(Consumer<Path> packCallback) {
        for (Path path : this.packLocations) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (Files.isRegularFile(path.resolve("pack.mcmeta"), new LinkOption[0])) {
                    packCallback.accept(path);
                    continue;
                }
                try {
                    if (Files.notExists(path, new LinkOption[0])) {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    Stream<Path> fileStream = Files.list(path);
                    try {
                        fileStream.forEach(filePath -> {
                            if (Files.isRegularFile(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0]) && Files.isRegularFile(filePath.resolve("pack.mcmeta"), new LinkOption[0])) {
                                packCallback.accept((Path)filePath);
                            }
                        });
                    }
                    finally {
                        if (fileStream == null) continue;
                        fileStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            packCallback.accept(path);
        }
    }
}

