/*
 * Decompiled with CFR 0.152.
 */
package toni.lib.animation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_2540;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import toni.lib.animation.AnimationEffect;
import toni.lib.animation.AnimationKeyframe;
import toni.lib.animation.Binding;
import toni.lib.animation.PoseUtils;
import toni.lib.animation.Transition;
import toni.lib.animation.easing.EasingType;
import toni.lib.animation.effects.IAnimationEffect;
import toni.lib.utils.ColorUtils;

public class AnimationTimeline {
    public final float duration;
    private float current;
    private AnimationKeyframe effected_keyframe = new AnimationKeyframe();
    private AnimationKeyframe keyframe = new AnimationKeyframe();
    private boolean hasSortedTransitions = false;
    private final HashMap<Binding, List<Transition>> transitions = new HashMap();
    private final HashMap<Binding, List<AnimationEffect>> effects = new HashMap();
    private final Binding[] bindings = Binding.values();

    public static AnimationTimeline builder(float duration) {
        return new AnimationTimeline(duration);
    }

    private AnimationTimeline(float duration) {
        this.duration = duration;
    }

    public void encode(class_2540 buffer) {
        buffer.method_52941(this.duration);
        buffer.method_52941(this.current);
        this.effected_keyframe.encode(buffer);
        this.keyframe.encode(buffer);
        buffer.method_34063(this.transitions, class_2540::method_10817, (buf, val) -> {
            buf.method_10804(val.size());
            val.forEach(i -> i.encode((class_2540)buf));
        });
        buffer.method_34063(this.effects, class_2540::method_10817, (buf, val) -> {
            buf.method_10804(val.size());
            val.forEach(i -> i.encode((class_2540)buf));
        });
    }

    public static AnimationTimeline decode(class_2540 buffer) {
        float duration = buffer.readFloat();
        float current = buffer.readFloat();
        AnimationKeyframe effected_keyframe = AnimationKeyframe.decode(buffer);
        AnimationKeyframe keyframe = AnimationKeyframe.decode(buffer);
        Map transitions = buffer.method_34067(enumClass -> (Binding)buffer.method_10818(Binding.class), buf -> {
            int size = buffer.method_10816();
            ArrayList<Transition> list = new ArrayList<Transition>();
            for (int i = 0; i < size; ++i) {
                list.add(Transition.decode(buf));
            }
            return list;
        });
        Map effects = buffer.method_34067(enumClass -> (Binding)buffer.method_10818(Binding.class), buf -> {
            int size = buffer.method_10816();
            ArrayList<AnimationEffect> list = new ArrayList<AnimationEffect>();
            for (int i = 0; i < size; ++i) {
                list.add(AnimationEffect.decode(buf));
            }
            return list;
        });
        AnimationTimeline ths = new AnimationTimeline(duration);
        ths.current = current;
        ths.effected_keyframe = effected_keyframe;
        ths.keyframe = keyframe;
        ths.transitions.putAll(transitions);
        ths.effects.putAll(effects);
        return ths;
    }

    public AnimationKeyframe getKeyframe() {
        if (!this.hasSortedTransitions) {
            this.hasSortedTransitions = true;
            for (Map.Entry entry : this.transitions.entrySet()) {
                ((List)entry.getValue()).sort((a, b) -> Float.compare(a.getOut(), b.getOut()));
            }
        }
        for (Map.Entry<Binding, List<Transition>> entry : this.transitions.entrySet()) {
            float value = entry.getValue().get(0).getStartValue();
            for (Transition transition : entry.getValue()) {
                switch (transition.getPosition(this.current)) {
                    case DURING: {
                        value = transition.eval(entry.getKey(), this.current);
                        break;
                    }
                    case AFTER: {
                        value = transition.getEndValue();
                    }
                }
            }
            this.keyframe.setValue(entry.getKey(), value);
        }
        for (Binding key : this.bindings) {
            if (!this.effects.containsKey((Object)key)) {
                this.effected_keyframe.setValue(key, this.keyframe.getValue(key));
                continue;
            }
            for (AnimationEffect effect : this.effects.get((Object)key)) {
                if (effect.getPosition(this.current) != IAnimationEffect.Position.DURING) continue;
                this.effected_keyframe.setValue(key, this.keyframe.getValue(key) + effect.type.calculate(effect, this.current));
            }
        }
        return this.effected_keyframe;
    }

    public AnimationKeyframe applyPose(class_332 context, float objectWidth, float objectHeight) {
        AnimationKeyframe key = this.getKeyframe();
        PoseUtils.applyScale(context, key.size);
        PoseUtils.applyPosition(context, key.size, objectWidth, objectHeight, key.posX, key.posY, key.posZ);
        PoseUtils.applyYRotation(context, key.size, objectWidth, objectHeight, key.rotY);
        PoseUtils.applyXRotation(context, key.size, objectWidth, objectHeight, key.rotX);
        PoseUtils.applyZRotation(context, key.size, objectWidth, objectHeight, key.rotZ);
        return key;
    }

    public int getColor() {
        AnimationKeyframe keyframe = this.getKeyframe();
        return ColorUtils.color(class_3532.method_15340((int)((int)(keyframe.alpha * 255.0f + 5.0f)), (int)0, (int)255), ColorUtils.red((int)keyframe.color), ColorUtils.green((int)keyframe.color), ColorUtils.blue((int)keyframe.color));
    }

    public AnimationTimeline advancePlayhead(float delta) {
        this.current = Math.max(0.0f, Math.min(this.current + delta, this.duration));
        return this;
    }

    public AnimationTimeline resetPlayhead(float newPosition) {
        this.current = Math.max(0.0f, Math.min(newPosition, this.duration));
        return this;
    }

    public AnimationTimeline withColor(int alpha, int red, int green, int blue) {
        this.keyframe.color = ColorUtils.color(alpha, red, green, blue);
        return this;
    }

    public AnimationTimeline withXPosition(float x) {
        this.keyframe.posX = x;
        return this;
    }

    public AnimationTimeline withYPosition(float y) {
        this.keyframe.posY = y;
        return this;
    }

    public AnimationTimeline withZPosition(float z) {
        this.keyframe.posZ = z;
        return this;
    }

    public AnimationTimeline withXRotation(float x) {
        this.keyframe.rotX = x;
        return this;
    }

    public AnimationTimeline withYRotation(float y) {
        this.keyframe.rotY = y;
        return this;
    }

    public AnimationTimeline withZRotation(float z) {
        this.keyframe.rotZ = z;
        return this;
    }

    public AnimationTimeline withSize(float size) {
        this.keyframe.size = size;
        return this;
    }

    public AnimationTimeline transition(Binding binding, float in, float out, float start, float end, EasingType easing) {
        Transition transition = new Transition(in, out, easing, start, end);
        if (!this.transitions.containsKey((Object)binding)) {
            this.transitions.put(binding, new ArrayList());
        }
        this.transitions.get((Object)binding).add(transition);
        return this;
    }

    public AnimationTimeline fadeout(float time) {
        return this.transition(Binding.Alpha, this.duration - time, this.duration, 1.0f, 0.0f, EasingType.EaseOutSine);
    }

    public AnimationTimeline fadeout(float time, EasingType easing) {
        return this.transition(Binding.Alpha, this.duration - time, this.duration, 1.0f, 0.0f, easing);
    }

    public AnimationTimeline fadein(float time) {
        return this.transition(Binding.Alpha, 0.0f, time, 0.0f, 1.0f, EasingType.EaseOutSine);
    }

    public AnimationTimeline fadein(float time, EasingType easing) {
        return this.transition(Binding.Alpha, 0.0f, time, 0.0f, 1.0f, easing);
    }

    public AnimationTimeline shake(float time) {
        this.transition(Binding.zRot, time, time + 0.1f, 0.0f, 5.0f, EasingType.EaseInBounce);
        this.transition(Binding.Size, time, time + 0.1f, 1.0f, 1.1f, EasingType.EaseInCubic);
        this.transition(Binding.Size, time + 0.1f, time + 0.2f, 1.0f, 1.0f, EasingType.EaseOutCubic);
        return this.transition(Binding.zRot, time, time + 0.2f, 5.0f, 0.0f, EasingType.EaseOutBounce);
    }

    public AnimationTimeline waveEffect(Binding binding, float intensity, float speed, float in, float out) {
        if (!this.effects.containsKey((Object)binding)) {
            this.effects.put(binding, new ArrayList());
        }
        this.effects.get((Object)binding).add(new AnimationEffect(in, out, intensity, speed, AnimationEffect.Type.WAVE));
        return this;
    }

    public AnimationTimeline waveEffect(Binding binding, float intensity, float speed) {
        return this.waveEffect(binding, intensity, speed, 0.0f, this.duration);
    }

    public AnimationTimeline waveEffect() {
        return this.waveEffect(Binding.zRot, 2.5f, 5.0f, 0.0f, this.duration);
    }

    @Generated
    public float getCurrent() {
        return this.current;
    }

    @Generated
    public void setCurrent(float current) {
        this.current = current;
    }
}

