/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.components.ExpComponent;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.ClaimPriority;
import com.b1n_ry.yigd.config.DropType;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.DirectionalPos;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.GraveyardData;
import com.b1n_ry.yigd.data.TimePoint;
import com.b1n_ry.yigd.events.AllowBlockUnderGraveGenerationEvent;
import com.b1n_ry.yigd.events.AllowGraveGenerationEvent;
import com.b1n_ry.yigd.events.GraveClaimEvent;
import com.b1n_ry.yigd.events.GraveGenerationEvent;
import com.b1n_ry.yigd.networking.LightGraveData;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.YigdTags;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GraveComponent {
    private final class_9296 owner;
    private InventoryComponent inventoryComponent;
    private ExpComponent expComponent;
    @Nullable
    private class_3218 world;
    private class_5321<class_1937> worldRegistryKey;
    private class_2338 pos;
    private final class_2561 deathMessage;
    private final UUID graveId;
    private GraveStatus status;
    private boolean locked;
    private final TimePoint creationTime;
    private final UUID killerId;
    public static GraveyardData graveyardData = null;
    public static final class_9331<UUID> GRAVE_ID = class_9331.method_57873().method_57881(class_4844.field_25122).method_57882(class_4844.field_48453).method_57880();

    public GraveComponent(class_9296 owner, InventoryComponent inventoryComponent, ExpComponent expComponent, class_3218 world, class_243 pos, class_2561 deathMessage, UUID killerId) {
        this(owner, inventoryComponent, expComponent, world, class_2338.method_49638((class_2374)pos), deathMessage, UUID.randomUUID(), GraveStatus.UNCLAIMED, true, new TimePoint(world), killerId);
    }

    public GraveComponent(class_9296 owner, InventoryComponent inventoryComponent, ExpComponent expComponent, class_3218 world, class_2338 pos, class_2561 deathMessage, UUID graveId, GraveStatus status, boolean locked, TimePoint creationTime, UUID killerId) {
        this.owner = owner;
        this.inventoryComponent = inventoryComponent;
        this.expComponent = expComponent;
        this.world = world;
        this.worldRegistryKey = world.method_27983();
        this.pos = pos;
        this.deathMessage = deathMessage;
        this.graveId = graveId;
        this.status = status;
        this.locked = locked;
        this.creationTime = creationTime;
        this.killerId = killerId;
    }

    public GraveComponent(class_9296 owner, InventoryComponent inventoryComponent, ExpComponent expComponent, class_5321<class_1937> worldKey, class_2338 pos, class_2561 deathMessage, UUID graveId, GraveStatus status, boolean locked, TimePoint creationTime, UUID killerId) {
        this.owner = owner;
        this.inventoryComponent = inventoryComponent;
        this.expComponent = expComponent;
        this.world = null;
        this.worldRegistryKey = worldKey;
        this.pos = pos;
        this.deathMessage = deathMessage;
        this.graveId = graveId;
        this.status = status;
        this.locked = locked;
        this.creationTime = creationTime;
        this.killerId = killerId;
    }

    public class_9296 getOwner() {
        return this.owner;
    }

    public InventoryComponent getInventoryComponent() {
        return this.inventoryComponent;
    }

    public void setInventoryComponent(InventoryComponent inventoryComponent) {
        this.inventoryComponent = inventoryComponent;
        DeathInfoManager.INSTANCE.method_80();
    }

    public ExpComponent getExpComponent() {
        return this.expComponent;
    }

    public void setExpComponent(ExpComponent expComponent) {
        this.expComponent = expComponent;
        DeathInfoManager.INSTANCE.method_80();
    }

    @Nullable
    public class_3218 getWorld() {
        return this.world;
    }

    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2561 getDeathMessage() {
        return this.deathMessage;
    }

    public UUID getGraveId() {
        return this.graveId;
    }

    public GraveStatus getStatus() {
        return this.status;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public TimePoint getCreationTime() {
        return this.creationTime;
    }

    public UUID getKillerId() {
        return this.killerId;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        DeathInfoManager.INSTANCE.method_80();
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
        DeathInfoManager.INSTANCE.method_80();
    }

    public void setWorld(class_3218 world) {
        this.world = world;
        this.worldRegistryKey = world.method_27983();
    }

    public void setStatus(GraveStatus status) {
        if (this.status == GraveStatus.UNCLAIMED && YigdConfig.getConfig().extraFeatures.graveCompass.pointToClosest != YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.DISABLED) {
            GraveCompassHelper.setClaimed(this.worldRegistryKey, this.pos);
        }
        this.status = status;
        DeathInfoManager.INSTANCE.method_80();
    }

    public boolean isGraveEmpty() {
        return this.inventoryComponent.isGraveEmpty() && this.expComponent.isEmpty();
    }

    public boolean isEmpty() {
        return this.inventoryComponent.isEmpty() && this.expComponent.isEmpty();
    }

    public DirectionalPos findGravePos(class_2350 defaultDirection) {
        DirectionalPos graveyardPos;
        class_2784 border;
        int topY;
        if (this.world == null) {
            Yigd.LOGGER.error("GraveComponent's associated world is null. Failed to find suitable position");
            return new DirectionalPos(this.pos, defaultDirection);
        }
        YigdConfig config = YigdConfig.getConfig();
        int y = this.pos.method_10264();
        int lowerAcceptableY = config.graveConfig.lowestGraveY + this.world.method_31607();
        if (config.graveConfig.generateGraveInVoid && this.pos.method_10264() <= lowerAcceptableY) {
            y = lowerAcceptableY;
        }
        if (y > (topY = this.world.method_31600() - 1)) {
            y = topY;
        }
        int x = this.pos.method_10263();
        int z = this.pos.method_10260();
        if (config.graveConfig.generateOnlyWithinBorder && !(border = this.world.method_8621()).method_35317((double)x, (double)z)) {
            x = (int)Math.max((double)x, border.method_11976());
            x = (int)Math.min((double)x, border.method_11963());
            z = (int)Math.max((double)z, border.method_11958());
            z = (int)Math.min((double)z, border.method_11977());
        }
        this.pos = new class_2338(x, y, z);
        if (this.world.method_27983().equals(class_1937.field_25181) && Math.abs(this.pos.method_10263()) + Math.abs(this.pos.method_10260()) < 25 && this.world.method_8320(this.pos.method_10074()).method_27852(class_2246.field_9987)) {
            this.pos = this.pos.method_10084();
        }
        if ((graveyardPos = this.findPosInGraveyard(defaultDirection)) != null) {
            return graveyardPos;
        }
        YigdConfig.GraveConfig.Range generationMaxDistance = config.graveConfig.generationMaxDistance;
        if (config.graveConfig.tryGenerateOnGround) {
            class_2338 pos = this.pos.method_10074();
            while (pos.method_10264() >= this.world.method_31607()) {
                if (!this.world.method_8320(pos).method_26164(YigdTags.REPLACE_SOFT_WHITELIST)) {
                    this.pos = pos.method_10074();
                    break;
                }
                pos = pos.method_10074();
            }
        }
        DeathInfoManager.INSTANCE.method_80();
        for (int i = 0; i < 50; ++i) {
            for (class_2338 iPos : class_2338.method_25996((class_2338)this.pos, (int)generationMaxDistance.x, (int)generationMaxDistance.y, (int)generationMaxDistance.z)) {
                if (!((GraveGenerationEvent)GraveGenerationEvent.EVENT.invoker()).canGenerateAt(this.world, iPos, i)) continue;
                this.pos = iPos;
                DeathInfoManager.INSTANCE.method_80();
                return new DirectionalPos(iPos, defaultDirection);
            }
        }
        return new DirectionalPos(this.pos, defaultDirection);
    }

    private DirectionalPos findPosInGraveyard(class_2350 defaultDirection) {
        if (this.world == null) {
            return null;
        }
        if (graveyardData == null || GraveComponent.graveyardData.graveLocations.isEmpty()) {
            return null;
        }
        MinecraftServer server = this.world.method_8503();
        class_3218 graveyardWorld = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)GraveComponent.graveyardData.dimensionId));
        if (graveyardWorld == null) {
            graveyardWorld = server.method_30002();
        }
        DirectionalPos closest = null;
        for (GraveyardData.GraveLocation location : GraveComponent.graveyardData.graveLocations) {
            Optional maybeName = this.owner.comp_2410();
            if (location.forPlayer != null && !location.forPlayer.equalsIgnoreCase(maybeName.orElse(""))) continue;
            class_2350 direction = location.direction != null ? location.direction : defaultDirection;
            DirectionalPos maybePos = new DirectionalPos(location.x, location.y, location.z, direction);
            if (GraveComponent.graveyardData.useClosest) {
                if (closest != null && !(maybePos.getSquaredDistance((class_2382)this.pos) < closest.getSquaredDistance((class_2382)this.pos))) continue;
                closest = maybePos;
                continue;
            }
            closest = maybePos;
            break;
        }
        if (closest != null) {
            this.world = graveyardWorld;
            this.pos = closest.pos();
            return closest;
        }
        return null;
    }

    public boolean tryPlaceGrave(class_2680 state) {
        if (this.world == null) {
            Yigd.LOGGER.error("GraveComponent tried to place grave without knowing the ServerWorld");
            return false;
        }
        this.placeBlockUnder();
        return this.world.method_8501(this.pos, state);
    }

    public void placeAndLoad(class_2350 direction, DeathContext context, class_2338 pos, RespawnComponent respawnComponent) {
        YigdConfig config = YigdConfig.getConfig();
        class_3218 world = context.world();
        class_243 deathPos = context.deathPos();
        if (!config.graveConfig.storeItems) {
            this.inventoryComponent.dropGraveItems(world, deathPos);
        }
        if (!config.graveConfig.storeXp) {
            this.expComponent.dropAll(world, deathPos);
            this.getExpComponent().clear();
        }
        boolean waterlogged = world.method_8316(pos).method_39360((class_3611)class_3612.field_15910);
        class_2680 graveBlock = (class_2680)((class_2680)Yigd.GRAVE_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)direction)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged));
        Yigd.END_OF_TICK.add(() -> {
            class_2680 previousState = world.method_8320(pos);
            boolean placed = this.tryPlaceGrave(graveBlock);
            class_2338 placedPos = this.getPos();
            if (!placed) {
                Yigd.LOGGER.error("Failed to generate grave at X: {}, Y: {}, Z: {}, {}. Grave block placement failed", new Object[]{placedPos.method_10263(), placedPos.method_10264(), placedPos.method_10260(), world.method_27983().method_29177()});
                Yigd.LOGGER.info("Dropping items on ground instead of in grave");
                context.player().method_43496((class_2561)class_2561.method_43471((String)"text.yigd.message.grave_generation_error"));
                this.getInventoryComponent().dropGraveItems(world, class_243.method_24954((class_2382)placedPos));
                this.getExpComponent().dropAll(world, class_243.method_24954((class_2382)placedPos));
                return;
            }
            respawnComponent.setGraveGenerated(true);
            DeathInfoManager.INSTANCE.method_80();
            GraveBlockEntity be = (GraveBlockEntity)world.method_8321(placedPos);
            if (be == null) {
                return;
            }
            be.setPreviousState(previousState);
            be.setComponent(this);
        });
    }

    public void generateOrDrop(class_2350 playerDirection, DeathContext context, RespawnComponent respawnComponent) {
        class_3218 world = context.world();
        class_243 pos = context.deathPos();
        boolean canGenerate = ((AllowGraveGenerationEvent)AllowGraveGenerationEvent.EVENT.invoker()).allowGeneration(context, this);
        if (YigdConfig.getConfig().inventoryConfig.itemLoss.enabled) {
            this.inventoryComponent.applyLoss();
        }
        if (!canGenerate) {
            this.inventoryComponent.dropGraveItems(world, pos);
            this.expComponent.dropAll(world, pos);
        } else {
            DirectionalPos dirGravePos = this.findGravePos(playerDirection);
            class_2338 gravePos = dirGravePos.pos();
            class_2350 direction = dirGravePos.dir();
            class_3218 graveWorld = this.getWorld();
            assert (graveWorld != null);
            this.placeAndLoad(direction, context, gravePos, respawnComponent);
        }
    }

    private void placeBlockUnder() {
        String blockName;
        if (this.world == null) {
            Yigd.LOGGER.error("Tried to place block under a grave but world was null");
            return;
        }
        YigdConfig.GraveConfig.BlockUnderGrave config = YigdConfig.getConfig().graveConfig.blockUnderGrave;
        if (!config.enabled) {
            return;
        }
        class_2680 currentUnder = this.world.method_8320(this.pos.method_10074());
        if (!((AllowBlockUnderGraveGenerationEvent)AllowBlockUnderGraveGenerationEvent.EVENT.invoker()).allowBlockGeneration(this, currentUnder)) {
            return;
        }
        HashMap<String, String> blockInDimMap = new HashMap<String, String>();
        for (YigdConfig.MapEntry pair : config.blockInDimensions) {
            blockInDimMap.put(pair.key, pair.value);
        }
        String dimName = this.worldRegistryKey.method_29177().toString();
        if (!blockInDimMap.containsKey(dimName)) {
            dimName = "misc";
        }
        if ((blockName = (String)blockInDimMap.get(dimName)) == null) {
            Yigd.LOGGER.warn("Didn't place supporting block under grave in {}, at {}, {}, {}. Couldn't find dimension key in config", new Object[]{this.worldRegistryKey.method_29177(), this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
            return;
        }
        class_2248 blockUnder = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockName));
        boolean placed = this.world.method_8501(this.pos.method_10074(), blockUnder.method_9564());
        if (!placed) {
            Yigd.LOGGER.warn("Didn't place supporting block under grave in {}, at {}, {}, {}. Block placement failed", new Object[]{this.worldRegistryKey.method_29177(), this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
        }
    }

    public boolean replaceWithOld(class_2680 newState) {
        if (this.world == null) {
            return false;
        }
        if (newState.method_26164(YigdTags.REPLACE_GRAVE_BLACKLIST)) {
            return false;
        }
        boolean placed = this.world.method_8501(this.pos, newState);
        newState.method_26204().method_9567((class_1937)this.world, this.pos, newState, null, class_1799.field_8037);
        return placed;
    }

    public void backUp() {
        DeathInfoManager.INSTANCE.addBackup(this.owner, this);
        DeathInfoManager.INSTANCE.method_80();
    }

    public boolean hasExistedTicks(long time) {
        if (this.world == null) {
            return false;
        }
        return this.world.method_8510() - this.creationTime.getTime() >= time;
    }

    public String getTimeUntilRobbable() {
        if (this.world == null) {
            return "0";
        }
        int tps = 20;
        YigdConfig.GraveConfig.GraveRobbing robConfig = YigdConfig.getConfig().graveConfig.graveRobbing;
        long delay = robConfig.timeUnit.toSeconds(robConfig.afterTime) * 20L;
        long timePassed = (this.creationTime.getTime() - this.world.method_8510() + delay) / 20L;
        long seconds = timePassed % 60L;
        long minutes = timePassed / 60L % 60L;
        long hours = timePassed / 3600L;
        return "%02d:%02d:%02d".formatted(hours, minutes, seconds);
    }

    public class_1269 claim(class_3222 player, class_3218 world, class_2680 previousState, class_2338 pos, class_1799 tool) {
        YigdConfig config = YigdConfig.getConfig();
        if (this.status == GraveStatus.CLAIMED) {
            return class_1269.field_5814;
        }
        if (!((GraveClaimEvent)GraveClaimEvent.EVENT.invoker()).canClaim(player, world, pos, this, tool)) {
            return class_1269.field_5814;
        }
        this.handleRandomSpawn(config.graveConfig.randomSpawn, world, player.method_7334());
        boolean thisIsARobbery = !player.method_5667().equals(this.owner.comp_2411().orElse(null));
        class_1799 graveItem = new class_1799((class_1935)Yigd.GRAVE_BLOCK.method_8389());
        boolean addGraveItem = config.graveConfig.dropGraveBlock;
        if (config.graveConfig.dropOnRetrieve == DropType.IN_INVENTORY) {
            this.applyToPlayer(player, world, pos.method_46558(), !thisIsARobbery);
            if (addGraveItem) {
                player.method_7270(graveItem);
            }
        } else if (config.graveConfig.dropOnRetrieve == DropType.ON_GROUND) {
            this.dropAll();
            if (this.world != null && addGraveItem) {
                InventoryComponent.dropItemIfToBeDropped(graveItem, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), this.world);
            }
        }
        this.setStatus(GraveStatus.CLAIMED);
        if (!config.graveConfig.persistentGraves.enabled) {
            if (config.graveConfig.replaceOldWhenClaimed && previousState != null) {
                this.replaceWithOld(previousState);
            } else {
                world.method_8650(pos, false);
            }
        } else {
            GraveBlockEntity be = (GraveBlockEntity)world.method_8321(pos);
            if (be != null) {
                class_2680 state = world.method_8320(pos);
                be.setClaimed(true);
                be.method_5431();
                world.method_8413(pos, state, state, 3);
            }
        }
        if (thisIsARobbery && config.graveConfig.graveRobbing.notifyWhenRobbed) {
            MinecraftServer server = world.method_8503();
            String robberName = player.method_7334().getName();
            Optional ownerId = this.owner.comp_2411();
            class_3222 robbedPlayer = ownerId.map(value -> server.method_3760().method_14602(value)).orElse(null);
            if (robbedPlayer != null) {
                if (config.graveConfig.graveRobbing.tellWhoRobbed) {
                    robbedPlayer.method_43496((class_2561)class_2561.method_43469((String)"text.yigd.message.inform_robbery.with_details", (Object[])new Object[]{player.method_7334().getName()}));
                } else {
                    robbedPlayer.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.message.inform_robbery"));
                }
            } else {
                ownerId.ifPresent(value -> Yigd.NOT_NOTIFIED_ROBBERIES.computeIfAbsent((UUID)value, uuid -> new ArrayList()).add(robberName));
            }
        }
        Yigd.LOGGER.info("{} claimed a grave belonging to {} at {}, {}, {}, {}", new Object[]{player.method_7334().getName(), this.owner.comp_2410().orElse("PLAYER_NOT_FOUND"), this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), this.worldRegistryKey.method_29177()});
        return class_1269.field_5812;
    }

    public boolean removeGraveBlock() {
        if (this.status == GraveStatus.UNCLAIMED) {
            this.setStatus(GraveStatus.DESTROYED);
        }
        if (this.world == null) {
            return false;
        }
        class_2586 class_25862 = this.world.method_8321(this.pos);
        if (!(class_25862 instanceof GraveBlockEntity)) {
            return false;
        }
        GraveBlockEntity grave = (GraveBlockEntity)class_25862;
        class_2680 previousState = grave.getPreviousState();
        if (previousState == null) {
            return this.world.method_8650(this.pos, false);
        }
        return this.replaceWithOld(previousState);
    }

    private void handleRandomSpawn(YigdConfig.GraveConfig.RandomSpawn config, class_3218 world, GameProfile looter) {
        String res;
        Pattern pattern;
        Matcher matcher;
        Pattern nbtPattern;
        Matcher nbtMatcher;
        if (config.percentSpawnChance <= world.field_9229.method_43048(100)) {
            return;
        }
        class_2495 ownerIdNbt = this.owner.comp_2411().map(class_2512::method_25929).orElse(new class_2495(new int[0]));
        class_2495 looterIdNbt = class_2512.method_25929((UUID)looter.getId());
        String summonNbt = config.spawnNbt.replaceAll("\\$\\{owner\\.name}", this.owner.comp_2410().orElse("Steve")).replaceAll("\\$\\{owner\\.uuid}", ownerIdNbt.toString()).replaceAll("\\$\\{looter\\.name}", looter.getName()).replaceAll("\\$\\{looter\\.uuid}", looterIdNbt.toString());
        class_2371<class_3545<class_1799, DropRule>> items = this.inventoryComponent.getItems();
        while ((nbtMatcher = (nbtPattern = Pattern.compile("\\$\\{!?item\\[[0-9]+]}")).matcher(summonNbt)).find() && (matcher = (pattern = Pattern.compile("(?<=\\$\\{!?item\\[)[0-9]+(?=]})")).matcher(summonNbt)).find() && (res = matcher.group()).matches("[0-9]+")) {
            int itemNumber = Integer.parseInt(res);
            class_1799 item = (class_1799)((class_3545)items.get(itemNumber)).method_15442();
            class_2487 itemNbt = (class_2487)item.method_57358((class_7225.class_7874)world.method_30349());
            boolean removeItem = summonNbt.contains("${!item[" + itemNumber + "]}");
            summonNbt = summonNbt.replaceAll("\\$\\{!?item\\[" + itemNumber + "]}", itemNbt.toString());
            if (removeItem) {
                items.set(itemNumber, (Object)new class_3545((Object)class_1799.field_8037, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule));
            }
            if (nbtMatcher.find()) continue;
        }
        try {
            class_2487 nbt = class_2512.method_32260((String)summonNbt);
            nbt.method_10582("id", config.spawnEntity);
            class_1297 entity = class_1299.method_17842((class_2487)nbt, (class_1937)world, e -> {
                e.method_5725(this.pos, e.method_36454(), e.method_36455());
                return e;
            });
            world.method_8649(entity);
        }
        catch (CommandSyntaxException e2) {
            Yigd.LOGGER.error("Failed spawning entity on grave", (Throwable)e2);
        }
    }

    public void applyToPlayer(class_3222 player, class_3218 world, class_243 pos, boolean isGraveOwner) {
        this.applyToPlayer(player, world, pos, isGraveOwner, dropRule -> dropRule == DropRule.PUT_IN_GRAVE);
    }

    public void applyToPlayer(class_3222 player, class_3218 world, class_243 pos, boolean isGraveOwner, Predicate<DropRule> itemFilter) {
        YigdConfig config = YigdConfig.getConfig();
        this.expComponent.applyToPlayer(player);
        InventoryComponent currentPlayerInv = new InventoryComponent(player);
        InventoryComponent.clearPlayer(player);
        class_2371 extraItems = class_2371.method_10211();
        UUID playerId = player.method_5667();
        ClaimPriority claimPriority = Yigd.CLAIM_PRIORITIES.containsKey(playerId) ? Yigd.CLAIM_PRIORITIES.get(playerId) : config.graveConfig.claimPriority;
        ClaimPriority robPriority = Yigd.ROB_PRIORITIES.containsKey(playerId) ? Yigd.CLAIM_PRIORITIES.get(playerId) : config.graveConfig.graveRobbing.robPriority;
        ClaimPriority priority = isGraveOwner ? claimPriority : robPriority;
        InventoryComponent graveInv = this.inventoryComponent.filteredInv(itemFilter);
        if (config.graveConfig.treatBindingCurse) {
            extraItems.addAll(graveInv.pullBindingCurseItems(player));
        }
        if (priority == ClaimPriority.GRAVE) {
            extraItems.addAll(graveInv.merge(currentPlayerInv, player));
            extraItems.addAll(graveInv.applyToPlayer(player));
        } else {
            extraItems.addAll(currentPlayerInv.merge(graveInv, player));
            extraItems.addAll(currentPlayerInv.applyToPlayer(player));
        }
        for (class_1799 stack : extraItems) {
            if (player.method_7270(stack)) continue;
            double x = pos.method_10216();
            double y = pos.method_10214();
            double z = pos.method_10215();
            InventoryComponent.dropItemIfToBeDropped(stack, x, y, z, world);
        }
    }

    public void dropAll() {
        this.inventoryComponent.dropAll(this.world, this.pos.method_46558());
        this.expComponent.dropAll(this.world, this.pos.method_46558());
    }

    public void onDestroyed() {
        this.setStatus(GraveStatus.DESTROYED);
        if (this.world == null) {
            return;
        }
        class_3324 playerManager = this.world.method_8503().method_3760();
        class_3222 owner = this.owner.comp_2411().map(arg_0 -> ((class_3324)playerManager).method_14602(arg_0)).orElse(null);
        if (owner == null) {
            return;
        }
        YigdConfig config = YigdConfig.getConfig();
        Yigd.LOGGER.info("Grave belonging to {} was detected destroyed at X: {}, Y: {}, Z: {} / {}", new Object[]{owner.method_7334().getName(), this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), this.worldRegistryKey.method_29177()});
        if (config.graveConfig.notifyOwnerIfDestroyed) {
            owner.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.message.grave_destroyed"));
        }
        if (YigdConfig.getConfig().graveConfig.dropItemsIfDestroyed) {
            this.dropAll();
        }
    }

    public LightGraveData toLightData() {
        return new LightGraveData(this.inventoryComponent.graveSize(), this.pos, this.expComponent.getStoredXp(), this.worldRegistryKey, this.deathMessage, this.graveId, this.status);
    }

    public class_2487 toNbt(class_7225.class_7874 lookupRegistry) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("owner", (class_2520)class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.owner).getOrThrow());
        nbt.method_10566("inventory", (class_2520)this.inventoryComponent.toNbt(lookupRegistry));
        nbt.method_10566("exp", (class_2520)this.expComponent.toNbt());
        nbt.method_10566("world", (class_2520)this.getWorldRegistryKeyNbt(this.worldRegistryKey));
        nbt.method_10566("pos", class_2512.method_10692((class_2338)this.pos));
        nbt.method_10582("deathMessage", class_2561.class_2562.method_10867((class_2561)this.deathMessage, (class_7225.class_7874)lookupRegistry));
        nbt.method_25927("graveId", this.graveId);
        nbt.method_10582("status", this.status.toString());
        nbt.method_10556("locked", this.locked);
        nbt.method_10566("creationTime", (class_2520)this.creationTime.toNbt());
        if (this.killerId != null) {
            nbt.method_25927("killerId", this.killerId);
        }
        return nbt;
    }

    private class_2487 getWorldRegistryKeyNbt(class_5321<?> key) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("registry", key.method_41185().toString());
        nbt.method_10582("value", key.method_29177().toString());
        return nbt;
    }

    public static GraveComponent fromNbt(class_2487 nbt, class_7225.class_7874 lookupRegistry, @Nullable MinecraftServer server) {
        class_3218 world;
        UUID killerId;
        if (nbt == null) {
            return null;
        }
        class_9296 owner = (class_9296)class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("owner")).getOrThrow();
        InventoryComponent inventoryComponent = InventoryComponent.fromNbt(nbt.method_10562("inventory"), lookupRegistry);
        ExpComponent expComponent = ExpComponent.fromNbt(nbt.method_10562("exp"));
        class_5321<class_1937> worldKey = GraveComponent.getRegistryKeyFromNbt(nbt.method_10562("world"));
        Optional pos = class_2512.method_10691((class_2487)nbt, (String)"pos");
        class_5250 deathMessage = class_2561.class_2562.method_10877((String)nbt.method_10558("deathMessage"), (class_7225.class_7874)lookupRegistry);
        UUID graveId = nbt.method_25926("graveId");
        GraveStatus status = GraveStatus.valueOf(nbt.method_10558("status"));
        boolean locked = nbt.method_10577("locked");
        TimePoint creationTime = TimePoint.fromNbt(nbt.method_10562("creationTime"));
        UUID uUID = killerId = nbt.method_10545("killerId") ? nbt.method_25926("killerId") : null;
        if (server != null && (world = server.method_3847(worldKey)) != null) {
            return new GraveComponent(owner, inventoryComponent, expComponent, world, pos.orElse(class_2338.field_10980), (class_2561)deathMessage, graveId, status, locked, creationTime, killerId);
        }
        return new GraveComponent(owner, inventoryComponent, expComponent, worldKey, pos.orElse(class_2338.field_10980), (class_2561)deathMessage, graveId, status, locked, creationTime, killerId);
    }

    private static class_5321<class_1937> getRegistryKeyFromNbt(class_2487 nbt) {
        String registry = nbt.method_10558("registry");
        String value = nbt.method_10558("value");
        class_5321 r = class_5321.method_29180((class_2960)class_2960.method_60654((String)registry));
        return class_5321.method_29179((class_5321)r, (class_2960)class_2960.method_60654((String)value));
    }
}

