/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.config;

import com.b1n_ry.yigd.config.ClaimPriority;
import com.b1n_ry.yigd.config.DropType;
import com.b1n_ry.yigd.config.ExpDropBehaviour;
import com.b1n_ry.yigd.util.DropRule;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="yigd")
public class YigdConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public InventoryConfig inventoryConfig = new InventoryConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public ExpConfig expConfig = new ExpConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public GraveConfig graveConfig = new GraveConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public RespawnConfig respawnConfig = new RespawnConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public CompatConfig compatConfig = new CompatConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public CommandConfig commandConfig = new CommandConfig();
    @Comment(value="Client only config")
    @ConfigEntry.Gui.CollapsibleObject
    public GraveRendering graveRendering = new GraveRendering();
    @Comment(value="Toggleable custom features (registries)")
    @ConfigEntry.Gui.CollapsibleObject
    public ExtraFeatures extraFeatures = new ExtraFeatures();

    public static YigdConfig getConfig() {
        return (YigdConfig)AutoConfig.getConfigHolder(YigdConfig.class).getConfig();
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        super.validatePostLoad();
    }

    public static class InventoryConfig {
        public boolean dropPlayerHead = false;
        @ConfigEntry.Gui.CollapsibleObject
        public ItemLossConfig itemLoss = new ItemLossConfig();
        public boolean loseSoulboundLevelOnDeath = false;
        public List<Integer> vanishingSlots = new ArrayList<Integer>();
        public List<Integer> soulboundSlots = new ArrayList<Integer>();
        public List<Integer> dropOnGroundSlots = new ArrayList<Integer>();

        public static class ItemLossConfig {
            public boolean enabled = false;
            public boolean affectStacks = false;
            public boolean usePercentRange = true;
            public int lossRangeFrom = 0;
            public int lossRangeTo = 100;
            @Comment(value="Chance of losing an item (iterated over every item picked up by lossRange)")
            public int percentChanceOfLoss = 50;
            @Comment(value="If true, you can lose soulbound items from the item loss feature")
            public boolean canLoseSoulbound = false;
            public boolean includeModdedInventories = true;
        }
    }

    public static class ExpConfig {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ExpDropBehaviour dropBehaviour = ExpDropBehaviour.BEST_OF_BOTH;
        @Comment(value="Ignored if dropBehaviour is set to VANILLA")
        @ConfigEntry.BoundedDiscrete(max=100L)
        public int dropPercentage = 0;
        @ConfigEntry.BoundedDiscrete(max=100L)
        public int keepPercentage = 0;
    }

    public static class GraveConfig {
        public boolean enabled = true;
        public boolean storeItems = true;
        public boolean storeXp = true;
        @Comment(value="Inform player where the grave generated when respawning")
        public boolean informGraveLocation = true;
        @Comment(value="If true, you HAVE to have `requiredItemCount` number of `requiredItem` for a grave to generate. That many of that item will then be consumed")
        public boolean requireItem = false;
        public String requiredItem = "yigd:grave";
        public int requiredItemCount = 1;
        public boolean requireShovelToLoot = false;
        @ConfigEntry.Gui.CollapsibleObject
        public RetrieveMethods retrieveMethods = new RetrieveMethods();
        public boolean mergeStacksOnRetrieve = true;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropType dropOnRetrieve = DropType.IN_INVENTORY;
        public boolean dropGraveBlock = false;
        public boolean generateEmptyGraves = false;
        @Comment(value="Allows everyone to bypass spawn protection for grave blocks")
        public boolean overrideSpawnProtection = true;
        @Comment(value="Which of the layout in the grave or in your inventory should be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ClaimPriority claimPriority = ClaimPriority.GRAVE;
        @ConfigEntry.Gui.CollapsibleObject
        public GraveRobbing graveRobbing = new GraveRobbing();
        @ConfigEntry.Gui.CollapsibleObject
        public GraveTimeout graveTimeout = new GraveTimeout();
        @Comment(value="If false, layout prioritizing doesn't care if armor is cursed with binding")
        public boolean treatBindingCurse = true;
        public boolean generateGraveInVoid = true;
        @Comment(value="Minimum amount of blocks above void a grave can spawn")
        public int lowestGraveY = 3;
        public boolean generateOnlyWithinBorder = true;
        public List<String> ignoredDeathTypes = new ArrayList<String>();
        @Comment(value="Allow players to unlock their graves through GUI")
        public boolean unlockable = true;
        @ConfigEntry.Gui.CollapsibleObject
        public RandomSpawn randomSpawn = new RandomSpawn();
        public boolean generateOnLastGroundPos = false;
        public boolean tryGenerateOnGround = false;
        @ConfigEntry.Gui.CollapsibleObject
        public Range generationMaxDistance = new Range();
        public boolean useSoftBlockWhitelist = false;
        public boolean useStrictBlockBlacklist = true;
        public boolean replaceOldWhenClaimed = true;
        public boolean dropItemsIfDestroyed = false;
        public boolean notifyOwnerIfDestroyed = true;
        @Comment(value="If true, graves will persist when claiming them, and right clicking on them after that will let you know when and how they died. Can also then be mined")
        @ConfigEntry.Gui.CollapsibleObject
        public PersistentGraves persistentGraves = new PersistentGraves();
        public List<String> dimensionBlacklist = new ArrayList<String>();
        @ConfigEntry.Gui.CollapsibleObject
        public BlockUnderGrave blockUnderGrave = new BlockUnderGrave();
        @Comment(value="When people leave, should the game let everyone know where they have a grave?")
        public boolean sellOutOfflinePeople = false;
        @Comment(value="Max amount of backed up graves")
        public int maxBackupsPerPerson = 100;
        public boolean dropFromOldestWhenDeleted = true;

        public static class RetrieveMethods {
            public boolean onClick = true;
            public boolean onBreak = false;
            public boolean onSneak = false;
            public boolean onStand = false;
        }

        public static class GraveRobbing {
            public boolean enabled = true;
            public boolean killerSkipWaitTime = false;
            public int afterTime = 1;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public TimeUnit timeUnit = TimeUnit.HOURS;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public ClaimPriority robPriority = ClaimPriority.INVENTORY;
            public boolean notifyWhenRobbed = true;
            public boolean tellWhoRobbed = true;
        }

        public static class GraveTimeout {
            public boolean enabled = false;
            public int afterTime = 5;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public TimeUnit timeUnit = TimeUnit.HOURS;
            public boolean dropContentsOnTimeout = true;
        }

        public static class RandomSpawn {
            public int percentSpawnChance = 0;
            public String spawnEntity = "minecraft:zombie";
            public String spawnNbt = "{ArmorItems:[{},{},{},{id:\"minecraft:player_head\",components:{\"minecraft:profile\":{name:\"${owner.name}\",id:${owner.uuid}}}}]}";
        }

        public static class Range {
            public int x = 5;
            public int y = 5;
            public int z = 5;
        }

        public static class PersistentGraves {
            public boolean enabled = false;
            public boolean showDeathDay = true;
            public boolean showDeathIrlTime = true;
            public boolean useAmPm = true;
        }

        public static class BlockUnderGrave {
            public boolean enabled = true;
            public List<MapEntry> blockInDimensions = new ArrayList<MapEntry>(){
                {
                    this.add(new MapEntry("minecraft:overworld", "minecraft:cobblestone"));
                    this.add(new MapEntry("minecraft:the_nether", "minecraft:soul_soil"));
                    this.add(new MapEntry("minecraft:the_end", "minecraft:end_stone"));
                    this.add(new MapEntry("misc", "minecraft:dirt"));
                }
            };
            @Comment(value="Defines whether the block under grave can be generated in claims where the player can NOT place blocks if protection api compat is enabled")
            public boolean generateOnProtectedLand = false;
            @Comment(value="Defines whether the block under grave can be generated in claims where the player CAN place blocks if protection api compat is enabled")
            public boolean generateInOwnClaim = true;
        }
    }

    public static class RespawnConfig {
        @Comment(value="On respawn, all players will receive these effects")
        public List<EffectConfig> respawnEffects = new ArrayList<EffectConfig>();
        @Comment(value="HP given to player at respawn. If 0 or negative, default health will apply")
        public int respawnHealth = -1;
        @Comment(value="If false, player will respawn with the same hunger level as when they died")
        public boolean resetHunger = true;
        @Comment(value="Hunger given to player at respawn. If negative, default hunger will apply")
        public int respawnHunger = -1;
        @Comment(value="If false, player will respawn with the same saturation level as when they died")
        public boolean resetSaturation = true;
        @Comment(value="Saturation given to player at respawn. If negative, default saturation will apply")
        public float respawnSaturation = -1.0f;
        @Comment(value="Extra items that will be given to player once respawned")
        public List<ExtraItemDrop> extraItemDrops = new ArrayList<ExtraItemDrop>();

        public static class ExtraItemDrop {
            public String itemId = "";
            public int count = 0;
            public String itemNbt = "";
        }

        public static class EffectConfig {
            public String effectName = "";
            public int effectLevel = 0;
            public int effectTime = 0;
            public boolean showBubbles = false;
        }
    }

    public static class CompatConfig {
        @Comment(value="Enables compatibility with Common Protection API (\"Claim API\"), if present")
        public boolean enableProtectionApiCompat = true;
        @Comment(value="Defines the standard drop rule in claims where the player can NOT place blocks. While PUT_IN_GRAVE, other drop rules will be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropRule standardDropRuleInClaim = DropRule.DROP;
        @Comment(value="Defines the standard drop rule in claims where the player CAN place blocks. While PUT_IN_GRAVE, other drop rules will be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropRule standardDropRuleInOwnClaim = DropRule.PUT_IN_GRAVE;
        public boolean enableAccessoriesCompat = true;
        @Comment(value="While PUT_IN_GRAVE, other drop rules will be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropRule defaultAccessoriesDropRule = DropRule.PUT_IN_GRAVE;
        public boolean enableLevelzCompat = true;
        @Comment(value="While PUT_IN_GRAVE, other drop rules will be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropRule defaultLevelzDropRule = DropRule.PUT_IN_GRAVE;
        public boolean enableTravelersBackpackCompat = true;
        @Comment(value="While PUT_IN_GRAVE, other drop rules will be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropRule defaultTravelersBackpackDropRule = DropRule.PUT_IN_GRAVE;
        public boolean enableTrinketsCompat = true;
        @Comment(value="While PUT_IN_GRAVE, other drop rules will be prioritized")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DropRule defaultTrinketsDropRule = DropRule.PUT_IN_GRAVE;
    }

    public static class CommandConfig {
        public String mainCommand = "yigd";
        public int basePermissionLevel = 0;
        public int viewLatestPermissionLevel = 0;
        public int viewSelfPermissionLevel = 0;
        public int viewUserPermissionLevel = 2;
        public int viewAllPermissionLevel = 2;
        public int restorePermissionLevel = 2;
        public int robPermissionLevel = 2;
        public int whitelistPermissionLevel = 3;
        public int deletePermissionLevel = 3;
        public int unlockPermissionLevel = 0;
    }

    public static class GraveRendering {
        public boolean useCustomFeatureRenderer = true;
        public boolean useSkullRenderer = true;
        public boolean useTextRenderer = true;
        @ConfigEntry.Gui.RequiresRestart
        public boolean adaptRenderer = false;
        public boolean useGlowingEffect = true;
        public int glowingDistance = 15;
    }

    public static class ExtraFeatures {
        @ConfigEntry.Gui.CollapsibleObject
        public boolean enableSoulbound = true;
        @ConfigEntry.Gui.CollapsibleObject
        public DeathSightConfig deathSightEnchant = new DeathSightConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public GraveKeyConfig graveKeys = new GraveKeyConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public ScrollConfig deathScroll = new ScrollConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public GraveCompassConfig graveCompass = new GraveCompassConfig();

        public static class DeathSightConfig {
            public boolean enabled = false;
            public double range = 64.0;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public GraveTargets targets = GraveTargets.PLAYER_GRAVES;

            public static enum GraveTargets {
                OWN_GRAVES,
                PLAYER_GRAVES,
                ALL_GRAVES;

            }
        }

        public static class GraveKeyConfig {
            public boolean enabled = false;
            public boolean rebindable = true;
            public boolean required = true;
            public boolean receiveOnRespawn = true;
            public boolean obtainableFromGui = false;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public KeyTargeting targeting = KeyTargeting.PLAYER_GRAVE;

            public static enum KeyTargeting {
                ANY_GRAVE,
                PLAYER_GRAVE,
                SPECIFIC_GRAVE;

            }
        }

        public static class ScrollConfig {
            public boolean enabled = false;
            public boolean rebindable = false;
            public boolean receiveOnRespawn = false;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public ClickFunction clickFunction = ClickFunction.VIEW_CONTENTS;
            public boolean consumeOnUse = false;
            public int useTime = 0;
            public int useCooldown = 0;

            public static enum ClickFunction {
                RESTORE_CONTENTS,
                VIEW_CONTENTS,
                TELEPORT_TO_LOCATION;

            }
        }

        public static class GraveCompassConfig {
            public boolean receiveOnRespawn = false;
            public boolean consumeOnUse = true;
            public boolean deleteWhenUnlinked = true;
            public boolean cloneRecoveryCompassWithGUI = false;
            @ConfigEntry.Gui.RequiresRestart
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public CompassGraveTarget pointToClosest = CompassGraveTarget.DISABLED;

            public static enum CompassGraveTarget {
                DISABLED,
                PLAYER,
                ALL;

            }
        }
    }

    public static class MapEntry {
        public String key;
        public String value;

        public MapEntry() {
            this.key = "";
            this.value = "";
        }

        public MapEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

