"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var scripts_exports = {};
__export(scripts_exports, {
  Scripts: () => Scripts
});
module.exports = __toCommonJS(scripts_exports);
const Scripts = {
  gen: 9,
  pokemon: {
    ignoringAbility() {
      let neutralizinggas = false;
      for (const pokemon of this.battle.getAllActive()) {
        if (pokemon.ability === "neutralizinggas" || pokemon.ability === "powerofalchemyweezing" && !pokemon.volatiles["gastroacid"] && !pokemon.volatiles["counteract"] && !pokemon.abilityState.ending) {
          neutralizinggas = true;
          break;
        }
      }
      return !!(this.battle.gen >= 5 && !this.isActive || (this.volatiles["gastroacid"] || this.volatiles["counteract"] || neutralizinggas && this.ability !== "neutralizinggas") && !this.getAbility().flags["cantsuppress"]);
    }
  },
  actions: {
    hitStepAccuracy(targets, pokemon, move) {
      const hitResults = [];
      for (const [i, target] of targets.entries()) {
        this.battle.activeTarget = target;
        let accuracy = move.accuracy;
        if (move.ohko) {
          if (!target.isSemiInvulnerable()) {
            accuracy = 30;
            if (move.ohko === "Ice" && this.battle.gen >= 7 && !pokemon.hasType("Ice")) {
              accuracy = 20;
            }
            if (!target.volatiles["dynamax"] && pokemon.level >= target.level && (move.ohko === true || !target.hasType(move.ohko))) {
              accuracy += pokemon.level - target.level;
            } else {
              this.battle.add("-immune", target, "[ohko]");
              hitResults[i] = false;
              continue;
            }
          }
        } else {
          accuracy = this.battle.runEvent("ModifyAccuracy", target, pokemon, move, accuracy);
          if (accuracy !== true) {
            let boost = 0;
            if (!move.ignoreAccuracy) {
              const boosts = this.battle.runEvent("ModifyBoost", pokemon, null, null, { ...pokemon.boosts });
              boost = this.battle.clampIntRange(boosts["accuracy"], -6, 6);
            }
            if (!move.ignoreEvasion) {
              const boosts = this.battle.runEvent("ModifyBoost", target, null, null, { ...target.boosts });
              boost = this.battle.clampIntRange(boost - boosts["evasion"], -6, 6);
            }
            if (boost > 0) {
              accuracy = this.battle.trunc(accuracy * (3 + boost) / 3);
            } else if (boost < 0) {
              accuracy = this.battle.trunc(accuracy * 3 / (3 - boost));
            }
          }
        }
        if (move.alwaysHit || move.id === "toxic" && this.battle.gen >= 8 && pokemon.hasType("Poison") || move.target === "self" && move.category === "Status" && !target.isSemiInvulnerable()) {
          accuracy = true;
        } else {
          accuracy = this.battle.runEvent("Accuracy", target, pokemon, move, accuracy);
        }
        if (accuracy !== true && !this.battle.randomChance(accuracy, 100)) {
          if (move.smartTarget) {
            move.smartTarget = false;
          } else {
            if (!move.spreadHit)
              this.battle.attrLastMove("[miss]");
            this.battle.add("-miss", pokemon, target);
          }
          if (!move.ohko && pokemon.hasItem("blunderpolicy") && pokemon.useItem()) {
            this.battle.boost({ spe: 2, accuracy: 2 }, pokemon);
          }
          hitResults[i] = false;
          continue;
        }
        hitResults[i] = true;
      }
      return hitResults;
    }
  },
  init() {
    this.modData("Learnsets", "screamtail").learnset.dracometeor = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.dragonpulse = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.knockoff = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.nastyplot = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.outrage = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.superfang = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.jetpunch = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.bulletpunch = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.machpunch = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.hammerarm = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.knockoff = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.slackoff = ["9L1"];
    this.modData("Learnsets", "crabominable").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.magicaltorque = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.wickedtorque = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.blazingtorque = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.combattorque = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.noxioustorque = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.highhorsepower = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.bodypress = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.darkpulse = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.crunch = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.knockoff = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.nastyplot = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.superfang = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.taunt = ["9L1"];
    this.modData("Learnsets", "sneasler").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "skuntank").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "salazzle").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "eternatus").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "grafaiai").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "magnemite").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "mareep").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "spidops").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "surskit").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "pichu").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "raichualola").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "samurotthisui").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "cacturne").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "houndoom").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "weavile").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "lokix").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "carbink").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "diancie").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "glimmora").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "sandyshocks").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "coalossal").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "mismagius").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "espeon").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "rabsca").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "bronzong").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "grumpig").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "rayquaza").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "eternatus").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "corviknight").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "irontreads").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "forretress").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "cufant").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "varoom").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "perrserker").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "sudowoodo").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "chewtle").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "hawlucha").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "tauros").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "taurospaldeacombat").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "taurospaldeablaze").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "taurospaldeaaqua").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "sandaconda").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "bergmite").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "dugtrioalola").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "dialga").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "sliggoohisui").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "chewtle").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "shellder").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "samurott").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "klawf").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "torkoal").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "chesnaught").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "pineco").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "slowbro").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "slowbrogalar").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "sinistea").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "kleavor").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "klawf").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "avalugghisui").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "drednaw").learnset.stoneaxe = ["9L1"];
    delete this.modData("Learnsets", "regieleki").learnset.electroweb;
    delete this.modData("Learnsets", "meloetta").learnset.swordsdance;
    delete this.modData("Learnsets", "magnemite").learnset.electroweb;
    delete this.modData("Learnsets", "magnezone").learnset.electroweb;
    delete this.modData("Learnsets", "magneton").learnset.electroweb;
    delete this.modData("Learnsets", "foongus").learnset.rollout;
    delete this.modData("Learnsets", "amoonguss").learnset.rollout;
    delete this.modData("Learnsets", "ragingbolt").learnset.electroweb;
    delete this.modData("Learnsets", "raikou").learnset.electroweb;
    delete this.modData("Learnsets", "magearna").learnset.electroweb;
    delete this.modData("Learnsets", "rotom").learnset.electroweb;
    delete this.modData("Learnsets", "sandyshocks").learnset.electroweb;
    delete this.modData("Learnsets", "thundurus").learnset.electroweb;
    delete this.modData("Learnsets", "mew").learnset.electroweb;
    delete this.modData("Learnsets", "bellibolt").learnset.electroweb;
    delete this.modData("Learnsets", "tadbulb").learnset.electroweb;
    delete this.modData("Learnsets", "voltorb").learnset.electroweb;
    delete this.modData("Learnsets", "voltorbhisui").learnset.electroweb;
    delete this.modData("Learnsets", "electrode").learnset.electroweb;
    delete this.modData("Learnsets", "electrodehisui").learnset.electroweb;
    delete this.modData("Learnsets", "jolteon").learnset.electroweb;
    this.modData("Learnsets", "bellibolt").learnset.surf = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.hydropump = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.liquidation = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.flipturn = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.icebeam = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.earthpower = ["9L1"];
    this.modData("Learnsets", "decidueye").learnset.poltergeist = ["9L1"];
    this.modData("Learnsets", "decidueyehisui").learnset.poltergeist = ["9L1"];
    this.modData("Learnsets", "magnemite").learnset.rapidspin = ["9L1"];
    this.modData("Learnsets", "azelf").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "mesprit").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "uxie").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "carbink").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "diancie").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "mew").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "dunsparce").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "hatenna").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "gardevoir").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "sylveon").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "espeon").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "bronzor").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "spoink").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "rabsca").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "misdreavus").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "golduck").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "forretress").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "heatran").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "ironthorns").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "irontreads").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "corviknight").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "glimmora").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "magnezone").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "coalossal").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "klefki").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "heracross").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "shellder").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "scizor").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "cufant").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "varoom").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "magearna").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "finizen").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "vaporeon").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "veluza").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "azurill").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "wochien").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "rillaboom").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "brutebonnet").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "lurantis").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "tropius").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "spidops").learnset.choke = ["9L1"];
    this.modData("Learnsets", "pawmot").learnset.choke = ["9L1"];
    this.modData("Learnsets", "gallade").learnset.choke = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.choke = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.choke = ["9L1"];
    this.modData("Learnsets", "breloom").learnset.choke = ["9L1"];
    this.modData("Learnsets", "hariyama").learnset.choke = ["9L1"];
    this.modData("Learnsets", "drifblim").learnset.choke = ["9L1"];
    this.modData("Learnsets", "primeape").learnset.choke = ["9L1"];
    this.modData("Learnsets", "medicham").learnset.choke = ["9L1"];
    this.modData("Learnsets", "ceruledge").learnset.choke = ["9L1"];
    this.modData("Learnsets", "lucario").learnset.choke = ["9L1"];
    this.modData("Learnsets", "goodra").learnset.choke = ["9L1"];
    this.modData("Learnsets", "toxicroak").learnset.choke = ["9L1"];
    this.modData("Learnsets", "dunsparce").learnset.choke = ["9L1"];
    this.modData("Learnsets", "muk").learnset.choke = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.choke = ["9L1"];
    this.modData("Learnsets", "seviper").learnset.choke = ["9L1"];
    this.modData("Learnsets", "zoroarkhisui").learnset.choke = ["9L1"];
    this.modData("Learnsets", "mimikyu").learnset.choke = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.choke = ["9L1"];
    this.modData("Learnsets", "toedscool").learnset.choke = ["9L1"];
    this.modData("Learnsets", "heracross").learnset.choke = ["9L1"];
    this.modData("Learnsets", "silicobra").learnset.choke = ["9L1"];
    this.modData("Learnsets", "wiglett").learnset.choke = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.choke = ["9L1"];
    this.modData("Learnsets", "banette").learnset.choke = ["9L1"];
    this.modData("Learnsets", "hawlucha").learnset.choke = ["9L1"];
    this.modData("Learnsets", "spiritomb").learnset.choke = ["9L1"];
    this.modData("Learnsets", "houndstone").learnset.choke = ["9L1"];
    this.modData("Learnsets", "passimian").learnset.choke = ["9L1"];
    this.modData("Learnsets", "eelektross").learnset.choke = ["9L1"];
    this.modData("Learnsets", "wochien").learnset.choke = ["9L1"];
    this.modData("Learnsets", "chesnaught").learnset.choke = ["9L1"];
    this.modData("Learnsets", "basculegion").learnset.choke = ["9L1"];
    this.modData("Learnsets", "gholdengo").learnset.choke = ["9L1"];
    this.modData("Learnsets", "hoopa").learnset.choke = ["9L1"];
    this.modData("Learnsets", "sandygast").learnset.choke = ["9L1"];
    this.modData("Learnsets", "crabrawler").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "hariyama").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "spidops").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "passimian").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "hawlucha").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "pawmot").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "medicham").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "chesnaught").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "tornadus").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "thundurus").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "enamorus").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "kubfu").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "lilliganthisui").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "glaceon").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "shellder").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "delibird").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "ironbundle").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "chienpao").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "clawitzer").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "sneasel").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "stunky").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "maschiff").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "murkrow").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "zarude").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "zarudedada").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "zoroark").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "greninja").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "greninjabond").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "kricketune").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "gallade").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "squawkabilly").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "meditite").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "toxtricity").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "zangoose").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "scyther").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "veluza").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "ironleaves").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "hoopa").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "calyrex").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "articunogalar").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "azelf").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "toxtricitylowkey").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.fakeout = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.knockoff = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.moonblast = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.moonlight = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.shadowsneak = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.sludgewave = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.aurasphere = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.axekick = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.blazekick = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.healbell = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.takedown = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.rapidspin = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.recover = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.vacuumwave = ["9L1"];
    this.modData("Learnsets", "pyroar").learnset.scorchingsands = ["9L1"];
    this.modData("Learnsets", "pyroar").learnset.earthpower = ["9L1"];
    this.modData("Learnsets", "pyroar").learnset.morningsun = ["9L1"];
    this.modData("Learnsets", "pyroar").learnset.grassknot = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.gunkshot = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.poisonjab = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.barbbarrage = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.poisonfang = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.sludgewave = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.acidarmor = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.bodypress = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.dualwingbeat = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.defog = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.whirlwind = ["9L1"];
    this.modData("Learnsets", "tropius").learnset.defog = ["9L1"];
    this.modData("Learnsets", "vivillon").learnset.defog = ["9L1"];
    this.modData("Learnsets", "articuno").learnset.defog = ["9L1"];
    this.modData("Learnsets", "articunogalar").learnset.defog = ["9L1"];
    this.modData("Learnsets", "moltres").learnset.defog = ["9L1"];
    this.modData("Learnsets", "moltresgalar").learnset.defog = ["9L1"];
    this.modData("Learnsets", "thundurus").learnset.defog = ["9L1"];
    this.modData("Learnsets", "gyarados").learnset.defog = ["9L1"];
    this.modData("Learnsets", "salamence").learnset.defog = ["9L1"];
    this.modData("Learnsets", "florges").learnset.defog = ["9L1"];
    this.modData("Learnsets", "kilowattrel").learnset.defog = ["9L1"];
    this.modData("Learnsets", "dudunsparce").learnset.defog = ["9L1"];
    this.modData("Learnsets", "espathra").learnset.defog = ["9L1"];
    this.modData("Learnsets", "tinkatink").learnset.defog = ["9L1"];
    this.modData("Learnsets", "arceus").learnset.defog = ["9L1"];
    this.modData("Learnsets", "squawkabilly").learnset.defog = ["9L1"];
    this.modData("Learnsets", "bombirdier").learnset.defog = ["9L1"];
    this.modData("Learnsets", "pawmi").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "pichu").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "raichualola").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "shinx").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "toxtricity").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "toxtricitylowkey").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "eelektrik").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "ironhands").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "ironthorns").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "thundurus").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "jolteon").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "grimer").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "grimeralola").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "glimmet").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "slowbrogalar").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "skrelp").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "stunky").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "shroodle").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "gulpin").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "croagunk").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "fletchling").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "starly").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "squawkabilly").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "murkrow").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "eiscue").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "flamigo").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "rufflet").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "wingull").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "delibird").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "arrokuda").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "toedscruel").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "tornadus").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "moltres").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "moltresgalar").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "articuno").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "articunogalar").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "ironjugulis").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "oricorio").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "noibat").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "wattrel").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "fletchling").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "drifloon").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "vivillon").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "murkrow").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "hawlucha").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "hoppip").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "sneasel").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "mankey").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "cacturne").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "zapdosgalar").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "urshifu").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "slitherwing").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "toxtricity").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "toxtricitylowkey").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "falinks").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "mew").learnset.recover = ["9L1"];
    this.modData("Learnsets", "mew").learnset.defog = ["9L1"];
    this.modData("Learnsets", "mew").learnset.moonlight = ["9L1"];
    this.modData("Learnsets", "tinkaton").learnset.earthpower = ["9L1"];
    this.modData("Learnsets", "tinkaton").learnset.discharge = ["9L1"];
    this.modData("Learnsets", "garganacl").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "growlithehisui").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "diancie").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "kleavor").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "larvitar").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "drednaw").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "rockruff").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "lycanrocdusk").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "ironthorns").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "carbink").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "glastrier").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sneasel").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "froslass").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "beartic").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "greattusk").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "ironvaliant").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "gallade").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "zapdosgalar").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "toxicroak").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "falinks").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "veluza").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "breloom").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "gible").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sandile").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "teddiursa").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "ironvaliant").learnset.parry = ["9L1"];
    this.modData("Learnsets", "zamazenta").learnset.parry = ["9L1"];
    this.modData("Learnsets", "zacian").learnset.parry = ["9L1"];
    this.modData("Learnsets", "ironhands").learnset.parry = ["9L1"];
    this.modData("Learnsets", "breloom").learnset.parry = ["9L1"];
    this.modData("Learnsets", "chesnaught").learnset.parry = ["9L1"];
    this.modData("Learnsets", "decidueyehisui").learnset.parry = ["9L1"];
    this.modData("Learnsets", "gallade").learnset.parry = ["9L1"];
    this.modData("Learnsets", "riolu").learnset.parry = ["9L1"];
    this.modData("Learnsets", "flamigo").learnset.parry = ["9L1"];
    this.modData("Learnsets", "makuhita").learnset.parry = ["9L1"];
    this.modData("Learnsets", "mankey").learnset.parry = ["9L1"];
    this.modData("Learnsets", "oshawott").learnset.parry = ["9L1"];
    this.modData("Learnsets", "kleavor").learnset.parry = ["9L1"];
    this.modData("Learnsets", "palafin").learnset.parry = ["9L1"];
    this.modData("Learnsets", "ironleaves").learnset.parry = ["9L1"];
    this.modData("Learnsets", "lokix").learnset.parry = ["9L1"];
    this.modData("Learnsets", "golduck").learnset.parry = ["9L1"];
    this.modData("Learnsets", "meditite").learnset.parry = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.parry = ["9L1"];
    this.modData("Learnsets", "pawmo").learnset.parry = ["9L1"];
    this.modData("Learnsets", "hawlucha").learnset.parry = ["9L1"];
    this.modData("Learnsets", "ceruledge").learnset.parry = ["9L1"];
    this.modData("Learnsets", "veluza").learnset.parry = ["9L1"];
    this.modData("Learnsets", "azurill").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "enamorus").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "hatterene").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "mimikyu").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "pichu").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "tinkaton").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "ralts").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "grimmsnarl").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "dachsbun").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "dedenne").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "igglybuff").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "mabosstiff").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "meowth").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "meowthalola").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "meowthgalar").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "riolu").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "happiny").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "toxel").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "bonsly").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "lurantis").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "banette").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "zoroarkhisui").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "zoroark").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "farigiraf").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "drowzee").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "eevee").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "rowlet").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "houndstone").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "alomomola").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "dudunsparce").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "sinistea").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "maushold").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "squawkabilly").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "sandaconda").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "scorbunny").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "typhlosion").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "typhlosionhisui").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "torkoal").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "cloyster").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "flapple").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "appletun").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "mew").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "mew").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "mewtwo").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "espathra").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "espeon").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "gardevoir").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "indeedee").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "indeedeef").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "farigiraf").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "wyrdeer").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "mesprit").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "raichualola").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "wyrdeer").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "calyrex").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "grumpig").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "hypno").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "rabsca").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "medicham").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "ironleaves").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "psyduck").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "banette").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "pawmot").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "kubfu").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "camerupt").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "slitherwing").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "taurospaldeablaze").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "primeape").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "charizard").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "scovillain").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "muk").learnset.recover = ["9L1"];
    this.modData("Learnsets", "muk").learnset.earthquake = ["9L1"];
    this.modData("Learnsets", "muk").learnset.explosion = ["9L1"];
    this.modData("Learnsets", "muk").learnset.whirlpool = ["9L1"];
    this.modData("Learnsets", "muk").learnset.aquajet = ["9L1"];
    this.modData("Learnsets", "muk").learnset.liquidation = ["9L1"];
    this.modData("Learnsets", "muk").learnset.soak = ["9L1"];
    this.modData("Learnsets", "muk").learnset.wavecrash = ["9L1"];
    this.modData("Learnsets", "muk").learnset.surf = ["9L1"];
    this.modData("Learnsets", "muk").learnset.hydropump = ["9L1"];
    this.modData("Learnsets", "muk").learnset.muddywater = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.recover = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.earthquake = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.explosion = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.suckerpunch = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.foulplay = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.beatup = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.jawlock = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.powertrip = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.curse = ["9L1"];
    this.modData("Learnsets", "mukalola").learnset.stealthrock = ["9L1"];
    this.modData("Learnsets", "hariyama").learnset.courtchange = ["9L1"];
    this.modData("Learnsets", "hariyama").learnset.saltcure = ["9L1"];
    this.modData("Learnsets", "hariyama").learnset.slackoff = ["9L1"];
    this.modData("Learnsets", "hariyama").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "ironjugulis").learnset.roost = ["9L1"];
    this.modData("Learnsets", "growlithehisui").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "larvitar").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "carbink").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "diancie").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "rockruff").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "chewtle").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "rolycoly").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "kleavor").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "klawf").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "ironthorns").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "bombirdier").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "bagon").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "goodrahisui").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "varoom").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "glimmora").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "carbink").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "diancie").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "rolycoly").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.round = ["9L1"];
    this.modData("Learnsets", "happiny").learnset.round = ["9L1"];
    this.modData("Learnsets", "kricketune").learnset.round = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.round = ["9L1"];
    this.modData("Learnsets", "croagunk").learnset.round = ["9L1"];
    this.modData("Learnsets", "azumarill").learnset.round = ["9L1"];
    this.modData("Learnsets", "komala").learnset.round = ["9L1"];
    this.modData("Learnsets", "toxel").learnset.round = ["9L1"];
    this.modData("Learnsets", "growlithe").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "growlithehisui").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "cyndaquil").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "moltres").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "carkol").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "volcarona").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "talonflame").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "charcadet").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "charmander").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "taurospaldeablaze").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "fennekin").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "litleo").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "fuecoco").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "chiyu").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "salamence").learnset.scaleshot = ["9L1"];
    this.modData("Learnsets", "salamence").learnset.flamecharge = ["9L1"];
    this.modData("Learnsets", "salamence").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.knockoff = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.axekick = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.highhorsepower = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.leechseed = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.aquatail = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.aquajet = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.liquidation = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.wavecrash = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.whirlpool = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.surf = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.hydropump = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.toxic = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.recover = ["9L1"];
    delete this.modData("Learnsets", "magearna").learnset.shiftgear;
    delete this.modData("Learnsets", "magearna").learnset.storedpower;
    delete this.modData("Learnsets", "magearna").learnset.spikes;
    delete this.modData("Learnsets", "magearna").learnset.trick;
    delete this.modData("Learnsets", "magearna").learnset.drainingkiss;
    delete this.modData("Learnsets", "magearna").learnset.agility;
    this.modData("Learnsets", "dragalge").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "dipplin").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "dipplin").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "ursalunabloodmoon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "ursalunabloodmoon").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "ekans").learnset.choke = ["9L1"];
    this.modData("Learnsets", "ekans").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "arbok").learnset.choke = ["9L1"];
    this.modData("Learnsets", "arbok").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "sandshrew").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sandshrew").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "sandshrew").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "sandshrewalola").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sandshrewalola").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "sandshrewalola").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "sandshrewalola").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "sandshrewalola").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "sandslash").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sandslash").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "sandslash").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "sandslashalola").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sandslashalola").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "sandslashalola").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "sandslashalola").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "sandslashalola").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "cleffa").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "cleffa").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "clefairy").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "clefairy").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "clefable").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "clefable").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "bellsprout").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "weepinbell").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "victreebel").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "vulpix").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "vulpix").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "vulpix").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "vulpixalola").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "vulpixalola").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "ninetales").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "ninetales").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "ninetales").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "ninetalesalola").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "ninetalesalola").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "poliwag").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "poliwhirl").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "poliwrath").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "poliwrath").learnset.parry = ["9L1"];
    this.modData("Learnsets", "poliwrath").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "poliwrath").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "politoed").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "geodude").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "geodude").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "geodude").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "geodude").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "geodudealola").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "geodudealola").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "geodudealola").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "geodudealola").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "geodudealola").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "graveler").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "graveler").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "graveler").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "graveler").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "graveleralola").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "graveleralola").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "graveleralola").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "graveleralola").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "graveleralola").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "golem").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "golem").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "golem").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "golem").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "golemalola").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "golemalola").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "golemalola").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "golemalola").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "golemalola").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "koffing").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "koffing").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "weezing").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "weezing").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "weezinggalar").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "weezinggalar").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "weezinggalar").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "weezinggalar").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "munchlax").learnset.parry = ["9L1"];
    this.modData("Learnsets", "munchlax").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "munchlax").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.parry = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "sentret").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "furret").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "hoothoot").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "hoothoot").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "hoothoot").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "noctowl").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "noctowl").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "noctowl").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "spinarak").learnset.choke = ["9L1"];
    this.modData("Learnsets", "spinarak").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "spinarak").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "spinarak").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "ariados").learnset.choke = ["9L1"];
    this.modData("Learnsets", "ariados").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "ariados").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "ariados").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.choke = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "ambipom").learnset.choke = ["9L1"];
    this.modData("Learnsets", "ambipom").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "ambipom").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "yanma").learnset.defog = ["9L1"];
    this.modData("Learnsets", "yanma").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "yanma").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "yanmega").learnset.defog = ["9L1"];
    this.modData("Learnsets", "yanmega").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "yanmega").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "gligar").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "gligar").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "gligar").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "gligar").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "gliscor").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "gliscor").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "gliscor").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "gliscor").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "slugma").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "magcargo").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "magcargo").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "magcargo").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "swinub").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "swinub").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "swinub").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "swinub").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "piloswine").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "piloswine").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "piloswine").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "piloswine").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "mamoswine").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "mamoswine").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "mamoswine").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "mamoswine").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "poochyena").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "poochyena").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "poochyena").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "mightyena").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "mightyena").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "mightyena").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "lotad").learnset.round = ["9L1"];
    this.modData("Learnsets", "lombre").learnset.round = ["9L1"];
    this.modData("Learnsets", "ludicolo").learnset.round = ["9L1"];
    this.modData("Learnsets", "seedot").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "seedot").learnset.parry = ["9L1"];
    this.modData("Learnsets", "seedot").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.parry = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.parry = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "shiftry").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "nosepass").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "nosepass").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "probopass").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "probopass").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "volbeat").learnset.defog = ["9L1"];
    this.modData("Learnsets", "volbeat").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "illumise").learnset.defog = ["9L1"];
    this.modData("Learnsets", "illumise").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "corphish").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "corphish").learnset.parry = ["9L1"];
    this.modData("Learnsets", "corphish").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "crawdaunt").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "crawdaunt").learnset.parry = ["9L1"];
    this.modData("Learnsets", "crawdaunt").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "duskull").learnset.choke = ["9L1"];
    this.modData("Learnsets", "dusclops").learnset.choke = ["9L1"];
    this.modData("Learnsets", "dusclops").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "dusclops").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "dusclops").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "dusknoir").learnset.choke = ["9L1"];
    this.modData("Learnsets", "dusknoir").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "dusknoir").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "dusknoir").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.defog = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.round = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "chimecho").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "chimecho").learnset.defog = ["9L1"];
    this.modData("Learnsets", "chimecho").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "chimecho").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "chimecho").learnset.round = ["9L1"];
    this.modData("Learnsets", "chimecho").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "jirachi").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "jirachi").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "jirachi").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "jirachi").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "jirachi").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "turtwig").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "turtwig").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "turtwig").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "grotle").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "grotle").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "grotle").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "torterra").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "torterra").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "torterra").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "chimchar").learnset.choke = ["9L1"];
    this.modData("Learnsets", "chimchar").learnset.parry = ["9L1"];
    this.modData("Learnsets", "chimchar").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "chimchar").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "monferno").learnset.choke = ["9L1"];
    this.modData("Learnsets", "monferno").learnset.parry = ["9L1"];
    this.modData("Learnsets", "monferno").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "monferno").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "infernape").learnset.choke = ["9L1"];
    this.modData("Learnsets", "infernape").learnset.parry = ["9L1"];
    this.modData("Learnsets", "infernape").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "infernape").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "piplup").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "piplup").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "piplup").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "piplup").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "piplup").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "prinplup").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "prinplup").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "prinplup").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "prinplup").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "prinplup").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "phione").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "manaphy").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "shaymin").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "shaymin").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "shaymin").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "darkrai").learnset.choke = ["9L1"];
    this.modData("Learnsets", "darkrai").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "darkrai").learnset.comeuppance = ["9L1"];
    this.modData("Learnsets", "timburr").learnset.choke = ["9L1"];
    this.modData("Learnsets", "timburr").learnset.parry = ["9L1"];
    this.modData("Learnsets", "timburr").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "timburr").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "gurdurr").learnset.choke = ["9L1"];
    this.modData("Learnsets", "gurdurr").learnset.parry = ["9L1"];
    this.modData("Learnsets", "gurdurr").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "gurdurr").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "conkeldurr").learnset.choke = ["9L1"];
    this.modData("Learnsets", "conkeldurr").learnset.parry = ["9L1"];
    this.modData("Learnsets", "conkeldurr").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "conkeldurr").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "sewaddle").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "sewaddle").learnset.parry = ["9L1"];
    this.modData("Learnsets", "swadloon").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "swadloon").learnset.parry = ["9L1"];
    this.modData("Learnsets", "leavanny").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "leavanny").learnset.parry = ["9L1"];
    this.modData("Learnsets", "ducklett").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "ducklett").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "ducklett").learnset.round = ["9L1"];
    this.modData("Learnsets", "ducklett").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "swanna").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "swanna").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "swanna").learnset.round = ["9L1"];
    this.modData("Learnsets", "swanna").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "litwick").learnset.choke = ["9L1"];
    this.modData("Learnsets", "litwick").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "lampent").learnset.choke = ["9L1"];
    this.modData("Learnsets", "lampent").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "chandelure").learnset.choke = ["9L1"];
    this.modData("Learnsets", "chandelure").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "mienfoo").learnset.choke = ["9L1"];
    this.modData("Learnsets", "mienfoo").learnset.parry = ["9L1"];
    this.modData("Learnsets", "mienfoo").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "mienshao").learnset.choke = ["9L1"];
    this.modData("Learnsets", "mienshao").learnset.parry = ["9L1"];
    this.modData("Learnsets", "mienshao").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "vullaby").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "vullaby").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "mandibuzz").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "mandibuzz").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "phantump").learnset.choke = ["9L1"];
    this.modData("Learnsets", "phantump").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "phantump").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "trevenant").learnset.choke = ["9L1"];
    this.modData("Learnsets", "trevenant").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "trevenant").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "trevenant").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "grubbin").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "charjabug").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "charjabug").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "vikavolt").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "vikavolt").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "cutiefly").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "cutiefly").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "cutiefly").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "ribombee").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "ribombee").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "ribombee").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "jangmoo").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "jangmoo").learnset.parry = ["9L1"];
    this.modData("Learnsets", "jangmoo").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "hakamoo").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "hakamoo").learnset.parry = ["9L1"];
    this.modData("Learnsets", "hakamoo").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "kommoo").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "kommoo").learnset.parry = ["9L1"];
    this.modData("Learnsets", "kommoo").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "cramorant").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "cramorant").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "cramorant").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.choke = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.defog = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "ogerpon").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "ogerpon").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "bronzor").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "magnemite").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "pineco").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "tinkatink").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "irontreads").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "nosepass").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "nacli").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "geodude").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "magcargo").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "diancie").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "rolycoly").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "timburr").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "carbink").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "alomomola").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "bellibolt").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "clawitzer").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "cramorant").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "dondozo").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "gastrodon").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "greninja").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "gyarados").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "lumineon").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "manaphy").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "pelipper").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "phione").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "politoed").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "poliwrath").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "tatsugiri").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "toxapex").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "whiscash").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "vaporeon").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "kommoo").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "noibat").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "toxtricity").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "rillaboom").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "bronzor").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "igglybuff").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "skeledirge").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "corviknight").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "heatran").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "ironmoth").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "sandyshocks").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "magnemite").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "klefki").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "riolu").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "milotic").learnset.moonblast = ["9L1"];
    this.modData("Learnsets", "milotic").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "milotic").learnset.psychic = ["9L1"];
    this.modData("Learnsets", "eevee").learnset.round = ["9L1"];
    this.modData("Learnsets", "vaporeon").learnset.round = ["9L1"];
    this.modData("Learnsets", "jolteon").learnset.round = ["9L1"];
    this.modData("Learnsets", "jolteon").learnset.dazzlinggleam = ["9L1"];
    this.modData("Learnsets", "jolteon").learnset.overheat = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.round = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.closecombat = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.morningsun = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "espeon").learnset.round = ["9L1"];
    this.modData("Learnsets", "espeon").learnset.luminacrash = ["9L1"];
    this.modData("Learnsets", "umbreon").learnset.round = ["9L1"];
    this.modData("Learnsets", "umbreon").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "umbreon").learnset.knockoff = ["9L1"];
    this.modData("Learnsets", "leafeon").learnset.round = ["9L1"];
    this.modData("Learnsets", "leafeon").learnset.nightslash = ["9L1"];
    this.modData("Learnsets", "leafeon").learnset.psychocut = ["9L1"];
    this.modData("Learnsets", "glaceon").learnset.round = ["9L1"];
    this.modData("Learnsets", "glaceon").learnset.dazzlinggleam = ["9L1"];
    this.modData("Learnsets", "glaceon").learnset.earthpower = ["9L1"];
    this.modData("Learnsets", "sylveon").learnset.round = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.spikes = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.defog = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.acrobatics = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "cinderace").learnset.brickbreak = ["9L1"];
    this.modData("Learnsets", "gyarados").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "sandile").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "drednaw").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "roaringmoon").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "tinkaton").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "empoleon").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "goodrahisui").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "scizor").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "copperajah").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "probopass").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "gurdurr").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "irontreads").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "bronzong").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "corphish").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "gligar").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "crabrawler").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "klawf").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "chesnaught").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "ursaring").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "rillaboom").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "greattusk").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "tinglu").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "donphan").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "garchomp").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "hippowdon").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "irontreads").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "sandyshocks").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "torterra").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "krookodile").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "golem").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "sandaconda").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "dugtrio").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "dugtrioalola").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "pyroar").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "sandslash").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "tyranitar").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "rockruff").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "lycanrocdusk").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "whiscash").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "nosepass").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "stonjourner").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "klawf").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "orthworm").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "dipplin").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "flapple").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "appletun").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "dratini").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "gible").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "bagon").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "jangmoo").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "cyclizar").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "goomy").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "gyarados").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "milotic").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "deino").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "regidrago").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "altaria").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "dragalge").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "noivern").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "tatsugiri").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "rayquaza").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "eternatus").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "ampharos").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "axew").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "salazzle").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "dondozo").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "charmander").learnset.rage = ["9L1"];
    this.modData("Learnsets", "mankey").learnset.rage = ["9L1"];
    this.modData("Learnsets", "tauros").learnset.rage = ["9L1"];
    this.modData("Learnsets", "taurospaldeacombat").learnset.rage = ["9L1"];
    this.modData("Learnsets", "taurospaldeablaze").learnset.rage = ["9L1"];
    this.modData("Learnsets", "taurospaldeaaqua").learnset.rage = ["9L1"];
    this.modData("Learnsets", "gyarados").learnset.rage = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.rage = ["9L1"];
    this.modData("Learnsets", "dunsparce").learnset.rage = ["9L1"];
    this.modData("Learnsets", "bagon").learnset.rage = ["9L1"];
    this.modData("Learnsets", "sandile").learnset.rage = ["9L1"];
    this.modData("Learnsets", "houndour").learnset.rage = ["9L1"];
    this.modData("Learnsets", "stantler").learnset.rage = ["9L1"];
    this.modData("Learnsets", "basculin").learnset.rage = ["9L1"];
    this.modData("Learnsets", "basculinwhitestriped").learnset.rage = ["9L1"];
    this.modData("Learnsets", "bruxish").learnset.rage = ["9L1"];
    this.modData("Learnsets", "munchlax").learnset.rage = ["9L1"];
    this.modData("Learnsets", "teddiursa").learnset.rage = ["9L1"];
    this.modData("Learnsets", "ursalunabloodmoon").learnset.rage = ["9L1"];
    this.modData("Learnsets", "zoroarkhisui").learnset.rage = ["9L1"];
    this.modData("Learnsets", "staraptor").learnset.rage = ["9L1"];
    this.modData("Learnsets", "rufflet").learnset.rage = ["9L1"];
    this.modData("Learnsets", "zangoose").learnset.rage = ["9L1"];
    this.modData("Learnsets", "yungoos").learnset.rage = ["9L1"];
    this.modData("Learnsets", "skwovet").learnset.rage = ["9L1"];
    this.modData("Learnsets", "vigoroth").learnset.rage = ["9L1"];
    this.modData("Learnsets", "squawkabilly").learnset.rage = ["9L1"];
    this.modData("Learnsets", "jigglypuff").learnset.rage = ["9L1"];
    this.modData("Learnsets", "litleo").learnset.rage = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.rage = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.rage = ["9L1"];
    this.modData("Learnsets", "lycanrocdusk").learnset.rage = ["9L1"];
    this.modData("Learnsets", "hydreigon").learnset.rage = ["9L1"];
    this.modData("Learnsets", "dondozo").learnset.rage = ["9L1"];
    this.modData("Learnsets", "slitherwing").learnset.rage = ["9L1"];
    this.modData("Learnsets", "ironthorns").learnset.rage = ["9L1"];
    this.modData("Learnsets", "geodude").learnset.rage = ["9L1"];
    this.modData("Learnsets", "geodudealola").learnset.rage = ["9L1"];
    this.modData("Learnsets", "chimchar").learnset.rage = ["9L1"];
    this.modData("Learnsets", "glimmet").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "slowkinggalar").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "sneaselhisui").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "amoonguss").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "wooperpaldea").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "gengar").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "grimeralola").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "skrelp").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "shroodle").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "qwilfishhisui").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "toxtricity").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "toxtricitylowkey").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "venonat").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "grimer").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "salandit").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "slowbrogalar").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "victreebel").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "croagunk").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "ekans").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "spinarak").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "weezing").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "seviper").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "gligar").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "pincurchin").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "trevenant").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "wigglytuff").learnset.boomburst = ["9L1"];
    this.modData("Learnsets", "wigglytuff").learnset.moonblast = ["9L1"];
    this.modData("Learnsets", "wigglytuff").learnset.spiritbreak = ["9L1"];
    this.modData("Learnsets", "wigglytuff").learnset.teleport = ["9L1"];
    this.modData("Learnsets", "wigglytuff").learnset.tidyup = ["9L1"];
    this.modData("Learnsets", "froslass").learnset.freezedry = ["9L1"];
    this.modData("Learnsets", "froslass").learnset.nastyplot = ["9L1"];
    this.modData("Learnsets", "froslass").learnset.focusblast = ["9L1"];
    this.modData("Learnsets", "froslass").learnset.bittermalice = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.partingshot = ["9L1"];
    this.modData("Learnsets", "okidogi").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "fezandipiti").learnset.willowisp = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.slackoff = ["9L1"];
    delete this.modData("Learnsets", "sneasler").learnset.acrobatics;
    delete this.modData("Learnsets", "darkrai").learnset.psychic;
    delete this.modData("Learnsets", "darkrai").learnset.nastyplot;
    delete this.modData("Learnsets", "mew").learnset.steelbeam;
    this.modData("Learnsets", "brambleghast").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.poisonjab = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.sandstorm = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.sandtomb = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.spikyshield = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.whirlwind = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.wrap = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "heatran").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "garchomp").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "applin").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bellsprout").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bounsweet").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bramblin").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "brutebonnet").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "capsakid").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "chespin").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "decidueye").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "fomantis").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "grookey").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "hoppip").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "leafeon").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "lotad").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "petilil").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "phantump").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "seedot").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "shaymin").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "skiddo").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "smoliv").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "snover").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "sprigatito").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "sunkern").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "turtwig").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "tropius").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "wochien").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "zarude").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "zarudedada").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "sneasel").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "sneaselhisui").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "shuppet").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "munchlax").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "meowth").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "meowthgalar").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "meowthalola").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "poochyena").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "ekans").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "zorua").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "zoruahisui").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "fletchling").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "litleo").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "noibat").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "salandit").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "cleffa").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "drowzee").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "happiny").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "mewtwo").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "mew").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "umbreon").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "murkrow").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "eevee").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "misdreavus").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "houndour").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "ralts").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "shroomish").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "gulpin").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "spoink").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "seviper").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "duskull").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "chingling").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "stunky").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "croagunk").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "spiritomb").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "froslass").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "darkrai").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "sandile").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "gothita").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "vullaby").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "fennekin").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "froakie").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "mareanie").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "oranguru").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "passimian").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "mimikyu").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "bruxish").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "cacnea").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "impidimp").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "moltresgalar").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "nuzleaf").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "grimeralola").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "zarude").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "zarudedada").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "sprigatito").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "brutebonnet").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "maschiff").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "greavard").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "zangoose").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "tinglu").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "capsakid").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "vulpix").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "vulpixalola").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "buizel").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "cyclizar").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "tauros").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "skwovet").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "meowth").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "meowthalola").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "stunky").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "lycanroc").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "zacian").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "zamazenta").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "grafaiai").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "flareon").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "clawitzer").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "passimian").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "falinks").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "sandslash").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "sandslashalola").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "lokix").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "vikavolt").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "cloyster").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "pincurchin").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "scyther").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "mareep").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "spinarak").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "articuno").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "azelf").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "bruxish").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "clefairy").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "shellder").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "cryogonal").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "dedenne").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "fennekin").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "drowzee").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "eelektrik").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "voltorb").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "voltorbhisui").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "espeon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "snorunt").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "pineco").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "glaceon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "spoink").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "jolteon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "kyogre").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "larvesta").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "finneon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "shinx").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "magnemite").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "manaphy").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "surskit").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "mesprit").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "mew").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "mewtwo").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "pichu").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "qwilfish").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "qwilfishhisui").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "cutiefly").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "sableye").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "slowbrogalar").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "slowkinggalar").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "stantler").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "uxie").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "venonat").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "charjabug").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "zapdos").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "yanma").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "articunogalar").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "braviaryhisui").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "frosmoth").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "inteleon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "pincurchin").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "tadbulb").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "flittle").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "ironbundle").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "ironmoth").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "wattrel").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "miraidon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "munkidori").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "pawmi").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "rabsca").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "sandyshocks").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "toedscool").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "ursalunabloodmoon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "umbreon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "nosepass").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "corviknight").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "flamigo").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "tropius").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "decidueyehisui").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "quaquaval").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "heracross").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "tsareena").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "mienshao").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "lucario").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "medicham").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "magnezone").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "vikavolt").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "venomoth").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "miraidon").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "ironbundle").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "ironthorns").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "electrode").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "ironmoth").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "eelektrik").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "yanmega").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "frosmoth").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "greninja").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "crabrawler").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "salazzle").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "haxorus").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "drednaw").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "pineco").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "phanpy").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "lotad").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "swablu").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "tropius").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "uxie").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "mesprit").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "azelf").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "shaymin").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "arceus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "fletchling").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "happiny").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "eevee").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "sentret").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "shroomish").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "snover").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "petilil").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "deerling").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "dedenne").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "bellsprout").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "tandemaus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "skwovet").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "applin").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "grimer").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "gulpin").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "tauros").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "taurospaldeacombat").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "taurospaldeablaze").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "taurospaldeaaqua").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "girafarig").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "lechonk").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "numel").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "mareep").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "phantump").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "smoliv").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "voltorb").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "voltorbhisui").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "shellos").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "thundurus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "tornadus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "enamorus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "turtwig").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "gible").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "sneasel").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "ogerpon").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "froakie").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "dondozo").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "tatsugiri").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "bramblin").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "shroodle").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "bounsweet").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "sewaddle").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "passimian").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "morpeko").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "calyrex").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "delibird").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "squawkabilly").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "aipom").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "grookey").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "zarude").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "zarudedada").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "azurill").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "sunkern").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "krookodile").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "krookodile").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "krookodile").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "krookodile").learnset.dragondance = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.fairywind = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.drainingkiss = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.moonblast = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.round = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.thunderwave = ["9L1"];
    this.modData("Learnsets", "delphox").learnset.courtchange = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.defog = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.painsplit = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.memento = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.weatherball = ["9L1"];
    this.modData("Learnsets", "rotom").learnset.dazzlinggleam = ["9L1"];
    this.modData("Learnsets", "hydrapple").learnset.choke = ["9L1"];
    this.modData("Learnsets", "hydrapple").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "hydrapple").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "bulbasaur").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "bulbasaur").learnset.choke = ["9L1"];
    this.modData("Learnsets", "bulbasaur").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bulbasaur").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "ivysaur").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "ivysaur").learnset.choke = ["9L1"];
    this.modData("Learnsets", "ivysaur").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "ivysaur").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "ivysaur").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "venusaur").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "venusaur").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "venusaur").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "venusaur").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "venusaur").learnset.choke = ["9L1"];
    this.modData("Learnsets", "squirtle").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "squirtle").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "squirtle").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "squirtle").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "wartortle").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "wartortle").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "wartortle").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "wartortle").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "blastoise").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "oddish").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "oddish").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "oddish").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "gloom").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "gloom").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "gloom").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "vileplume").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "vileplume").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "vileplume").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "vileplume").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "vileplume").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "vileplume").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bellossom").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "bellossom").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "bellossom").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "bellossom").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bellossom").learnset.round = ["9L1"];
    this.modData("Learnsets", "bellossom").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "tentacool").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "tentacool").learnset.choke = ["9L1"];
    this.modData("Learnsets", "tentacool").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "tentacool").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "tentacool").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.choke = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "tentacruel").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "doduo").learnset.defog = ["9L1"];
    this.modData("Learnsets", "doduo").learnset.rage = ["9L1"];
    this.modData("Learnsets", "doduo").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.brickbreak = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.parry = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.rage = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.defog = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "dodrio").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "seel").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "seel").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.round = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "dewgong").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "exeggcute").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "exeggcute").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "exeggcute").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "exeggutor").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "exeggutoralola").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "exeggutoralola").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "exeggutoralola").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "exeggutoralola").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "exeggutoralola").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "tyrogue").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "tyrogue").learnset.parry = ["9L1"];
    this.modData("Learnsets", "tyrogue").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "tyrogue").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "tyrogue").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.parry = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.rage = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "hitmonlee").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.parry = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.rage = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.choke = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "hitmonchan").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.parry = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.rage = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "hitmontop").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "rhyhorn").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "rhyhorn").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "rhyhorn").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "rhydon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "rhydon").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "rhydon").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.rage = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "rhyperior").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "horsea").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "horsea").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "seadra").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "seadra").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "seadra").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "seadra").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "seadra").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.snipeshot = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "kingdra").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "elekid").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "elekid").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.parry = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.rage = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "electabuzz").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.choke = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.parry = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.rage = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "electivire").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "magby").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "magby").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "magby").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "magmar").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "magmar").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "magmar").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.choke = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.rage = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "magmortar").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.round = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "lapras").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "porygon").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "porygon").learnset.parry = ["9L1"];
    this.modData("Learnsets", "porygon").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "porygon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "porygon").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "porygon2").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "porygon2").learnset.parry = ["9L1"];
    this.modData("Learnsets", "porygon2").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "porygon2").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "porygon2").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "porygonz").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "porygonz").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "porygonz").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "porygonz").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "porygonz").learnset.parry = ["9L1"];
    this.modData("Learnsets", "porygonz").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "chikorita").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "chikorita").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "chikorita").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "chikorita").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "bayleef").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "bayleef").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "bayleef").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "bayleef").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "meganium").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "totodile").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "totodile").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "totodile").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "totodile").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "totodile").learnset.rage = ["9L1"];
    this.modData("Learnsets", "totodile").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "croconaw").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "croconaw").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "croconaw").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "croconaw").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "croconaw").learnset.rage = ["9L1"];
    this.modData("Learnsets", "croconaw").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.choke = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.rage = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "feraligatr").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "chinchou").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "chinchou").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "lanturn").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "lanturn").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "lanturn").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "lanturn").learnset.chainlighting = ["9L1"];
    this.modData("Learnsets", "lanturn").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "lanturn").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "snubbull").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "snubbull").learnset.round = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.rage = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "granbull").learnset.round = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.defog = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "skarmory").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "raikou").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "raikou").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "raikou").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "raikou").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "entei").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "entei").learnset.rage = ["9L1"];
    this.modData("Learnsets", "entei").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "entei").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "entei").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "suicune").learnset.defog = ["9L1"];
    this.modData("Learnsets", "suicune").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "suicune").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "suicune").learnset.frostbreath = ["9L1"];
    this.modData("Learnsets", "suicune").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.defog = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "lugia").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.defog = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.rage = ["9L1"];
    this.modData("Learnsets", "hooh").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "treecko").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "treecko").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "grovyle").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "grovyle").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.parry = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "sceptile").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "torchic").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "torchic").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "combusken").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "combusken").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "combusken").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.choke = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.parry = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.rage = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "blaziken").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "mudkip").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "mudkip").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "marshtomp").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "marshtomp").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "swampert").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "plusle").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "plusle").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "plusle").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "plusle").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "plusle").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "plusle").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "minun").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "minun").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "minun").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "minun").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "minun").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "minun").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "trapinch").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "trapinch").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.defog = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "vibrava").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.defog = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "flygon").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "beldum").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "metang").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "metang").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "metang").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.parry = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "metagross").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "regirock").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "regice").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "regice").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "regice").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "regice").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "registeel").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "registeel").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "registeel").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "registeel").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "registeel").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "latias").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "latias").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "latias").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "latias").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "latias").learnset.defog = ["9L1"];
    this.modData("Learnsets", "latias").learnset.parry = ["9L1"];
    this.modData("Learnsets", "latios").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "latios").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "latios").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "latios").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "latios").learnset.defog = ["9L1"];
    this.modData("Learnsets", "latios").learnset.parry = ["9L1"];
    this.modData("Learnsets", "deoxys").learnset.choke = ["9L1"];
    this.modData("Learnsets", "deoxys").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "deoxys").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "deoxys").learnset.parry = ["9L1"];
    this.modData("Learnsets", "deoxys").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "deoxys").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "cranidos").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "cranidos").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "cranidos").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.rage = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "rampardos").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "shieldon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "shieldon").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "shieldon").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "shieldon").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "bastiodon").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "regigigas").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "regigigas").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "regigigas").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "regigigas").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "regigigas").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "snivy").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "servine").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "serperior").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "serperior").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "serperior").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "serperior").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "serperior").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "tepig").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "pignite").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "pignite").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.choke = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.parry = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.rage = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "emboar").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "blitzle").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "zebstrika").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "zebstrika").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "zebstrika").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "drilbur").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "drilbur").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.parry = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "excadrill").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "cottonee").learnset.defog = ["9L1"];
    this.modData("Learnsets", "cottonee").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "cottonee").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "cottonee").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.defog = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "whimsicott").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "scraggy").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "scraggy").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "scraggy").learnset.choke = ["9L1"];
    this.modData("Learnsets", "scraggy").learnset.parry = ["9L1"];
    this.modData("Learnsets", "scraggy").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.choke = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.parry = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.rage = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "scrafty").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "minccino").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "minccino").learnset.rage = ["9L1"];
    this.modData("Learnsets", "minccino").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "minccino").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.rage = ["9L1"];
    this.modData("Learnsets", "cinccino").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "solosis").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "solosis").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "solosis").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "solosis").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "duosion").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "duosion").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "duosion").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "duosion").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.brickbreak = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.parry = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "reuniclus").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "joltik").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "joltik").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "joltik").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "joltik").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "galvantula").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "galvantula").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "galvantula").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "galvantula").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "galvantula").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "golett").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "golett").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "golett").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "golett").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "golett").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.choke = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.parry = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.ragefist = ["9L1"];
    this.modData("Learnsets", "golurk").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "cobalion").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "cobalion").learnset.parry = ["9L1"];
    this.modData("Learnsets", "cobalion").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "cobalion").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "cobalion").learnset.rage = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.rage = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "terrakion").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "virizion").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "virizion").learnset.rage = ["9L1"];
    this.modData("Learnsets", "virizion").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "virizion").learnset.ceaselessedge = ["9L1"];
    this.modData("Learnsets", "virizion").learnset.defog = ["9L1"];
    this.modData("Learnsets", "virizion").learnset.parry = ["9L1"];
    this.modData("Learnsets", "reshiram").learnset.defog = ["9L1"];
    this.modData("Learnsets", "reshiram").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "reshiram").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "reshiram").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "zekrom").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "zekrom").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "zekrom").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "kyurem").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "kyurem").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "keldeo").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "keldeo").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "espurr").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "espurr").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "espurr").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "espurr").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "espurr").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "meowstic").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "meowsticf").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "inkay").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "inkay").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "inkay").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "inkay").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.brickbreak = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.choke = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.rage = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "malamar").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "litten").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "torracat").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "torracat").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.choke = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.flyingpress = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.parry = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.rage = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.stormthrow = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "incineroar").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "popplio").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "popplio").learnset.round = ["9L1"];
    this.modData("Learnsets", "popplio").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "popplio").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "brionne").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "brionne").learnset.round = ["9L1"];
    this.modData("Learnsets", "brionne").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "brionne").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.round = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "primarina").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "pikipek").learnset.defog = ["9L1"];
    this.modData("Learnsets", "pikipek").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "pikipek").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "trumbeak").learnset.defog = ["9L1"];
    this.modData("Learnsets", "trumbeak").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "trumbeak").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.rage = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.tailslap = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.defog = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "toucannon").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "dewpider").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "araquanid").learnset.electroweb = ["9L1"];
    this.modData("Learnsets", "araquanid").learnset.pinmissile = ["9L1"];
    this.modData("Learnsets", "araquanid").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "araquanid").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "araquanid").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "araquanid").learnset.choke = ["9L1"];
    this.modData("Learnsets", "comfey").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "comfey").learnset.junglehealing = ["9L1"];
    this.modData("Learnsets", "comfey").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "comfey").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "comfey").learnset.rootpull = ["9L1"];
    this.modData("Learnsets", "comfey").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "minior").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "minior").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "minior").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "minior").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "minior").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "minior").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "minior").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "minior").learnset.desertstorm = ["9L1"];
    this.modData("Learnsets", "solgaleo").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "solgaleo").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "solgaleo").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "solgaleo").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "solgaleo").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "lunala").learnset.defog = ["9L1"];
    this.modData("Learnsets", "lunala").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "lunala").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "lunala").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "lunala").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "lunala").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.choke = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.lashout = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.throatchop = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.chisel = ["9L1"];
    this.modData("Learnsets", "necrozma").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "milcery").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "milcery").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "milcery").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "milcery").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "alcremie").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "alcremie").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "alcremie").learnset.lifedew = ["9L1"];
    this.modData("Learnsets", "alcremie").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.meteorbeam = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "duraludon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.echochamber = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "archaludon").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "gougingfire").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "gougingfire").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "gougingfire").learnset.rage = ["9L1"];
    this.modData("Learnsets", "gougingfire").learnset.ragingfury = ["9L1"];
    this.modData("Learnsets", "gougingfire").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "gougingfire").learnset.rekindle = ["9L1"];
    this.modData("Learnsets", "ragingbolt").learnset.chainlightning = ["9L1"];
    this.modData("Learnsets", "ragingbolt").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "ragingbolt").learnset.psychicfangs = ["9L1"];
    this.modData("Learnsets", "ragingbolt").learnset.rage = ["9L1"];
    this.modData("Learnsets", "ragingbolt").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.accelerock = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.rockblast = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.smackdown = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.stoneaxe = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "ironboulder").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.softwarecrash = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.shrapnelshot = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "ironcrown").learnset.sledgehammerblow = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.dragonrage = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.shelter = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.signalbeam = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.healingstones = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.rollout = ["9L1"];
    this.modData("Learnsets", "terapagos").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.cuttingremark = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.direclaw = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.hazardouswaste = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.latentvenom = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.naturalgift = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.peekaboo = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.snatch = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.falsesurrender = ["9L1"];
    this.modData("Learnsets", "pecharunt").learnset.choke = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.rapidspin = ["9L1"];
    this.modData("Learnsets", "revavroom").learnset.rebuild = ["9L1"];
    this.modData("Learnsets", "meloetta").learnset.psychoboost = ["9L1"];
    this.modData("Learnsets", "oricorio").learnset.heatwave = ["9L1"];
    this.modData("Learnsets", "muk").learnset.jetpunch = ["9L1"];
    this.modData("Learnsets", "muk").learnset.flipturn = ["9L1"];
    this.modData("Learnsets", "muk").learnset.washaway = ["9L1"];
    this.modData("Learnsets", "decidueye").learnset.thunderwave = ["9L1"];
    this.modData("Learnsets", "decidueye").learnset.vacuumwave = ["9L1"];
    this.modData("Learnsets", "charizard").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "vespiquen").learnset.pluck = ["9L1"];
    this.modData("Learnsets", "salamence").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "salamence").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "rufflet").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "landorus").learnset.windbreaker = ["9L1"];
    this.modData("Learnsets", "brambleghast").learnset.willowisp = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.explosion = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.choke = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.playrough = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.haze = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.swordsdance = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.tidyup = ["9L1"];
    this.modData("Learnsets", "snorlax").learnset.stealthrock = ["9L1"];
    this.modData("Learnsets", "haxorus").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "dragonite").learnset.skullbash = ["9L1"];
    this.modData("Learnsets", "zapdos").learnset.defog = ["9L1"];
    this.modData("Learnsets", "pyroar").learnset.nastyplot = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.tailglow = ["9L1"];
    this.modData("Learnsets", "screamtail").learnset.moonblast = ["9L1"];
  }
};
//# sourceMappingURL=scripts.js.map
