```json
{
  "title": "Suspicious Sand",
  "icon": "minecraft:suspicious_sand",
  "categories": [
    "minecraft:blocks",
    "minecraft:suspicious_blocks",
    "minecraft:group/functional_blocks"
  ],
  "associated_items": [
    "minecraft:suspicious_sand"
  ]
}
```

&spotlight(minecraft:suspicious_sand)
**Suspicious sand** is a fragile gravity-affected [suspicious block](^minecraft:suspicious_blocks) found in various Overworld structures. They can be [brushed](^minecraft:brush) to extract structure-dependent loot, and are a source of [pottery sherds](^minecraft:tag/decorated_pot_sherds) alongside [suspicious gravel](^minecraft:suspicious_gravel) and [trial chambers](^minecraft:trial_chambers).

;;;;;

&title(Breaking)
Suspicious sand is unobtainable by [mining](^minecraft:breaking), even using a tool enchanted with [Silk Touch](^minecraft:silk_touch). They are much softer than normal sand, and can be instantly broken with merely an unenchanted diamond shovel.

;;;;;

&title(Falling)
They are affected by gravity, but they always break with no drops after falling. They break immediately if pushed by a piston or sticky piston, and cannot be pulled by sticky pistons or slime blocks. They also break immediately without dropping when affected by explosions.

;;;;;

&title(Natural Generation)
Suspicious sand generates naturally in buried rooms under [desert pyramids](^minecraft:desert_pyramid), as well as in the bottom of [desert wells](^minecraft:desert_well). It also generates within warm [ocean ruins](^minecraft:ocean_ruins).

;;;;;

&title(Brushing)
When a brush is used (<keybind;key.use>) on suspicious sand, cracks start to appear on all sides of the block as the dusted block state of the block starts to increase. If the suspicious sand being brushed is naturally generated, an item gradually emerges from the side where the player starts brushing. 

;;;;;

&title(Interrupted Brushing)
After 96 (6+20+30+40 per stage) game ticks (4.8 seconds), the item is extracted, and the suspicious sand is converted into sand.


If the player stops brushing a suspicious sand, the block remains in its half-excavated state for a few seconds, before gradually returning to its unexcavated state one stage at a time.

;;;;;

&title(Loot)
The item obtained and the loot table of suspicious sand is dependent on which [structure](^minecraft:structures) it has generated in. Items can be extracted only from naturally generated suspicious sand. When placed by the player, nothing is produced after brushing.