```json
{
  "title": "Sculk Sensor",
  "icon": "minecraft:sculk_sensor",
  "categories": [
    "minecraft:blocks",
    "minecraft:group/natural_blocks",
    "minecraft:group/redstone_blocks"
  ],
  "associated_items": [
    "minecraft:sculk_sensor"
  ]
}
```

&spotlight(minecraft:sculk_sensor)
The **sculk sensor** is a block in the [sculk](^minecraft:sculk) family. It detects vibrations caused by actions and events in a radius around it and emits a redstone signal, and, if it was triggered by a player, also activates nearby [sculk shriekers](^minecraft:sculk_shrieker). 

;;;;;

&title(Breaking)
A sculk sensor can be [mined](^minecraft:breaking) with any [tool](^minecraft:tool), but hoes are the quickest. It drops itself only if mined with any tool enchanted with Silk Touch. If mined with a non-Silk Touch tool, it drops 5 experience instead.

;;;;;

&title(Natural Generation)
Sculk sensors generate within the [deep dark biome](^minecraft:deep_dark) and [ancient cities](^minecraft:ancient_city).

;;;;;

&title(Post-Generation)
A [sculk catalyst](^minecraft:sculk_catalyst) has a 9% chance of generating a sculk sensor on top of a sculk block. 

;;;;;

&title(Crafting Ingredient)
Sculk sensors can be used to craft [calibrated sculk sensors](^minecraft:calibrated_sculk_sensor).

<recipe;calibrated_sculk_sensor>

;;;;;

&title(Light)
A sculk sensor has a light level of 1. When active, it changes to a lighter block state without a change to the light level.

;;;;;

&title(Vibration Detection)
Sculk sensors detect vibrations in an 8 block spherical radius around it. Vibrations are caused by various events, such as players and [mobs](^minecraft:mobs) walking, placing or [breaking](^minecraft:breaking) blocks, gliding with elytra, items falling on the ground, shooting projectiles, a piston extending or a wet wolf shaking itself off. 

;;;;;

&title(Vibration Frequency)
Vibrations have an associated frequency; different events create vibrations of different frequencies.

;;;;;

&title(Redstone Emission)
Sculk sensors emit a redstone signal when they are activated. The strength of the redstone signal is inversely proportional to the distance the vibration signal traveled – the closer the vibration is to the sculk sensor, the stronger the redstone signal is, so it reaches the maximum redstone signal strength when the vibration is directly on top of the sensor.