```json
{
  "title": "Chiseled Bookshelf",
  "icon": "minecraft:chiseled_bookshelf",
  "categories": [
    "minecraft:blocks",
    "minecraft:group/functional_blocks",
    "minecraft:group/redstone_blocks"
  ],
  "associated_items": [
    "minecraft:chiseled_bookshelf"
  ]
}
```

&spotlight(minecraft:chiseled_bookshelf)
**Chiseled bookshelves** are blocks that can hold books, books and quills, written books, enchanted books and knowledge books.

;;;;;

&title(Crafting)
<recipe;chiseled_bookshelf>

;;;;;

&title(Breaking)
Chiseled bookshelves can be destroyed with any [tool](^minecraft:tool), but an [axe](^minecraft:tag/axes) mines it the fastest. When broken, all contained books are dropped as items. The block itself drops only when broken using a tool enchanted with Silk Touch.

;;;;;

&title(Holding Books)
Chiseled bookshelves can hold up to six books, books and quills, written books, enchanted books, and/or knowledge books. There is no GUI; books are instead added into the bookshelf by using on a slot with a book. Doing so places a book in that slot. Using on an occupied slot removes the book from that slot.

;;;;;

&title(Redstone Signal)
A redstone comparator sends a signal (1–6) indicating the last slot interacted with. When no slot has been interacted with yet, it outputs 0.


An observer can detect when a book is added or removed from the bookshelf. 

;;;;;

![Chisled Bookshelf Power](minecraft:textures/gui/image/chiseled_bookshelf_power.png,fit)

The correspondences between slot and signal power.

;;;;;

&title(Hoppers)
Hoppers and minecart with hoppers can insert and remove books from the bookshelf. As with any other container, items are taken from the first slot that has an item that can fit in the hopper and are inserted into the first empty slot. 


Droppers behave similarly when inserting books into the bookshelf.

;;;;;

&title(Full Bookshelf)
When a hopper that is not already 100% full fails to remove a book from a non-empty bookshelf because there is no room for the book in the hopper's inventory, that is still counted as an "interaction" with the slot. Thus, a hopper that cannot remove any of the books effectively sets the last-interacted slot to the last non-empty slot in the bookshelf.

;;;;;

&title(Fuel)
Chiseled bookshelves can be used as fuel in [furnaces](^minecraft:furnace) to smelt 1.5 items.

;;;;;

&title(Note Blocks)
Chiseled bookshelves can be placed under note blocks to produce a "bass" sound. 
