package cn.mangofanfan.fanwindow.client.screen;

import cn.mangofanfan.fanwindow.client.GlobalState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_4189;
import net.minecraft.class_426;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4749;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_8020;
import net.minecraft.class_8082;
import net.minecraft.class_8219;
import net.minecraft.class_8662;

public class MainWindowScreen extends class_437 {
    // 定位点
    private int cenX;
    private int cenY;

    class_2960 bgTexture;
    private final class_8020 logoDrawer;

    // 单人游戏
    private volatile class_4185 singlePlayerButton;
    // 多人游戏
    private volatile class_4185 multiPlayerButton;
    // 选项
    private volatile class_4185 optionsButton;
    // 退出
    private volatile class_4185 quitButton;
    // 切换按钮
    private volatile class_4185 toggleButton;
    // 语言
    private volatile class_8662 languageOptionButton;
    // 无障碍
    private volatile class_8662 accessibilityOptionButton;
    // 版权
    private volatile class_4185 copyrightButton;
    // 设置按钮
    private volatile class_4185 configButton;
    // ModMenu支持
    private volatile class_4185 modMenuButton;

    private final GlobalState globalState;
    private static final Logger logger = LoggerFactory.getLogger(MainWindowScreen.class);
    private static final class_310 client = class_310.method_1551();

    public MainWindowScreen(class_2561 title) {
        super(title);
        globalState = GlobalState.getInstance();
        logoDrawer = new class_8020(false);
        bgTexture = class_2960.method_60655("fanwindow", "textures/gui/bg_1.21.png");
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        cenX = field_22789 - 160;
        cenY = field_22790 - 160;

        this.singlePlayerButton = class_4185.method_46430(class_2561.method_43471("menu.singleplayer"),
                button -> field_22787.method_1507(new class_526(this)))
                .method_46434(cenX, cenY, 60, 60)
                .method_46431();
        this.multiPlayerButton = class_4185.method_46430(class_2561.method_43471("menu.multiplayer"),
                button -> {
                    class_437 screen = field_22787.field_1690.field_21840 ? new class_500(this) : new class_4749(this);
                    field_22787.method_1507(screen);
                })
                .method_46434(cenX + 65, cenY, 60, 60)
                .method_46431();
        this.optionsButton = class_4185.method_46430(class_2561.method_43471("menu.options"),
                button -> field_22787.method_1507(new class_429(this, field_22787.field_1690)))
                .method_46434(cenX, cenY + 65, 60, 60)
                .method_46431();
        this.quitButton = class_4185.method_46430(class_2561.method_43471("menu.quit"),
                button -> field_22787.method_1592())
                .method_46434(cenX + 65, cenY + 65, 60, 60)
                .method_46431();
        this.toggleButton = class_4185.method_46430(class_2561.method_30163("</>"),
                        button -> {
                            GlobalState globalState = GlobalState.getInstance();
                            globalState.setStarted(true);
                            globalState.setNewMainWindowInUse(false);
                            field_22787.method_1507(new class_442());
                        })
                .method_46434(cenX + 130, cenY, 27, 27)
                .method_46431();
        this.languageOptionButton = class_8082.method_48592(27,
                button -> field_22787.method_1507(new class_426(this, field_22787.field_1690, field_22787.method_1526())),
                true);
        this.languageOptionButton.method_53533(27);
        this.languageOptionButton.method_48229(cenX + 130, cenY + 33);
        this.accessibilityOptionButton = class_8082.method_48594(27,
                button -> field_22787.method_1507(new class_4189(this, field_22787.field_1690)),
                true);
        this.accessibilityOptionButton.method_53533(27);
        this.accessibilityOptionButton.method_48229(cenX + 130, cenY + 65);
        this.copyrightButton = class_4185.method_46430(class_2561.method_30163("©"),
                button -> field_22787.method_1507(new class_8219(this)))
                .method_46434(cenX + 130, cenY + 98, 27, 27)
                .method_46431();

        this.method_37063(singlePlayerButton);
        this.method_37063(multiPlayerButton);
        this.method_37063(optionsButton);
        this.method_37063(quitButton);
        this.method_37063(toggleButton);
        this.method_37063(languageOptionButton);
        this.method_37063(accessibilityOptionButton);
        this.method_37063(copyrightButton);

        // 如果有ModMenu则添加打开ModsScreen的按钮
        if (globalState.isModMenuSupport()) {
            try {
                Class<?> ModsScreen = Class.forName("com.terraformersmc.modmenu.gui.ModsScreen");
                Class<?>[] paramTypes = { class_437.class };
                class_4185.class_7840 builder = getBuilder(ModsScreen, paramTypes);
                this.modMenuButton = builder.method_46431();
                this.method_37063(modMenuButton);
            } catch (ClassNotFoundException e) {
                logger.error("Could not load ModsScreen while ModMenu is already loaded : ", e);
            }
        }
        // 否则添加打开本模组配置页面的按钮
        else {
            this.configButton = class_4185.method_46430(class_2561.method_43471("fanwindow.config"),
                            button -> {
                                ConfigManager configManager = ConfigManager.getInstance();
                                field_22787.method_1507(configManager.getScreen(this));
                                logger.debug("Open FanWindow ConfigScreen from FanWindow Title Screen.");
                            })
                    .method_46434(cenX, cenY + 130, 60, 27)
                    .method_46431();
            this.method_37063(configButton);
        }
    }

    // 此方法只用来打开ModsScreen屏幕
    private class_4185.@NotNull class_7840 getBuilder(Class<?> ModsScreen, Class<?>[] paramTypes) {
        class_4185.class_7840 builder = class_4185.method_46430(class_2561.method_43471("category.modmenu.name"),
                button -> {
                    try {
                        field_22787.method_1507((class_437) ModsScreen.getDeclaredConstructor(paramTypes).newInstance(this));
                        logger.debug("Open ModsScreen from FanWindow Title Screen.");
                    } catch (InstantiationException | IllegalAccessException | InvocationTargetException |
                             NoSuchMethodException e) {
                        logger.error("Could not instantiate ModsScreen while ModMenu is already loaded : ", e);
                        field_22787.method_1566().
                                method_1999(class_370.method_29047(field_22787,
                                        class_370.class_9037.field_47589,
                                        class_2561.method_43471("fanwindow.modmenu.modsScreenFailed.title"),
                                        class_2561.method_43471("fanwindow.modmenu.modsScreenFailed.description")));
                    }
                });
        builder.method_46434(cenX, cenY + 130, 60, 27);
        return builder;
    }

    @Override
    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        // 强制重新初始化布局
        this.method_37067();
        this.method_25426();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        logoDrawer.method_48210(context, field_22789 / 5 * 3, 1.0F, field_22790 - 50);
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        context.method_25290(class_1921::method_62276, bgTexture, 0, 0, 0, 0, field_22789, field_22790, field_22789, field_22790);
    }

    @Override
    public void method_25419() {
        if (field_22787 != null) {
            field_22787.method_1507(new class_442());
        }
    }
}