package cn.mangofanfan.fanwindow.mixin.client;

import cn.mangofanfan.fanwindow.client.GlobalState;
import cn.mangofanfan.fanwindow.client.screen.ConfigManager;
import cn.mangofanfan.fanwindow.client.screen.MainWindowScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_442.class)
public class TitleScreenMixin extends class_437 {
    @Unique
    Logger logger;
    @Unique
    GlobalState globalState = GlobalState.getInstance();
    @Unique
    ConfigManager configManager = ConfigManager.getInstance();
    protected TitleScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "init", at = @At("HEAD"))
    private void onInit(CallbackInfo ci) {
        // create toggle button
        class_4185 toggleButton = class_4185.method_46430(class_2561.method_30163(">_<"),
                        (class_4185 button) -> {
            globalState.setNewMainWindowInUse(true);
            class_310.method_1551().method_1507(new MainWindowScreen(class_2561.method_30163(">_<")));
        })
                .method_46434(0, 0, 30, 30).method_46431();
        this.method_37063(toggleButton);

        logger = LoggerFactory.getLogger("TitleScreenMixin");
    }

    @Inject(method = "init", at = @At("RETURN"))
    private void afterInit(CallbackInfo ci) {
        // 若设置中禁用新版TitleScreen则使用原版TitleScreen
        if (!configManager.config.useNewTitleScreen) {
            logger.info("Use vanilla Title Screen due to config...");
            return;
        }

        // 启动游戏、建立TitleScreen时
        if (!globalState.isStarted()) {
            logger.info("Change to MainWindowScreen...");
            class_310.method_1551().method_1507(new MainWindowScreen(class_2561.method_30163(">_<")));
        } else if (globalState.isNewMainWindowInUse()) {
            logger.info("Back to MainWindowScreen...");
            class_310.method_1551().method_1507(new MainWindowScreen(class_2561.method_30163(">_<")));
        } else {
            logger.info("Return vanilla Title Screen.");
        }
    }
}