package cn.mangofanfan.fanwindow.mixin.client;

import cn.mangofanfan.fanwindow.client.screen.ConfigManager;
import cn.mangofanfan.fanwindow.client.screen.NewCreateWorldScreenGameTab;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_525.class_8094;
import net.minecraft.class_525.class_8095;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8100;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_525.class)
public class CreateWorldScreenMixin extends class_437 {
    @Shadow
    private class_8089 tabNavigation;
    @Final
    @Shadow
    private class_8088 tabManager;
    @Final
    @Shadow
    private class_8132 layout;
    @Final
    @Shadow
    class_8100 worldCreator;

    @Unique
    ConfigManager configManager = ConfigManager.getInstance();

    protected CreateWorldScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "init", at = @At("HEAD"), cancellable = true)
    protected void onInit(CallbackInfo ci) {
        // 检查配置
        if (!configManager.config.isUseNewCreateWorldScreen()) {
            return;
        }
        // 获取 CreateWorldScreen 实例
        class_525 self = (class_525)(Object)this;
        class_8089.class_8090 builder = class_8089.method_48623(this.tabManager, this.field_22789);
        builder.method_48631(new NewCreateWorldScreenGameTab(self), self.new class_8095(), self.new class_8094());
        this.tabNavigation = builder
                .method_48627();
        this.method_37063(this.tabNavigation);
        class_8667 directionalLayoutWidget = this.layout.method_48996(class_8667.method_52742().method_52735(8));
        directionalLayoutWidget.method_52736(class_4185.method_46430(class_2561.method_43471("selectWorld.create"), button -> this.createLevel()).method_46431());
        directionalLayoutWidget.method_52736(class_4185.method_46430(class_5244.field_24335, button -> this.onCloseScreen()).method_46431());
        this.layout.method_48206(child -> {
            child.method_48591(1);
            this.method_37063(child);
        });
        this.tabNavigation.method_48987(0, false);
        this.worldCreator.method_48695();
        this.method_48640();
        ci.cancel();
    }

    @Shadow
    public void onCloseScreen() {}

    @Shadow
    private void createLevel() {}
}

