/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.fanwindow.client.config;

import cn.mangofanfan.fanwindow.client.config.BgPicture;
import cn.mangofanfan.fanwindow.client.config.CustomPictureMode;
import cn.mangofanfan.fanwindow.client.config.DefaultBgPictureGetter;
import cn.mangofanfan.fanwindow.client.config.FanWindowConfig;
import cn.mangofanfan.fanwindow.client.function.LocalBackgroundTextureIdentifier;
import cn.mangofanfan.fanwindow.client.function.MinecraftVersionGetter;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Path CUSTOM_IMAGE = FabricLoader.getInstance().getConfigDir().resolve("fanwindow/custom.png");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("fanwindow/fanwindow.json");
    private static ConfigManager instance;
    private final ConfigBuilder configBuilder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43471((String)"fanwindow.config.title"));
    private ConfigCategory generalCategory;
    private ConfigCategory customBackgroundCategory;
    private ConfigCategory functionalCategory;
    private LocalBackgroundTextureIdentifier localBackgroundTextureIdentifier;
    public FanWindowConfig config;
    static Logger logger;

    private ConfigManager() {
        this.loadConfig();
        if (this.config.getCustomPictureMode().equals((Object)CustomPictureMode.ConfigDir)) {
            this.localBackgroundTextureIdentifier = new LocalBackgroundTextureIdentifier(CUSTOM_IMAGE);
        }
        this.configBuilder.setSavingRunnable(() -> {
            this.saveConfig();
            logger.info("Saving config of Fan Window.");
        });
    }

    public void loadConfig() {
        try {
            Files.createDirectory(FabricLoader.getInstance().getConfigDir().resolve("fanwindow"), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            this.config = (FanWindowConfig)new Gson().fromJson((Reader)reader, FanWindowConfig.class);
        }
        catch (IOException | NoSuchFieldError e) {
            this.config = new FanWindowConfig();
            this.saveConfig();
        }
    }

    public void saveConfig() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            new Gson().toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            logger.error("Exception occurred when saving FanWindow config !{}", (Object)String.valueOf(e));
        }
    }

    public static synchronized ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public class_437 getScreen(class_437 parent) {
        logger.debug("Getting ConfigScreen instance.");
        this.initConfigOptions();
        this.configBuilder.setParentScreen(parent);
        return this.configBuilder.build();
    }

    private void initConfigOptions() {
        if (this.generalCategory != null && this.customBackgroundCategory != null) {
            this.generalCategory.removeCategory();
            this.customBackgroundCategory.removeCategory();
            this.functionalCategory.removeCategory();
        }
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        this.generalCategory = this.configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"fanwindow.config.general"));
        this.customBackgroundCategory = this.configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"fanwindow.config.customBackground"));
        this.functionalCategory = this.configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"fanwindow.config.functional"));
        this.generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"fanwindow.config.description")).build());
        this.generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.useNewTitleScreen"), this.config.isUseNewTitleScreen()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.useNewTitleScreen.description")}).setSaveConsumer(newValue -> this.config.setUseNewTitleScreen((boolean)newValue)).build());
        this.generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.disableVanillaTitleScreen"), this.config.isDisableVanillaTitleScreen()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.disableVanillaTitleScreen.description")}).setSaveConsumer(newValue -> this.config.setDisableVanillaTitleScreen((boolean)newValue)).build());
        this.generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.useNewCreateWorldScreen"), this.config.isUseNewCreateWorldScreen()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.useNewCreateWorldScreen.description")}).setSaveConsumer(newValue -> this.config.setUseNewCreateWorldScreen((boolean)newValue)).build());
        this.generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.useNewBackgroundInNewScreen"), this.config.isUseNewBackgroundInNewScreen()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.useNewBackgroundInNewScreen.description")}).setSaveConsumer(newValue -> this.config.setUseNewBackgroundInNewScreen((boolean)newValue)).build());
        this.generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.useNewBackgroundGlobally"), this.config.isUseNewBackgroundGlobally()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.useNewBackgroundGlobally.description")}).setSaveConsumer(newValue -> this.config.setUseNewBackgroundGlobally((boolean)newValue)).build());
        this.customBackgroundCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu((class_2561)class_2561.method_43471((String)"fanwindow.config.customBackgroundImageMode"), DropdownMenuBuilder.TopCellElementBuilder.of((Object)((Object)this.config.getCustomPictureMode()), this::stringToCustomPictureMode, this::customPictureModeToString)).setDefaultValue((Object)CustomPictureMode.Disabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.customBackgroundImageMode.description")}).setSelections(List.of(CustomPictureMode.values())).setSaveConsumer(this::saveCustomPictureMode).build());
        this.customBackgroundCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"fanwindow.config.customBackground.description")).build());
        this.customBackgroundCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu((class_2561)class_2561.method_43471((String)"fanwindow.config.background"), DropdownMenuBuilder.TopCellElementBuilder.of((Object)((Object)this.config.getBgPicture()), this::stringToBgPicture, this::bgPictureToText)).setDefaultValue((Object)DefaultBgPictureGetter.getDefaultBgPicture()).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.background.description")}).setSelections(List.of(BgPicture.values())).setSaveConsumer(this::saveBgPicture).build());
        this.customBackgroundCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43469((String)"fanwindow.config.background.versionFeaturedDescription", (Object[])new Object[]{DefaultBgPictureGetter.getDefaultBgPicture().getPicName(), MinecraftVersionGetter.getMinecraftVersion()})).build());
        this.functionalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.exitWorldConfirm"), this.config.isExitWorldConfirm()).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.exitWorldConfirm.description")}).setDefaultValue(this.config.isExitWorldConfirm()).setSaveConsumer(newValue -> this.config.setExitWorldConfirm((boolean)newValue)).build());
        this.functionalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.exitMinecraftConfirm"), this.config.isExitMinecraftConfirm()).setDefaultValue(this.config.isExitMinecraftConfirm()).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.exitMinecraftConfirm.description")}).setSaveConsumer(newValue -> this.config.setExitMinecraftConfirm((boolean)newValue)).build());
        this.functionalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"fanwindow.config.enableAutoReconnect"), this.config.isEnableAutoReconnect()).setDefaultValue(this.config.isEnableAutoReconnect()).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.enableAutoReconnect.description")}).setSaveConsumer(newValue -> this.config.setEnableAutoReconnect((boolean)newValue)).build());
        this.functionalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"fanwindow.config.autoReconnectWaitTime"), this.config.getAutoReconnectWaitTime()).setDefaultValue(this.config.getAutoReconnectWaitTime()).setTooltip(new class_2561[]{class_2561.method_43471((String)"fanwindow.config.autoReconnectWaitTime.description")}).setSaveConsumer(newValue -> this.config.setAutoReconnectWaitTime((int)newValue)).build());
    }

    private void saveBgPicture(BgPicture bgPicture) {
        this.config.setBgPicture(bgPicture);
    }

    private void saveCustomPictureMode(CustomPictureMode customPictureMode) {
        this.config.setCustomPictureMode(customPictureMode);
        if (this.config.getCustomPictureMode().equals((Object)CustomPictureMode.ConfigDir)) {
            this.localBackgroundTextureIdentifier = new LocalBackgroundTextureIdentifier(CUSTOM_IMAGE);
        }
    }

    private BgPicture stringToBgPicture(String value) {
        for (BgPicture bgPicture : BgPicture.values()) {
            if (!bgPicture.name().equalsIgnoreCase(value)) continue;
            return bgPicture;
        }
        return null;
    }

    private class_2561 bgPictureToText(BgPicture bgPicture) {
        return class_2561.method_30163((String)bgPicture.name());
    }

    private CustomPictureMode stringToCustomPictureMode(String value) {
        for (CustomPictureMode customPictureMod : CustomPictureMode.values()) {
            if (!customPictureMod.name().equalsIgnoreCase(value)) continue;
            return customPictureMod;
        }
        return null;
    }

    private class_2561 customPictureModeToString(CustomPictureMode customPictureMode) {
        return class_2561.method_30163((String)customPictureMode.name());
    }

    public class_2960 getBackgroundTexture() {
        class_2960 identifier = null;
        switch (this.config.getCustomPictureMode()) {
            case Disabled: {
                identifier = class_2960.method_60655((String)"fanwindow", (String)this.config.getBgPicture().getPath());
                break;
            }
            case ResourcePack: {
                identifier = class_2960.method_60655((String)"fanwindow", (String)"textures/artwork/custom.png");
                break;
            }
            case ConfigDir: {
                identifier = this.localBackgroundTextureIdentifier.getIdentifier();
            }
        }
        return identifier;
    }

    public int[] getBackgroundTextureSize() {
        int[] textureSize = new int[]{0, 0};
        switch (this.config.getCustomPictureMode()) {
            case Disabled: {
                textureSize = this.config.getBgPicture().getPicSize();
                break;
            }
            case ResourcePack: {
                textureSize = new int[]{1600, 900};
                break;
            }
            case ConfigDir: {
                textureSize = this.localBackgroundTextureIdentifier.getTextureSize();
            }
        }
        return textureSize;
    }

    static {
        logger = LoggerFactory.getLogger(ConfigManager.class);
    }
}

