package cn.mangofanfan.fanwindow.mixin.client;

import cn.mangofanfan.fanwindow.client.config.ConfigManager;
import cn.mangofanfan.fanwindow.client.function.SimpleToastBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_433;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_310.class)
public abstract class MinecraftClientMixin {
    @Unique
    private long lastDisconnectTime = 0;

    @Inject(method = "disconnect(Lnet/minecraft/text/Text;)V", at = @At("HEAD"), cancellable = true)
    public void onDisconnect(class_2561 reasonText, CallbackInfo ci) {
        // 如果没有启用退出世界确认，则无事发生
        if (!ConfigManager.getInstance().config.isExitWorldConfirm()) return;

        // 否则，需要连续尝试退出两次才允许退出
        if (System.currentTimeMillis() - lastDisconnectTime > 30000) {
            lastDisconnectTime = System.currentTimeMillis();
            new SimpleToastBuilder().show(
                    class_2561.method_43471("gui.fanwindow.exit_world_confirm.title"),
                    class_2561.method_43471("gui.fanwindow.exit_world_confirm.description")
            );
            if (class_310.method_1551().field_1755 != null) {
                class_433 screen = (class_433) class_310.method_1551().field_1755;
                if (screen.field_40792 != null) {
                    screen.field_40792.field_22763 = true;
                }
            }
            ci.cancel();
        }
    }
}
