package cn.mangofanfan.fanwindow.client.function;

import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.client.texture.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class LocalBackgroundTextureIdentifier {
    class_2960 identifier;
    int[] textureSize;
    Logger logger = LoggerFactory.getLogger(LocalBackgroundTextureIdentifier.class);
    SimpleToastBuilder toastBuilder =  new SimpleToastBuilder();

    public LocalBackgroundTextureIdentifier(Path filePath) {
        try {
            String path = "dynamic/textures/custom.png";
            class_1011 nativeImage = class_1011.method_4309(Files.newInputStream(filePath));
            identifier = class_2960.method_60655("fanwindow", path);
            textureSize = new int[]{nativeImage.method_4307(), nativeImage.method_4323()};

            class_1043 texture = new NativeResourceLoaderImpl().getNativeImageBackedTexture(path, nativeImage);
            class_310.method_1551().method_1531().method_4616(identifier, texture);
            logger.info("Successfully loaded Background Texture in Config Dir at {}", filePath);
        }
        catch (IOException e) {
            // 未找到图片的错误处理
            logger.warn("Error loading Local Background Texture in Config Dir at {}", filePath);
            logger.warn("If your Custom Background Picture Mode is ConfigDir, you will get a default image as background.");
            toastBuilder.show(class_2561.method_43471("fanwindow.toast.localIdentifierNotFound.title"), class_2561.method_43471("fanwindow.toast.localIdentifierNotFound.description"));
            identifier = class_2960.method_60655("fanwindow", "textures/artwork/custom.png");
            textureSize = new int[]{1600, 900};
        }
    }

    public class_2960 getIdentifier() {
        return identifier;
    }

    public int[] getTextureSize() {
        return  textureSize;
    }
}
