package cn.mangofanfan.fanwindow.mixin.client;

import cn.mangofanfan.fanwindow.client.function.RenderBackgroundImpl;
import cn.mangofanfan.fanwindow.client.config.ConfigManager;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_437.class)
public abstract class ScreenMixin extends class_362 implements class_4068 {
    @Unique
    ConfigManager configManager;

    /*
    在这里使用 @Shadow 获取例如 client 之类的属性会导致游戏内渲染问题，因此在下面重新获取了 client 实例。
    我也不知道为什么喵！
    */

    @Inject(method = "renderBackground", at = @At("HEAD"), cancellable = true)
    private void onRenderBackground(CallbackInfo ci,
                                    @Local(argsOnly = true) class_332 context,
                                    @Local(argsOnly = true) float deltaTicks) {
        class_310 client = class_310.method_1551();
        configManager = ConfigManager.getInstance();
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        if (client.field_1687 == null) {
            Logger logger = LoggerFactory.getLogger("ScreenMixin");
            logger.debug("ScreenMixin is ready to change global background.");
            if (configManager.config.isUseNewBackgroundGlobally()) {
                new RenderBackgroundImpl().renderBackground(context, width, height);
                logger.debug("ScreenMixin background has been rendered.");
                ci.cancel();
            }
            else {
                logger.debug("According to config, ScreenMixin return.");
            }
        }
    }
}
