/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.fanwindow.client.function;

import cn.mangofanfan.fanwindow.client.function.NativeResourceLoaderImpl;
import cn.mangofanfan.fanwindow.client.function.SimpleToastBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class LocalBackgroundTextureIdentifier {
    class_2960 identifier;
    int[] textureSize;
    Logger logger = LoggerFactory.getLogger(LocalBackgroundTextureIdentifier.class);
    SimpleToastBuilder toastBuilder = new SimpleToastBuilder();

    public LocalBackgroundTextureIdentifier(Path filePath) {
        try {
            String path = "dynamic/textures/custom.png";
            class_1011 nativeImage = class_1011.method_4309((InputStream)Files.newInputStream(filePath, new OpenOption[0]));
            this.identifier = class_2960.method_60655((String)"fanwindow", (String)path);
            this.textureSize = new int[]{nativeImage.method_4307(), nativeImage.method_4323()};
            class_1043 texture = new NativeResourceLoaderImpl().getNativeImageBackedTexture(path, nativeImage);
            class_310.method_1551().method_1531().method_4616(this.identifier, (class_1044)texture);
            this.logger.info("Successfully loaded Background Texture in Config Dir at {}", (Object)filePath);
        }
        catch (IOException e) {
            this.logger.warn("Error loading Local Background Texture in Config Dir at {}", (Object)filePath);
            this.logger.warn("If your Custom Background Picture Mode is ConfigDir, you will get a default image as background.");
            this.toastBuilder.show((class_2561)class_2561.method_43471((String)"fanwindow.toast.localIdentifierNotFound.title"), (class_2561)class_2561.method_43471((String)"fanwindow.toast.localIdentifierNotFound.description"));
            this.identifier = class_2960.method_60655((String)"fanwindow", (String)"textures/artwork/custom.png");
            this.textureSize = new int[]{1600, 900};
        }
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public int[] getTextureSize() {
        return this.textureSize;
    }
}

